/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class CastShortToLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Eh)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends Long256Function
    implements UnaryFunction {
        private final Function arg;
        private final Long256Impl long256a = new Long256Impl();
        private final Long256Impl long256b = new Long256Impl();

        public Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public Long256 getLong256A(Record rec) {
            this.long256a.setAll(this.arg.getShort(rec), 0L, 0L, 0L);
            return this.long256a;
        }

        @Override
        public Long256 getLong256B(Record rec) {
            this.long256b.setAll(this.arg.getShort(rec), 0L, 0L, 0L);
            return this.long256b;
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            Numbers.appendLong256(this.arg.getShort(rec), 0L, 0L, 0L, sink);
        }
    }
}

