/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastIntToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(In)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastIntToTimestampFunction(args.getQuick(0));
    }

    public static class CastIntToTimestampFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;

        public CastIntToTimestampFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getTimestamp(Record rec) {
            int value = this.arg.getInt(rec);
            return value != Integer.MIN_VALUE ? (long)value : Long.MIN_VALUE;
        }
    }
}

