/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractToSymbolCastFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastIntToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ik)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(arg.getInt(null));
            return SymbolConstant.newInstance(sink);
        }
        return new Func(arg);
    }

    private static class Func
    extends AbstractToSymbolCastFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            int value = this.arg.getInt(rec);
            if (value == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return this.getInt0(value);
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            int value = this.arg.getInt(rec);
            if (value == Integer.MIN_VALUE) {
                return null;
            }
            return this.getSymbol0(value);
        }

        @Override
        protected AbstractToSymbolCastFunction newFunc() {
            return new Func(this.arg);
        }
    }
}

