/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractToSymbolCastFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastFloatToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Fk)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(arg.getFloat(null), 4);
            return SymbolConstant.newInstance(sink);
        }
        return new Func(arg);
    }

    private static class Func
    extends AbstractToSymbolCastFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            float value = this.arg.getFloat(rec);
            if (Float.isNaN(value)) {
                return Integer.MIN_VALUE;
            }
            int key = Float.floatToIntBits(value);
            return this.getInt0(key);
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            float value = this.arg.getFloat(rec);
            if (Float.isNaN(value)) {
                return null;
            }
            int key = Float.floatToIntBits(value);
            int keyIndex = this.symbolTableShortcut.keyIndex(key);
            if (keyIndex < 0) {
                return (CharSequence)this.symbols.getQuick(this.symbolTableShortcut.valueAt(keyIndex));
            }
            this.symbolTableShortcut.putAt(keyIndex, key, this.next++);
            this.sink.clear();
            this.sink.put(value, 4);
            String str = Chars.toString(this.sink);
            this.symbols.add(Chars.toString(this.sink));
            return str;
        }

        @Override
        protected AbstractToSymbolCastFunction newFunc() {
            return new Func(this.arg);
        }
    }
}

