/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.AbstractUnaryTimestampFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastCharToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(An)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastCharToTimestampFunction(args.getQuick(0));
    }

    public static class CastCharToTimestampFunction
    extends AbstractUnaryTimestampFunction {
        public CastCharToTimestampFunction(Function arg) {
            super(arg);
        }

        @Override
        public long getTimestamp(Record rec) {
            byte v = (byte)(this.arg.getChar(rec) - 48);
            return v > -1 && v < 10 ? (long)v : Long.MIN_VALUE;
        }
    }
}

