/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class CastByteToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Bs)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function intFunc = args.getQuick(0);
        if (intFunc.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(intFunc.getByte(null));
            return new StrConstant(Chars.toString(sink));
        }
        return new CastByteToStrFunction(args.getQuick(0));
    }

    public static class CastByteToStrFunction
    extends StrFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public CastByteToStrFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            this.sinkA.clear();
            this.sinkA.put(this.arg.getByte(rec));
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            this.sinkB.put(this.arg.getByte(rec));
            return this.sinkB;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            sink.put(this.arg.getByte(rec));
        }
    }
}

