/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class IntArrayDereferenceHackFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "[](II)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new StrArrayDereferenceFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class StrArrayDereferenceFunction
    extends IntFunction
    implements BinaryFunction {
        private final Function arrayFunction;
        private final Function indexFunction;

        public StrArrayDereferenceFunction(Function arrayFunction, Function indexFunction) {
            this.arrayFunction = arrayFunction;
            this.indexFunction = indexFunction;
        }

        @Override
        public int getInt(Record rec) {
            return 0;
        }

        @Override
        public Function getLeft() {
            return this.arrayFunction;
        }

        @Override
        public Function getRight() {
            return this.indexFunction;
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }
    }
}

