/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.analytic;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.SingleColumnType;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.AnalyticSPI;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.analytic.AnalyticContext;
import io.questdb.griffin.engine.analytic.AnalyticFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class RowNumberFunctionFactory
implements FunctionFactory {
    private static final SingleColumnType LONG_COLUMN_TYPE = new SingleColumnType(6);

    @Override
    public String getSignature() {
        return "row_number()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        AnalyticContext analyticContext = sqlExecutionContext.getAnalyticContext();
        if (analyticContext.getPartitionByRecord() != null) {
            Map map = MapFactory.createMap(configuration, analyticContext.getPartitionByKeyTypes(), LONG_COLUMN_TYPE);
            return new RowNumberFunction(map, analyticContext.getPartitionByRecord(), analyticContext.getPartitionBySink());
        }
        return new SequenceRowNumberFunction();
    }

    private static class RowNumberFunction
    extends LongFunction
    implements ScalarFunction,
    AnalyticFunction,
    Reopenable {
        private final Map map;
        private final VirtualRecord partitionByRecord;
        private final RecordSink partitionBySink;
        private int columnIndex;

        public RowNumberFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink) {
            this.map = map;
            this.partitionByRecord = partitionByRecord;
            this.partitionBySink = partitionBySink;
        }

        @Override
        public void close() {
            Misc.free(this.map);
            Misc.free(this.partitionByRecord.getFunctions());
        }

        @Override
        public long getLong(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void pass1(Record record, long recordOffset, AnalyticSPI spi) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            long x = value.isNew() ? 0L : value.getLong(0);
            value.putLong(0, x + 1L);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), x);
        }

        @Override
        public void preparePass2(RecordCursor cursor) {
        }

        @Override
        public void pass2(Record record) {
        }

        @Override
        public void reopen() {
            this.map.reopen();
        }

        @Override
        public void reset() {
            this.map.close();
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }
    }

    private static class SequenceRowNumberFunction
    extends LongFunction
    implements ScalarFunction {
        private long next = 1L;

        private SequenceRowNumberFunction() {
        }

        @Override
        public long getLong(Record rec) {
            return this.next++;
        }

        @Override
        public void toTop() {
            this.next = 1L;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.toTop();
        }
    }
}

