/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.analytic;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.analytic.AnalyticFunction;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedAnalyticRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final CachedAnalyticRecordCursor cursor;
    private final RecordCursorFactory base;
    private final int orderedGroupCount;
    private final ObjList<ObjList<AnalyticFunction>> orderedFunctions;
    @Nullable
    private final ObjList<AnalyticFunction> unorderedFunctions;
    private final ObjList<AnalyticFunction> allFunctions;
    private final ObjList<RecordComparator> comparators;
    private boolean closed = false;

    public CachedAnalyticRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordSink recordSink, GenericRecordMetadata metadata, ColumnTypes chainMetadata, ObjList<RecordComparator> comparators, ObjList<ObjList<AnalyticFunction>> orderedFunctions, @Nullable ObjList<AnalyticFunction> unorderedFunctions, @NotNull IntList columnIndexes) {
        super(metadata);
        int i;
        this.base = base;
        this.orderedGroupCount = comparators.size();
        assert (this.orderedGroupCount == orderedFunctions.size());
        this.orderedFunctions = orderedFunctions;
        this.comparators = comparators;
        RecordChain recordChain = new RecordChain(chainMetadata, recordSink, configuration.getSqlAnalyticStorePageSize(), configuration.getSqlAnalyticStoreMaxPages());
        ObjList<LongTreeChain> orderedSources = new ObjList<LongTreeChain>(this.orderedGroupCount);
        for (i = 0; i < this.orderedGroupCount; ++i) {
            orderedSources.add(new LongTreeChain(configuration.getSqlAnalyticTreeKeyPageSize(), configuration.getSqlAnalyticTreeKeyMaxPages(), configuration.getSqlAnalyticRowIdPageSize(), configuration.getSqlAnalyticRowIdMaxPages()));
        }
        this.cursor = new CachedAnalyticRecordCursor(columnIndexes, recordChain, orderedSources);
        this.allFunctions = new ObjList();
        int n = orderedFunctions.size();
        for (i = 0; i < n; ++i) {
            this.allFunctions.addAll(orderedFunctions.getQuick(i));
        }
        if (unorderedFunctions != null) {
            this.allFunctions.addAll(unorderedFunctions);
        }
        this.unorderedFunctions = unorderedFunctions;
    }

    @Override
    protected void _close() {
        if (this.closed) {
            return;
        }
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.freeObjList(this.allFunctions);
        this.closed = true;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        this.cursor.of(baseCursor);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private void resetFunctions() {
        int n = this.allFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.allFunctions.getQuick(i).reset();
        }
    }

    public class CachedAnalyticRecordCursor
    implements RecordCursor {
        private final ObjList<LongTreeChain> orderedSources;
        private final RecordChain recordChain;
        private RecordCursor base;
        private final IntList columnIndexes;
        private boolean isOpen;

        public CachedAnalyticRecordCursor(IntList columnIndexes, RecordChain recordChain, ObjList<LongTreeChain> orderedSources) {
            this.columnIndexes = columnIndexes;
            this.recordChain = recordChain;
            this.recordChain.setSymbolTableResolver(this);
            this.isOpen = true;
            this.orderedSources = orderedSources;
        }

        private void of(RecordCursor base) {
            this.base = base;
            if (!this.isOpen) {
                this.recordChain.reopen();
                this.recordChain.setSymbolTableResolver(this);
                this.reopenTrees();
                this.reopen(CachedAnalyticRecordCursorFactory.this.allFunctions);
                this.isOpen = true;
            }
            this.buildRecordChain();
        }

        private void reopenTrees() {
            for (int i = 0; i < CachedAnalyticRecordCursorFactory.this.orderedGroupCount; ++i) {
                this.orderedSources.getQuick(i).reopen();
            }
        }

        private void reopen(ObjList list) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.getQuick(i) instanceof Reopenable)) continue;
                ((Reopenable)list.getQuick(i)).reopen();
            }
        }

        private void buildRecordChain() {
            int i;
            long offset = -1L;
            Record record = this.base.getRecord();
            Record chainRecord = this.recordChain.getRecord();
            Record chainRightRecord = this.recordChain.getRecordB();
            if (CachedAnalyticRecordCursorFactory.this.orderedGroupCount > 0) {
                while (this.base.hasNext()) {
                    offset = this.recordChain.put(record, offset);
                    this.recordChain.recordAt(chainRecord, offset);
                    for (i = 0; i < CachedAnalyticRecordCursorFactory.this.orderedGroupCount; ++i) {
                        this.orderedSources.getQuick(i).put(chainRecord, this.recordChain, chainRightRecord, (RecordComparator)CachedAnalyticRecordCursorFactory.this.comparators.getQuick(i));
                    }
                }
            } else {
                while (this.base.hasNext()) {
                    offset = this.recordChain.put(record, offset);
                }
            }
            if (CachedAnalyticRecordCursorFactory.this.orderedGroupCount > 0) {
                for (i = 0; i < CachedAnalyticRecordCursorFactory.this.orderedGroupCount; ++i) {
                    LongTreeChain tree = this.orderedSources.getQuick(i);
                    ObjList functions = (ObjList)CachedAnalyticRecordCursorFactory.this.orderedFunctions.getQuick(i);
                    LongTreeChain.TreeCursor cursor = tree.getCursor();
                    int functionCount = functions.size();
                    while (cursor.hasNext()) {
                        offset = cursor.next();
                        this.recordChain.recordAt(chainRecord, offset);
                        for (int j = 0; j < functionCount; ++j) {
                            ((AnalyticFunction)functions.getQuick(j)).pass1(chainRecord, offset, this.recordChain);
                        }
                    }
                }
            }
            if (CachedAnalyticRecordCursorFactory.this.unorderedFunctions != null) {
                int n = CachedAnalyticRecordCursorFactory.this.unorderedFunctions.size();
                for (int j = 0; j < n; ++j) {
                    AnalyticFunction f = (AnalyticFunction)CachedAnalyticRecordCursorFactory.this.unorderedFunctions.getQuick(j);
                    this.recordChain.toTop();
                    while (this.recordChain.hasNext()) {
                        f.pass1(chainRecord, chainRecord.getRowId(), this.recordChain);
                    }
                }
            }
            this.recordChain.toTop();
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.base.close();
                Misc.free(this.recordChain);
                int n = this.orderedSources.size();
                for (int i = 0; i < n; ++i) {
                    Misc.free(this.orderedSources.getQuick(i));
                }
                CachedAnalyticRecordCursorFactory.this.resetFunctions();
                this.isOpen = false;
            }
        }

        @Override
        public Record getRecord() {
            return this.recordChain.getRecord();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.base.newSymbolTable(this.columnIndexes.getQuick(columnIndex));
        }

        @Override
        public boolean hasNext() {
            return this.recordChain.hasNext();
        }

        @Override
        public long size() {
            return this.recordChain.size();
        }

        @Override
        public Record getRecordB() {
            return this.recordChain.getRecordB();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.recordChain.recordAt(record, atRowId);
        }

        @Override
        public void toTop() {
            this.recordChain.toTop();
        }
    }
}

