/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import org.jetbrains.annotations.Nullable;

public class LimitRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final LimitRecordCursor cursor;

    public LimitRecordCursorFactory(RecordCursorFactory base, Function loFunction, @Nullable Function hiFunction) {
        super(base.getMetadata());
        this.base = base;
        this.cursor = new LimitRecordCursor(loFunction, hiFunction);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(this.base.getCursor(executionContext), executionContext);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }

    private static class LimitRecordCursor
    implements RecordCursor {
        private final Function loFunction;
        private final Function hiFunction;
        private RecordCursor base;
        private long limit;
        private long size;

        public LimitRecordCursor(Function loFunction, Function hiFunction) {
            this.loFunction = loFunction;
            this.hiFunction = hiFunction;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public long size() {
            if (this.size > -1L) {
                return this.size;
            }
            return -1L;
        }

        @Override
        public Record getRecord() {
            return this.base.getRecord();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(columnIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.base.newSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            return this.limit-- > 0L && this.base.hasNext();
        }

        @Override
        public Record getRecordB() {
            return this.base.getRecordB();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.base.recordAt(record, atRowId);
        }

        public void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
            this.base = base;
            this.loFunction.init(base, executionContext);
            if (this.hiFunction != null) {
                this.hiFunction.init(base, executionContext);
            }
            this.toTop();
        }

        @Override
        public void toTop() {
            this.base.toTop();
            long lo = this.loFunction.getLong(null);
            if (lo < 0L && this.hiFunction == null) {
                long count = this.countRows();
                this.base.toTop();
                if (count > -lo) {
                    this.skipTo(count + lo);
                }
                this.size = this.limit = Math.min(count, -lo);
            } else if (lo > -1L && this.hiFunction == null) {
                long baseRowCount = this.base.size();
                this.limit = baseRowCount > -1L ? Math.min(baseRowCount, lo) : lo;
                this.size = this.limit;
            } else {
                long hi = this.hiFunction.getLong(null);
                if (lo < 0L) {
                    if (lo < hi) {
                        long count = this.countRows();
                        if (count >= -hi) {
                            this.base.toTop();
                            if (count < -lo) {
                                this.limit = count + hi;
                            } else {
                                this.skipTo(count + lo);
                                this.limit = Math.min(count, -lo + hi);
                            }
                            this.size = this.limit;
                        }
                    } else {
                        this.limit = 0L;
                        this.size = 0L;
                    }
                } else {
                    if (hi < 0L) {
                        this.size = this.limit = Math.max(this.countRows() - lo + hi, 0L);
                        this.base.toTop();
                    } else {
                        long baseRowCount = this.base.size();
                        this.size = baseRowCount > -1L ? (this.limit = Math.max(0L, Math.min(baseRowCount, hi) - lo)) : (this.limit = Math.max(0L, hi - lo));
                    }
                    if (lo > 0L && this.limit > 0L) {
                        this.skipTo(lo);
                    }
                }
            }
        }

        private long countRows() {
            long count = this.base.size();
            if (count > -1L) {
                return count;
            }
            count = 0L;
            while (this.base.hasNext()) {
                ++count;
            }
            return count;
        }

        @Override
        public void skipTo(long rowCount) {
            this.base.skipTo(Math.max(0L, rowCount));
        }
    }
}

