/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.QueryFutureUpdateListener;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.analytic.AnalyticContext;
import io.questdb.griffin.engine.analytic.AnalyticContextImpl;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.IntStack;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.tasks.TelemetryTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExecutionContextImpl
implements SqlExecutionContext {
    private final IntStack timestampRequiredStack = new IntStack();
    private final int workerCount;
    private final int sharedWorkerCount;
    private final CairoConfiguration cairoConfiguration;
    private final CairoEngine cairoEngine;
    private final MicrosecondClock clock;
    private final AnalyticContextImpl analyticContext = new AnalyticContextImpl();
    private final RingQueue<TelemetryTask> telemetryQueue;
    private Sequence telemetryPubSeq;
    private TelemetryTask.TelemetryMethod telemetryMethod = this::storeTelemetryNoop;
    private BindVariableService bindVariableService;
    private CairoSecurityContext cairoSecurityContext;
    private Rnd random;
    private long requestFd = -1L;
    private SqlExecutionCircuitBreaker circuitBreaker = SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER;
    private long now;
    private int jitMode;
    private boolean cloneSymbolTables = false;

    public SqlExecutionContextImpl(CairoEngine cairoEngine, int workerCount, int sharedWorkerCount) {
        this.cairoConfiguration = cairoEngine.getConfiguration();
        assert (workerCount > 0);
        this.workerCount = workerCount;
        assert (sharedWorkerCount > 0);
        this.sharedWorkerCount = sharedWorkerCount;
        this.cairoEngine = cairoEngine;
        this.clock = this.cairoConfiguration.getMicrosecondClock();
        this.cairoSecurityContext = AllowAllCairoSecurityContext.INSTANCE;
        this.jitMode = this.cairoConfiguration.getSqlJitMode();
        this.telemetryQueue = cairoEngine.getTelemetryQueue();
        if (this.telemetryQueue != null) {
            this.telemetryPubSeq = cairoEngine.getTelemetryPubSequence();
            this.telemetryMethod = this::doStoreTelemetry;
        }
    }

    public SqlExecutionContextImpl(CairoEngine cairoEngine, int workerCount) {
        this(cairoEngine, workerCount, workerCount);
    }

    @Override
    public QueryFutureUpdateListener getQueryFutureUpdateListener() {
        return QueryFutureUpdateListener.EMPTY;
    }

    @Override
    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    @Override
    public CairoSecurityContext getCairoSecurityContext() {
        return this.cairoSecurityContext;
    }

    @Override
    public boolean isTimestampRequired() {
        return this.timestampRequiredStack.notEmpty() && this.timestampRequiredStack.peek() == 1;
    }

    @Override
    public void popTimestampRequiredFlag() {
        this.timestampRequiredStack.pop();
    }

    @Override
    public void pushTimestampRequiredFlag(boolean flag) {
        this.timestampRequiredStack.push(flag ? 1 : 0);
    }

    @Override
    public int getWorkerCount() {
        return this.workerCount;
    }

    @Override
    public int getSharedWorkerCount() {
        return this.sharedWorkerCount;
    }

    @Override
    public Rnd getRandom() {
        return this.random != null ? this.random : SharedRandom.getRandom(this.cairoConfiguration);
    }

    @Override
    public void setRandom(Rnd rnd) {
        this.random = rnd;
    }

    @Override
    @NotNull
    public CairoEngine getCairoEngine() {
        return this.cairoEngine;
    }

    @Override
    public long getRequestFd() {
        return this.requestFd;
    }

    @Override
    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker() {
        this.circuitBreaker.resetTimer();
        return this.circuitBreaker;
    }

    @Override
    public void storeTelemetry(short event, short origin) {
        this.telemetryMethod.store(event, origin);
    }

    @Override
    public AnalyticContext getAnalyticContext() {
        return this.analyticContext;
    }

    @Override
    public void configureAnalyticContext(@Nullable VirtualRecord partitionByRecord, @Nullable RecordSink partitionBySink, @Nullable ColumnTypes partitionByKeyTypes, boolean ordered, boolean baseSupportsRandomAccess) {
        this.analyticContext.of(partitionByRecord, partitionBySink, partitionByKeyTypes, ordered, baseSupportsRandomAccess);
    }

    @Override
    public void initNow() {
        this.now = this.cairoConfiguration.getMicrosecondClock().getTicks();
    }

    @Override
    public long getNow() {
        return this.now;
    }

    @Override
    public int getJitMode() {
        return this.jitMode;
    }

    @Override
    public void setJitMode(int jitMode) {
        this.jitMode = jitMode;
    }

    public SqlExecutionContextImpl with(@NotNull CairoSecurityContext cairoSecurityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd) {
        this.cairoSecurityContext = cairoSecurityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        return this;
    }

    @Override
    public void setCloneSymbolTables(boolean cloneSymbolTables) {
        this.cloneSymbolTables = cloneSymbolTables;
    }

    public SqlExecutionContextImpl with(long requestFd) {
        this.requestFd = requestFd;
        return this;
    }

    public SqlExecutionContextImpl with(@NotNull CairoSecurityContext cairoSecurityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd, long requestFd, @Nullable SqlExecutionCircuitBreaker circuitBreaker) {
        this.cairoSecurityContext = cairoSecurityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        this.requestFd = requestFd;
        this.circuitBreaker = null == circuitBreaker ? SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER : circuitBreaker;
        return this;
    }

    private void doStoreTelemetry(short event, short origin) {
        TelemetryTask.store(this.telemetryQueue, this.telemetryPubSeq, event, origin, this.clock);
    }

    private void storeTelemetryNoop(short event, short origin) {
    }

    @Override
    public boolean getCloneSymbolTables() {
        return this.cloneSymbolTables;
    }
}

