/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IndexBuilder;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursor;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.VacuumColumnVersions;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextImportException;
import io.questdb.cutlass.text.TextImportExecutionContext;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.BatchCallback;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.CompiledQueryImpl;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.InsertRowImpl;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.RecordToRowCopierUtils;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.catalogue.ShowDateStyleCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowMaxIdentifierLengthCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowSearchPathCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowStandardConformingStringsCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowTimeZoneFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowTransactionIsolationLevelCursorFactory;
import io.questdb.griffin.engine.ops.AlterOperationBuilder;
import io.questdb.griffin.engine.ops.CopyFactory;
import io.questdb.griffin.engine.ops.InsertOperationImpl;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.griffin.engine.table.ShowColumnsRecordCursorFactory;
import io.questdb.griffin.engine.table.TableListRecordCursorFactory;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Sinkable;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompiler
implements Closeable {
    public static final ObjList<String> sqlControlSymbols = new ObjList(8);
    private static final Log LOG = LogFactory.getLog(SqlCompiler.class);
    private static final IntList castGroups = new IntList();
    private static final BatchCallback EMPTY_CALLBACK = new BatchCallback(){

        @Override
        public void postCompile(SqlCompiler compiler, CompiledQuery cq, CharSequence queryText) {
        }

        @Override
        public void preCompile(SqlCompiler compiler) {
        }
    };
    protected final CairoEngine engine;
    private final GenericLexer lexer;
    private final Path path = new Path();
    private final CharSequenceObjHashMap<KeywordBasedExecutor> keywordBasedExecutors = new CharSequenceObjHashMap();
    private final CompiledQueryImpl compiledQuery;
    private final AlterOperationBuilder alterOperationBuilder;
    private final SqlOptimiser optimiser;
    private final SqlParser parser;
    private final ObjectPool<ExpressionNode> sqlNodePool;
    private final CharacterStore characterStore;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final SqlCodeGenerator codeGenerator;
    private final CairoConfiguration configuration;
    private final Path renamePath = new Path();
    private final DatabaseBackupAgent backupAgent;
    private final DatabaseSnapshotAgent snapshotAgent;
    private final MemoryMARW mem = Vm.getMARWInstance();
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final MessageBus messageBus;
    private final ListColumnFilter listColumnFilter = new ListColumnFilter();
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final IntIntHashMap typeCast = new IntIntHashMap();
    private final ObjList<TableWriter> tableWriters = new ObjList();
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final FunctionParser functionParser;
    private final ExecutableMethod insertAsSelectMethod = this::insertAsSelect;
    private final TextLoader textLoader;
    private final FilesFacade ff;
    private final TimestampValueRecord partitionFunctionRec = new TimestampValueRecord();
    private final IndexBuilder rebuildIndex = new IndexBuilder();
    private final VacuumColumnVersions vacuumColumnVersions;
    private boolean isSingleQueryMode = true;
    private long insertCount;
    private final ExecutableMethod createTableMethod = this::createTable;

    public SqlCompiler(CairoEngine engine) {
        this(engine, null, null);
    }

    public SqlCompiler(CairoEngine engine, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.ff = this.configuration.getFilesFacade();
        this.messageBus = engine.getMessageBus();
        this.sqlNodePool = new ObjectPool<ExpressionNode>(ExpressionNode.FACTORY, this.configuration.getSqlExpressionPoolCapacity());
        this.queryColumnPool = new ObjectPool<QueryColumn>(QueryColumn.FACTORY, this.configuration.getSqlColumnPoolCapacity());
        this.queryModelPool = new ObjectPool<QueryModel>(QueryModel.FACTORY, this.configuration.getSqlModelPoolCapacity());
        this.compiledQuery = new CompiledQueryImpl(engine);
        this.characterStore = new CharacterStore(this.configuration.getSqlCharacterStoreCapacity(), this.configuration.getSqlCharacterStoreSequencePoolCapacity());
        this.lexer = new GenericLexer(this.configuration.getSqlLexerPoolCapacity());
        this.functionParser = new FunctionParser(this.configuration, functionFactoryCache != null ? functionFactoryCache : new FunctionFactoryCache(engine.getConfiguration(), ServiceLoader.load(FunctionFactory.class, FunctionFactory.class.getClassLoader())));
        this.codeGenerator = new SqlCodeGenerator(engine, this.configuration, this.functionParser, this.sqlNodePool);
        this.vacuumColumnVersions = new VacuumColumnVersions(engine);
        this.functionParser.setSqlCodeGenerator(this.codeGenerator);
        this.backupAgent = new DatabaseBackupAgent();
        this.snapshotAgent = snapshotAgent;
        KeywordBasedExecutor compileSet = this::compileSet;
        KeywordBasedExecutor compileBegin = this::compileBegin;
        KeywordBasedExecutor compileCommit = this::compileCommit;
        KeywordBasedExecutor compileRollback = this::compileRollback;
        KeywordBasedExecutor truncateTables = this::truncateTables;
        KeywordBasedExecutor alterTable = this::alterTable;
        KeywordBasedExecutor repairTables = this::repairTables;
        KeywordBasedExecutor reindexTable = this::reindexTable;
        KeywordBasedExecutor dropTable = this::dropTable;
        KeywordBasedExecutor sqlBackup = x$0 -> this.backupAgent.sqlBackup(x$0);
        KeywordBasedExecutor sqlShow = this::sqlShow;
        KeywordBasedExecutor vacuumTable = this::vacuum;
        KeywordBasedExecutor snapshotDatabase = this::snapshotDatabase;
        KeywordBasedExecutor compileDeallocate = this::compileDeallocate;
        this.keywordBasedExecutors.put("truncate", truncateTables);
        this.keywordBasedExecutors.put("TRUNCATE", truncateTables);
        this.keywordBasedExecutors.put("alter", alterTable);
        this.keywordBasedExecutors.put("ALTER", alterTable);
        this.keywordBasedExecutors.put("repair", repairTables);
        this.keywordBasedExecutors.put("REPAIR", repairTables);
        this.keywordBasedExecutors.put("reindex", reindexTable);
        this.keywordBasedExecutors.put("REINDEX", reindexTable);
        this.keywordBasedExecutors.put("set", compileSet);
        this.keywordBasedExecutors.put("SET", compileSet);
        this.keywordBasedExecutors.put("begin", compileBegin);
        this.keywordBasedExecutors.put("BEGIN", compileBegin);
        this.keywordBasedExecutors.put("commit", compileCommit);
        this.keywordBasedExecutors.put("COMMIT", compileCommit);
        this.keywordBasedExecutors.put("rollback", compileRollback);
        this.keywordBasedExecutors.put("ROLLBACK", compileRollback);
        this.keywordBasedExecutors.put("discard", compileSet);
        this.keywordBasedExecutors.put("DISCARD", compileSet);
        this.keywordBasedExecutors.put("close", compileSet);
        this.keywordBasedExecutors.put("CLOSE", compileSet);
        this.keywordBasedExecutors.put("unlisten", compileSet);
        this.keywordBasedExecutors.put("UNLISTEN", compileSet);
        this.keywordBasedExecutors.put("reset", compileSet);
        this.keywordBasedExecutors.put("RESET", compileSet);
        this.keywordBasedExecutors.put("drop", dropTable);
        this.keywordBasedExecutors.put("DROP", dropTable);
        this.keywordBasedExecutors.put("backup", sqlBackup);
        this.keywordBasedExecutors.put("BACKUP", sqlBackup);
        this.keywordBasedExecutors.put("show", sqlShow);
        this.keywordBasedExecutors.put("SHOW", sqlShow);
        this.keywordBasedExecutors.put("vacuum", vacuumTable);
        this.keywordBasedExecutors.put("VACUUM", vacuumTable);
        this.keywordBasedExecutors.put("snapshot", snapshotDatabase);
        this.keywordBasedExecutors.put("SNAPSHOT", snapshotDatabase);
        this.keywordBasedExecutors.put("deallocate", compileDeallocate);
        this.keywordBasedExecutors.put("DEALLOCATE", compileDeallocate);
        SqlCompiler.configureLexer(this.lexer);
        PostOrderTreeTraversalAlgo postOrderTreeTraversalAlgo = new PostOrderTreeTraversalAlgo();
        this.optimiser = new SqlOptimiser(this.configuration, engine, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo, this.functionParser, this.path);
        this.parser = new SqlParser(this.configuration, this.optimiser, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo);
        this.textLoader = new TextLoader(engine);
        this.alterOperationBuilder = new AlterOperationBuilder();
    }

    public static void configureLexer(GenericLexer lexer) {
        int i;
        int k = sqlControlSymbols.size();
        for (i = 0; i < k; ++i) {
            lexer.defineSymbol(sqlControlSymbols.getQuick(i));
        }
        k = OperatorExpression.operators.size();
        for (i = 0; i < k; ++i) {
            OperatorExpression op = OperatorExpression.operators.getQuick(i);
            if (!op.symbol) continue;
            lexer.defineSymbol(op.token);
        }
    }

    @Override
    public void close() {
        this.backupAgent.close();
        this.codeGenerator.close();
        this.vacuumColumnVersions.close();
        Misc.free(this.path);
        Misc.free(this.renamePath);
        Misc.free(this.textLoader);
        Misc.free(this.rebuildIndex);
    }

    @NotNull
    public CompiledQuery compile(@NotNull CharSequence query, @NotNull SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        this.isSingleQueryMode = true;
        this.compileInner(executionContext);
        this.compiledQuery.withContext(executionContext);
        return this.compiledQuery;
    }

    public void compileBatch(@NotNull CharSequence query, @NotNull SqlExecutionContext executionContext, BatchCallback batchCallback) throws SqlException, PeerIsSlowToReadException, PeerDisconnectedException {
        LOG.info().$("batch [text=").$(query).I$();
        this.clear();
        this.lexer.of(query);
        this.isSingleQueryMode = false;
        if (batchCallback == null) {
            batchCallback = EMPTY_CALLBACK;
        }
        while (this.lexer.hasNext()) {
            int position = this.getNextValidTokenPosition();
            if (position == -1) {
                return;
            }
            boolean recompileStale = true;
            int retries = 0;
            while (recompileStale) {
                try {
                    batchCallback.preCompile(this);
                    this.clear();
                    CompiledQuery current = this.compileInner(executionContext);
                    CharSequence currentQuery = query.subSequence(position, this.goToQueryEnd());
                    batchCallback.postCompile(this, current, currentQuery);
                    recompileStale = false;
                }
                catch (ReaderOutOfDateException e) {
                    if (retries == 10) {
                        throw e;
                    }
                    LOG.info().$(e.getFlyweightMessage()).$();
                    this.lexer.restart();
                }
                ++retries;
            }
        }
    }

    public void filterPartitions(Function function, TableReader reader, AlterOperationBuilder changePartitionStatement) {
        for (int i = reader.getPartitionCount() - 2; i > -1; --i) {
            long partitionTimestamp = reader.getPartitionTimestampByIndex(i);
            this.partitionFunctionRec.setTimestamp(partitionTimestamp);
            if (!function.getBool(this.partitionFunctionRec)) continue;
            changePartitionStatement.ofPartition(partitionTimestamp);
        }
    }

    public CairoEngine getEngine() {
        return this.engine;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionParser.getFunctionFactoryCache();
    }

    private static boolean isCompatibleCase(int from, int to) {
        return castGroups.getQuick(ColumnType.tagOf(from)) == castGroups.getQuick(ColumnType.tagOf(to));
    }

    private static void expectKeyword(GenericLexer lexer, CharSequence keyword) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(keyword).put("' expected");
        }
        if (!Chars.equalsLowerCaseAscii(tok, keyword)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(keyword).put("' expected");
        }
    }

    private static CharSequence expectToken(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
        }
        return tok;
    }

    private static CharSequence maybeExpectToken(GenericLexer lexer, CharSequence expected, boolean expect) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (expect && tok == null) {
            throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
        }
        return tok;
    }

    private CompiledQuery alterSystemLockWriter(SqlExecutionContext executionContext) throws SqlException {
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        this.tableExistsOrFail(tableNamePosition, tok, executionContext);
        try {
            CharSequence lockedReason = this.engine.lockWriter(executionContext.getCairoSecurityContext(), tok, "alterSystem");
            if (lockedReason != WriterPool.OWNERSHIP_REASON_NONE) {
                throw SqlException.$(tableNamePosition, "could not lock, busy [table=`").put(tok).put(", lockedReason=").put(lockedReason).put("`]");
            }
            return this.compiledQuery.ofLock();
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private CompiledQuery alterSystemUnlockWriter(SqlExecutionContext executionContext) throws SqlException {
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        this.tableExistsOrFail(tableNamePosition, tok, executionContext);
        try {
            this.engine.unlockWriter(executionContext.getCairoSecurityContext(), tok);
            return this.compiledQuery.ofUnlock();
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompiledQuery alterTable(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'table' or 'system'");
        if (SqlKeywords.isTableKeyword(tok)) {
            int tableNamePosition = this.lexer.getPosition();
            tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
            this.tableExistsOrFail(tableNamePosition, tok, executionContext);
            CharSequence name = GenericLexer.immutableOf(tok);
            try (TableReader reader = this.engine.getReaderForStatement(executionContext, name, "alter table");){
                String tableName = reader.getTableName();
                TableReaderMetadata tableMetadata = reader.getMetadata();
                tok = SqlCompiler.expectToken(this.lexer, "'add', 'alter' or 'drop'");
                if (SqlKeywords.isAddKeyword(tok)) {
                    CompiledQuery compiledQuery = this.alterTableAddColumn(tableNamePosition, tableName, tableMetadata);
                    return compiledQuery;
                }
                if (SqlKeywords.isDropKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'column' or 'partition'");
                    if (SqlKeywords.isColumnKeyword(tok)) {
                        CompiledQuery compiledQuery = this.alterTableDropColumn(tableNamePosition, tableName, tableMetadata);
                        return compiledQuery;
                    }
                    if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                    CompiledQuery compiledQuery = this.alterTableDropDetachOrAttachPartition(reader, 1, executionContext);
                    return compiledQuery;
                }
                if (SqlKeywords.isAttachKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'partition'");
                    if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                    CompiledQuery compiledQuery = this.alterTableDropDetachOrAttachPartition(reader, 2, executionContext);
                    return compiledQuery;
                }
                if (SqlKeywords.isDetachKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'partition'");
                    if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                    CompiledQuery compiledQuery = this.alterTableDropDetachOrAttachPartition(reader, 3, executionContext);
                    return compiledQuery;
                }
                if (SqlKeywords.isRenameKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'column'");
                    if (!SqlKeywords.isColumnKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' expected");
                    CompiledQuery compiledQuery = this.alterTableRenameColumn(tableNamePosition, tableName, tableMetadata);
                    return compiledQuery;
                }
                if (SqlKeywords.isAlterKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'column'");
                    if (!SqlKeywords.isColumnKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                    int columnNameNamePosition = this.lexer.getPosition();
                    tok = SqlCompiler.expectToken(this.lexer, "column name");
                    CharSequence columnName = GenericLexer.immutableOf(tok);
                    tok = SqlCompiler.expectToken(this.lexer, "'add index' or 'drop index' or 'cache' or 'nocache'");
                    if (SqlKeywords.isAddKeyword(tok)) {
                        SqlCompiler.expectKeyword(this.lexer, "index");
                        tok = SqlUtil.fetchNext(this.lexer);
                        int indexValueCapacity = -1;
                        if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                            if (!SqlKeywords.isCapacityKeyword(tok)) {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "'capacity' expected");
                            }
                            tok = SqlCompiler.expectToken(this.lexer, "capacity value");
                            try {
                                indexValueCapacity = Numbers.parseInt(tok);
                                if (indexValueCapacity <= 0) {
                                    throw SqlException.$(this.lexer.lastTokenPosition(), "positive integer literal expected as index capacity");
                                }
                            }
                            catch (NumericException e) {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "positive integer literal expected as index capacity");
                            }
                        }
                        CompiledQuery compiledQuery = this.alterTableColumnAddIndex(tableNamePosition, tableName, columnNameNamePosition, columnName, tableMetadata, indexValueCapacity);
                        return compiledQuery;
                    }
                    if (SqlKeywords.isDropKeyword(tok)) {
                        SqlCompiler.expectKeyword(this.lexer, "index");
                        tok = SqlUtil.fetchNext(this.lexer);
                        if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("] while trying to drop index");
                        }
                        CompiledQuery indexValueCapacity = this.alterTableColumnDropIndex(tableNamePosition, tableName, columnNameNamePosition, columnName, tableMetadata);
                        return indexValueCapacity;
                    }
                    if (SqlKeywords.isCacheKeyword(tok)) {
                        CompiledQuery indexValueCapacity = this.alterTableColumnCacheFlag(tableNamePosition, tableName, columnName, reader, true);
                        return indexValueCapacity;
                    }
                    if (!SqlKeywords.isNoCacheKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'add', 'drop', 'cache' or 'nocache' expected").put(" found '").put(tok).put('\'');
                    CompiledQuery indexValueCapacity = this.alterTableColumnCacheFlag(tableNamePosition, tableName, columnName, reader, false);
                    return indexValueCapacity;
                }
                if (!SqlKeywords.isSetKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'add', 'drop', 'attach', 'detach', 'set' or 'rename' expected");
                tok = SqlCompiler.expectToken(this.lexer, "'param'");
                if (!SqlKeywords.isParamKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'param' expected");
                int paramNameNamePosition = this.lexer.getPosition();
                tok = SqlCompiler.expectToken(this.lexer, "param name");
                CharSequence paramName = GenericLexer.immutableOf(tok);
                tok = SqlCompiler.expectToken(this.lexer, "'='");
                if (tok.length() == 1 && tok.charAt(0) == '=') {
                    CharSequence value = GenericLexer.immutableOf(SqlUtil.fetchNext(this.lexer));
                    CompiledQuery compiledQuery = this.alterTableSetParam(paramName, value, paramNameNamePosition, tableName, tableMetadata.getId());
                    return compiledQuery;
                }
                throw SqlException.$(this.lexer.lastTokenPosition(), "'=' expected");
            }
            catch (CairoException e) {
                LOG.info().$("could not alter table [table=").$(name).$(", ex=").$(e).$();
                throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(name).put("' could not be altered: ").put(e);
            }
        }
        if (!SqlKeywords.isSystemKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'table' or 'system' expected");
        tok = SqlCompiler.expectToken(this.lexer, "'lock' or 'unlock'");
        if (SqlKeywords.isLockKeyword(tok)) {
            tok = SqlCompiler.expectToken(this.lexer, "'writer'");
            if (!SqlKeywords.isWriterKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'writer' expected");
            return this.alterSystemLockWriter(executionContext);
        }
        if (!SqlKeywords.isUnlockKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'lock' or 'unlock' expected");
        tok = SqlCompiler.expectToken(this.lexer, "'writer'");
        if (!SqlKeywords.isWriterKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'writer' expected");
        return this.alterSystemUnlockWriter(executionContext);
    }

    private CompiledQuery alterTableAddColumn(int tableNamePosition, String tableName, TableReaderMetadata tableMetadata) throws SqlException {
        block33: {
            CharSequence tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && !SqlKeywords.isColumnKeyword(tok)) {
                this.lexer.unparseLast();
            }
            AlterOperationBuilder addColumn = this.alterOperationBuilder.ofAddColumn(tableNamePosition, tableName, tableMetadata.getId());
            int semicolonPos = -1;
            do {
                int indexValueBlockCapacity;
                boolean indexed;
                boolean cache;
                int symbolCapacity;
                tok = SqlCompiler.maybeExpectToken(this.lexer, "'column' or column name", semicolonPos < 0);
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block33;
                }
                int index = tableMetadata.getColumnIndexQuiet(tok);
                if (index != -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "column '").put(tok).put("' already exists");
                }
                CharSequence columnName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                if (!TableUtils.isValidColumnName(columnName, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                tok = SqlCompiler.expectToken(this.lexer, "column type");
                int type = ColumnType.tagOf(tok);
                if (type == -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "invalid type");
                }
                if (type == 23) {
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok == null || tok.charAt(0) != '(') {
                        throw SqlException.position(this.lexer.getPosition()).put("missing GEOHASH precision");
                    }
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok != null && tok.charAt(0) != ')') {
                        int geosizeBits = GeoHashUtil.parseGeoHashBits(this.lexer.lastTokenPosition(), 0, tok);
                        tok = SqlUtil.fetchNext(this.lexer);
                        if (tok == null || tok.charAt(0) != ')') {
                            if (tok != null) {
                                throw SqlException.position(this.lexer.lastTokenPosition()).put("invalid GEOHASH type literal, expected ')'").put(" found='").put(tok.charAt(0)).put("'");
                            }
                            throw SqlException.position(this.lexer.getPosition()).put("invalid GEOHASH type literal, expected ')'");
                        }
                        type = ColumnType.getGeoHashTypeWithBits(geosizeBits);
                    } else {
                        throw SqlException.position(this.lexer.lastTokenPosition()).put("missing GEOHASH precision");
                    }
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (ColumnType.isSymbol(type) && tok != null && !Chars.equals(tok, ',') && !Chars.equals(tok, ';')) {
                    if (SqlKeywords.isCapacityKeyword(tok)) {
                        boolean negative;
                        tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        int errorPos = this.lexer.lastTokenPosition();
                        if (Chars.equals(tok, '-')) {
                            negative = true;
                            tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        } else {
                            negative = false;
                        }
                        try {
                            symbolCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        if (negative) {
                            symbolCapacity = -symbolCapacity;
                        }
                        TableUtils.validateSymbolCapacity(errorPos, symbolCapacity);
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    }
                    if (Chars.equalsLowerCaseAsciiNc(tok, "cache")) {
                        cache = true;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else if (Chars.equalsLowerCaseAsciiNc(tok, "nocache")) {
                        cache = false;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        cache = this.configuration.getDefaultSymbolCacheFlag();
                    }
                    TableUtils.validateSymbolCapacityCached(cache, symbolCapacity, this.lexer.lastTokenPosition());
                    indexed = Chars.equalsLowerCaseAsciiNc(tok, "index");
                    if (indexed) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    if (Chars.equalsLowerCaseAsciiNc(tok, "capacity")) {
                        tok = SqlCompiler.expectToken(this.lexer, "symbol index capacity");
                        try {
                            indexValueBlockCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    }
                } else {
                    if (tok != null && SqlKeywords.isNotKeyword(tok)) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    if (tok != null && SqlKeywords.isNullKeyword(tok)) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    cache = this.configuration.getDefaultSymbolCacheFlag();
                    indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    indexed = false;
                }
                addColumn.ofAddColumn(columnName, type, Numbers.ceilPow2(symbolCapacity), cache, indexed, Numbers.ceilPow2(indexValueBlockCapacity));
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block33;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableColumnAddIndex(int tableNamePosition, String tableName, int columnNamePosition, CharSequence columnName, TableReaderMetadata metadata, int indexValueBlockSize) throws SqlException {
        if (metadata.getColumnIndexQuiet(columnName) == -1) {
            throw SqlException.invalidColumn(columnNamePosition, columnName);
        }
        if (indexValueBlockSize == -1) {
            indexValueBlockSize = this.configuration.getIndexValueBlockSize();
        }
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.ofAddIndex(tableNamePosition, tableName, metadata.getId(), columnName, Numbers.ceilPow2(indexValueBlockSize)).build());
    }

    private CompiledQuery alterTableColumnCacheFlag(int tableNamePosition, String tableName, CharSequence columnName, TableReader reader, boolean cache) throws SqlException {
        TableReaderMetadata metadata = reader.getMetadata();
        int columnIndex = metadata.getColumnIndexQuiet(columnName);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), columnName);
        }
        if (!ColumnType.isSymbol(metadata.getColumnType(columnIndex))) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "Invalid column type - Column should be of type symbol");
        }
        return cache ? this.compiledQuery.ofAlter(this.alterOperationBuilder.ofCacheSymbol(tableNamePosition, tableName, metadata.getId(), columnName).build()) : this.compiledQuery.ofAlter(this.alterOperationBuilder.ofRemoveCacheSymbol(tableNamePosition, tableName, metadata.getId(), columnName).build());
    }

    private CompiledQuery alterTableColumnDropIndex(int tableNamePosition, String tableName, int columnNamePosition, CharSequence columnName, TableReaderMetadata metadata) throws SqlException {
        if (metadata.getColumnIndexQuiet(columnName) == -1) {
            throw SqlException.invalidColumn(columnNamePosition, columnName);
        }
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.ofDropIndex(tableNamePosition, tableName, metadata.getId(), columnName).build());
    }

    private CompiledQuery alterTableDropColumn(int tableNamePosition, String tableName, TableReaderMetadata metadata) throws SqlException {
        block4: {
            CharSequence tok;
            AlterOperationBuilder dropColumnStatement = this.alterOperationBuilder.ofDropColumn(tableNamePosition, tableName, metadata.getId());
            int semicolonPos = -1;
            do {
                tok = GenericLexer.unquote(SqlCompiler.maybeExpectToken(this.lexer, "column name", semicolonPos < 0));
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block4;
                }
                if (metadata.getColumnIndexQuiet(tok) == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                CharSequence columnName = tok;
                dropColumnStatement.ofDropColumn(columnName);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block4;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableDropDetachOrAttachPartition(TableReader reader, int action, SqlExecutionContext executionContext) throws SqlException {
        int pos = this.lexer.lastTokenPosition();
        TableReaderMetadata readerMetadata = reader.getMetadata();
        if (readerMetadata.getPartitionBy() == 3) {
            throw SqlException.$(pos, "table is not partitioned");
        }
        String tableName = reader.getTableName();
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'list' or 'where'");
        if (SqlKeywords.isListKeyword(tok)) {
            return this.alterTableDropDetachOrAttachPartitionByList(reader, pos, action);
        }
        if (SqlKeywords.isWhereKeyword(tok)) {
            AlterOperationBuilder alterPartitionStatement;
            switch (action) {
                case 1: {
                    alterPartitionStatement = this.alterOperationBuilder.ofDropPartition(pos, tableName, reader.getMetadata().getId());
                    break;
                }
                case 3: {
                    alterPartitionStatement = this.alterOperationBuilder.ofDetachPartition(pos, tableName, reader.getMetadata().getId());
                    break;
                }
                default: {
                    throw SqlException.$(pos, "WHERE clause can only be used with command DROP PARTITION, or DETACH PARTITION");
                }
            }
            ExpressionNode expr = this.parser.expr(this.lexer, (QueryModel)null);
            String designatedTimestampColumnName = null;
            int tsIndex = readerMetadata.getTimestampIndex();
            if (tsIndex >= 0) {
                designatedTimestampColumnName = readerMetadata.getColumnName(tsIndex);
            }
            if (designatedTimestampColumnName != null) {
                GenericRecordMetadata metadata = new GenericRecordMetadata();
                metadata.add(new TableColumnMetadata(designatedTimestampColumnName, 0L, 8, null));
                Function function = this.functionParser.parseFunction(expr, metadata, executionContext);
                if (function != null && ColumnType.isBoolean(function.getType())) {
                    function.init(null, executionContext);
                    this.filterPartitions(function, reader, alterPartitionStatement);
                    return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
                }
                throw SqlException.$(this.lexer.lastTokenPosition(), "boolean expression expected");
            }
            throw SqlException.$(this.lexer.lastTokenPosition(), "this table does not have a designated timestamp column");
        }
        throw SqlException.$(this.lexer.lastTokenPosition(), "'list' or 'where' expected");
    }

    private CompiledQuery alterTableDropDetachOrAttachPartitionByList(TableReader reader, int pos, int action) throws SqlException {
        block11: {
            CharSequence tok;
            AlterOperationBuilder partitions;
            String tableName = reader.getTableName();
            switch (action) {
                case 1: {
                    partitions = this.alterOperationBuilder.ofDropPartition(pos, tableName, reader.getMetadata().getId());
                    break;
                }
                case 3: {
                    partitions = this.alterOperationBuilder.ofDetachPartition(pos, tableName, reader.getMetadata().getId());
                    break;
                }
                default: {
                    partitions = this.alterOperationBuilder.ofAttachPartition(pos, tableName, reader.getMetadata().getId());
                }
            }
            assert (action == 1 || action == 2 || action == 3);
            int semicolonPos = -1;
            do {
                long timestamp;
                tok = SqlCompiler.maybeExpectToken(this.lexer, "partition name", semicolonPos < 0);
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block11;
                }
                if (Chars.equals(tok, ',')) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "partition name missing");
                }
                CharSequence unquoted = GenericLexer.unquote(tok);
                try {
                    timestamp = PartitionBy.parsePartitionDirName(unquoted, reader.getPartitionedBy());
                }
                catch (CairoException e) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
                }
                partitions.ofPartition(timestamp);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block11;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableRenameColumn(int tableNamePosition, String tableName, TableReaderMetadata metadata) throws SqlException {
        block8: {
            CharSequence tok;
            AlterOperationBuilder renameColumnStatement = this.alterOperationBuilder.ofRenameColumn(tableNamePosition, tableName, metadata.getId());
            int hadSemicolonPos = -1;
            do {
                tok = GenericLexer.unquote(SqlCompiler.maybeExpectToken(this.lexer, "current column name", hadSemicolonPos < 0));
                if (hadSemicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(hadSemicolonPos, "',' expected");
                    }
                    break block8;
                }
                int columnIndex = metadata.getColumnIndexQuiet(tok);
                if (columnIndex == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                CharSequence existingName = GenericLexer.immutableOf(tok);
                tok = SqlCompiler.expectToken(this.lexer, "'to' expected");
                if (!SqlKeywords.isToKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'to' expected'");
                }
                tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "new column name"));
                if (Chars.equals(existingName, tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "new column name is identical to existing name");
                }
                if (metadata.getColumnIndexQuiet(tok) > -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " column already exists");
                }
                if (!TableUtils.isValidColumnName(tok, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                CharSequence newName = GenericLexer.immutableOf(tok);
                renameColumnStatement.ofRenameColumn(existingName, newName);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block8;
            } while ((hadSemicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableSetParam(CharSequence paramName, CharSequence value, int paramNameNamePosition, String tableName, int tableId) throws SqlException {
        if (SqlKeywords.isMaxUncommittedRowsKeyword(paramName)) {
            int maxUncommittedRows;
            try {
                maxUncommittedRows = Numbers.parseInt(value);
            }
            catch (NumericException e) {
                throw SqlException.$(paramNameNamePosition, "invalid value [value=").put(value).put(",parameter=").put(paramName).put(']');
            }
            if (maxUncommittedRows < 0) {
                throw SqlException.$(paramNameNamePosition, "maxUncommittedRows must be non negative");
            }
            return this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSetParamUncommittedRows(tableName, tableId, maxUncommittedRows).build());
        }
        if (SqlKeywords.isCommitLagKeyword(paramName)) {
            long commitLag = SqlUtil.expectMicros(value, paramNameNamePosition);
            if (commitLag < 0L) {
                throw SqlException.$(paramNameNamePosition, "commitLag must be non negative");
            }
            return this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSetParamCommitLag(tableName, tableId, commitLag).build());
        }
        throw SqlException.$(paramNameNamePosition, "unknown parameter '").put(paramName).put('\'');
    }

    private void cancelTextImport(CopyModel model) throws SqlException {
        long importId;
        assert (model.isCancel());
        TextImportExecutionContext textImportExecutionContext = this.engine.getTextImportExecutionContext();
        AtomicBooleanCircuitBreaker circuitBreaker = textImportExecutionContext.getCircuitBreaker();
        long inProgressImportId = textImportExecutionContext.getActiveImportId();
        if (inProgressImportId == -1L) {
            throw SqlException.$(0, "No active import to cancel.");
        }
        try {
            CharSequence idString = model.getTarget().token;
            int start = 0;
            int end = idString.length();
            if (Chars.isQuoted(idString)) {
                start = 1;
                --end;
            }
            importId = Numbers.parseHexLong(idString, start, end);
        }
        catch (NumericException e) {
            throw SqlException.$(0, "Provided id has invalid format.");
        }
        if (inProgressImportId != importId) {
            throw SqlException.$(0, "Active import has different id.");
        }
        circuitBreaker.cancel();
    }

    private void clear() {
        this.sqlNodePool.clear();
        this.characterStore.clear();
        this.queryColumnPool.clear();
        this.queryModelPool.clear();
        this.optimiser.clear();
        this.parser.clear();
        this.backupAgent.clear();
        this.alterOperationBuilder.clear();
        this.backupAgent.clear();
        this.functionParser.clear();
    }

    private CompiledQuery compileBegin(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofBegin();
    }

    private CompiledQuery compileCommit(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofCommit();
    }

    private ExecutionModel compileExecutionModel(SqlExecutionContext executionContext) throws SqlException {
        ExecutionModel model = this.parser.parse(this.lexer, executionContext);
        switch (model.getModelType()) {
            case 1: {
                return this.optimiser.optimise((QueryModel)model, executionContext);
            }
            case 4: {
                InsertModel insertModel = (InsertModel)model;
                if (insertModel.getQueryModel() != null) {
                    return this.validateAndOptimiseInsertAsSelect(insertModel, executionContext);
                }
                return this.lightlyValidateInsertModel(insertModel);
            }
            case 6: {
                this.optimiser.optimiseUpdate((QueryModel)model, executionContext);
                return model;
            }
        }
        return model;
    }

    private CompiledQuery compileInner(@NotNull SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(0, "empty query");
        }
        this.compiledQuery.withContext(executionContext);
        KeywordBasedExecutor executor = this.keywordBasedExecutors.get(tok);
        if (executor == null) {
            return this.compileUsingModel(executionContext);
        }
        return executor.execute(executionContext);
    }

    private CompiledQuery compileRollback(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofRollback();
    }

    private CompiledQuery compileSet(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofSet();
    }

    private CopyFactory compileTextImport(CopyModel model) throws SqlException {
        CharSequence fileName;
        assert (!model.isCancel());
        CharSequence tableName = GenericLexer.unquote(model.getTarget().token);
        ExpressionNode fileNameNode = model.getFileName();
        CharSequence charSequence = fileName = fileNameNode != null ? GenericLexer.assertNoDots(GenericLexer.unquote(fileNameNode.token), fileNameNode.position) : null;
        assert (fileName != null);
        return new CopyFactory(this.messageBus, this.engine.getTextImportExecutionContext(), Chars.toString(tableName), Chars.toString(fileName), model);
    }

    private CompiledQuery compileDeallocate(SqlExecutionContext executionContext) throws SqlException {
        CharSequence statementName = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "statement name"));
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("]");
        }
        return this.compiledQuery.ofDeallocate(statementName);
    }

    @NotNull
    private CompiledQuery compileUsingModel(SqlExecutionContext executionContext) throws SqlException {
        this.lexer.unparseLast();
        this.codeGenerator.clear();
        ExecutionModel executionModel = this.compileExecutionModel(executionContext);
        switch (executionModel.getModelType()) {
            case 1: {
                LOG.info().$("plan [q=`").$((QueryModel)executionModel).$("`, fd=").$(executionContext.getRequestFd()).$(']').$();
                return this.compiledQuery.of(this.generate((QueryModel)executionModel, executionContext));
            }
            case 2: {
                return this.createTableWithRetries(executionModel, executionContext);
            }
            case 5: {
                return this.executeCopy(executionContext, (CopyModel)executionModel);
            }
            case 3: {
                RenameTableModel rtm = (RenameTableModel)executionModel;
                this.engine.rename(executionContext.getCairoSecurityContext(), this.path, GenericLexer.unquote(rtm.getFrom().token), this.renamePath, GenericLexer.unquote(rtm.getTo().token));
                return this.compiledQuery.ofRenameTable();
            }
            case 6: {
                QueryModel updateQueryModel = (QueryModel)executionModel;
                UpdateOperation updateStatement = this.generateUpdate(updateQueryModel, executionContext);
                return this.compiledQuery.ofUpdate(updateStatement);
            }
        }
        InsertModel insertModel = (InsertModel)executionModel;
        if (insertModel.getQueryModel() != null) {
            return this.executeWithRetries(this.insertAsSelectMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
        }
        return this.insert(executionModel, executionContext);
    }

    private long copyOrdered(TableWriter writer, RecordMetadata metadata, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex) {
        long rowCount = ColumnType.isSymbolOrString(metadata.getColumnType(cursorTimestampIndex)) ? this.copyOrderedStrTimestamp(writer, cursor, copier, cursorTimestampIndex) : this.copyOrdered0(writer, cursor, copier, cursorTimestampIndex);
        writer.commit();
        return rowCount;
    }

    private long copyOrdered0(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex) {
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
            ++rowCount;
        }
        return rowCount;
    }

    private long copyOrderedBatched(TableWriter writer, RecordMetadata metadata, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long commitLag) {
        long rowCount = ColumnType.isSymbolOrString(metadata.getColumnType(cursorTimestampIndex)) ? this.copyOrderedBatchedStrTimestamp(writer, cursor, copier, cursorTimestampIndex, batchSize, commitLag) : this.copyOrderedBatched0(writer, cursor, copier, cursorTimestampIndex, batchSize, commitLag);
        writer.commit();
        return rowCount;
    }

    private long copyOrderedBatched0(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long commitLag) {
        long deadline = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
            if (++rowCount <= deadline) continue;
            writer.commitWithLag(commitLag);
            deadline = rowCount + batchSize;
        }
        return rowCount;
    }

    private long copyOrderedBatchedStrTimestamp(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long commitLag) {
        long deadline = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            CharSequence str = record.getStr(cursorTimestampIndex);
            TableWriter.Row row = writer.newRow(SqlUtil.parseFloorPartialTimestamp(str, 0, 8));
            copier.copy(record, row);
            row.append();
            if (++rowCount <= deadline) continue;
            writer.commitWithLag(commitLag);
            deadline = rowCount + batchSize;
        }
        return rowCount;
    }

    private long copyOrderedStrTimestamp(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex) {
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            CharSequence str = record.getStr(cursorTimestampIndex);
            TableWriter.Row row = writer.newRow(SqlUtil.implicitCastStrAsTimestamp(str));
            copier.copy(record, row);
            row.append();
            ++rowCount;
        }
        return rowCount;
    }

    private TableWriter copyTableData(CharSequence tableName, RecordCursor cursor, RecordMetadata cursorMetadata) throws SqlException {
        TableWriter writer = new TableWriter(this.configuration, tableName, this.messageBus, null, false, DefaultLifecycleManager.INSTANCE, this.configuration.getRoot(), this.engine.getMetrics());
        try {
            TableWriterMetadata writerMetadata = writer.getMetadata();
            this.entityColumnFilter.of(writerMetadata.getColumnCount());
            this.insertCount = this.copyTableData(cursor, cursorMetadata, writer, writerMetadata, RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter));
            return writer;
        }
        catch (Throwable e) {
            writer.close();
            throw e;
        }
    }

    private long copyTableData(RecordCursor cursor, RecordMetadata metadata, TableWriter writer, RecordMetadata writerMetadata, RecordToRowCopier recordToRowCopier) throws SqlException {
        int timestampIndex = writerMetadata.getTimestampIndex();
        if (timestampIndex == -1) {
            return this.copyUnordered(cursor, writer, recordToRowCopier);
        }
        return this.copyOrdered(writer, metadata, cursor, recordToRowCopier, timestampIndex);
    }

    private long copyUnordered(RecordCursor cursor, TableWriter writer, RecordToRowCopier copier) {
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow();
            copier.copy(record, row);
            row.append();
            ++rowCount;
        }
        writer.commit();
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompiledQuery createTable(ExecutionModel model, SqlExecutionContext executionContext) throws SqlException {
        CreateTableModel createTableModel = (CreateTableModel)model;
        ExpressionNode name = createTableModel.getName();
        if (createTableModel.isIgnoreIfExists() && this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, name.token, 0, name.token.length()) != 1) {
            return this.compiledQuery.ofCreateTable();
        }
        this.insertCount = -1L;
        CharSequence lockedReason = this.engine.lock(executionContext.getCairoSecurityContext(), name.token, "createTable");
        if (null != lockedReason) {
            throw SqlException.$(name.position, "cannot acquire table lock [lockedReason=").put(lockedReason).put(']');
        }
        TableWriter writer = null;
        boolean newTable = false;
        try {
            if (this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, name.token, 0, name.token.length()) != 1) {
                if (!createTableModel.isIgnoreIfExists()) throw SqlException.$(name.position, "table already exists");
                CompiledQuery compiledQuery = this.compiledQuery.ofCreateTable();
                this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer, newTable);
                return compiledQuery;
            }
        }
        catch (Throwable throwable) {
            this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer, newTable);
            throw throwable;
        }
        {
            try {
                if (createTableModel.getQueryModel() == null) {
                    this.engine.createTableUnsafe(executionContext.getCairoSecurityContext(), this.mem, this.path, createTableModel);
                    newTable = true;
                } else {
                    writer = this.createTableFromCursor(createTableModel, executionContext);
                }
            }
            catch (CairoException e) {
                LOG.error().$("could not create table [error=").$(e).$(']').$();
                throw SqlException.$(name.position, "Could not create table. See log for details.");
            }
            this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer, newTable);
        }
        if (createTableModel.getQueryModel() != null) return this.compiledQuery.ofCreateTableAsSelect(this.insertCount);
        return this.compiledQuery.ofCreateTable();
    }

    /*
     * Exception decompiling
     */
    private TableWriter createTableFromCursor(CreateTableModel model, SqlExecutionContext executionContext) throws SqlException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CompiledQuery createTableWithRetries(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        return this.executeWithRetries(this.createTableMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
    }

    private CompiledQuery dropTable(SqlExecutionContext executionContext) throws SqlException {
        SqlCompiler.expectKeyword(this.lexer, "table");
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "expected [if exists] table-name");
        }
        boolean hasIfExists = false;
        if (SqlKeywords.isIfKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok == null || !SqlKeywords.isExistsKeyword(tok)) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "expected exists");
            }
            hasIfExists = true;
        } else {
            this.lexer.unparseLast();
        }
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tableName = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("]");
        }
        if (1 == this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName)) {
            if (hasIfExists) {
                return this.compiledQuery.ofDrop();
            }
            throw SqlException.$(tableNamePosition, "table does not exist [table=").put(tableName).put(']');
        }
        this.engine.remove(executionContext.getCairoSecurityContext(), this.path, tableName);
        return this.compiledQuery.ofDrop();
    }

    @NotNull
    private CompiledQuery executeCopy(SqlExecutionContext executionContext, CopyModel executionModel) throws SqlException {
        executionContext.getCairoSecurityContext().checkWritePermission();
        if (!executionModel.isCancel() && Chars.equalsLowerCaseAscii(executionModel.getFileName().token, "stdin")) {
            this.setupTextLoaderFromModel(executionModel);
            return this.compiledQuery.ofCopyRemote(this.textLoader);
        }
        RecordCursorFactory copyFactory = this.executeCopy0(executionModel);
        return this.compiledQuery.ofCopyLocal(copyFactory);
    }

    @Nullable
    private RecordCursorFactory executeCopy0(CopyModel model) throws SqlException {
        try {
            if (model.isCancel()) {
                this.cancelTextImport(model);
                return null;
            }
            if (model.getTimestampColumnName() == null && model.getPartitionBy() != -1 && model.getPartitionBy() != 3) {
                throw SqlException.$(-1, "invalid option used for import without a designated timestamp (format or partition by)");
            }
            if (model.getTimestampFormat() == null) {
                model.setTimestampFormat("yyyy-MM-ddTHH:mm:ss.SSSUUUZ");
            }
            if (model.getDelimiter() < 0) {
                model.setDelimiter((byte)44);
            }
            return this.compileTextImport(model);
        }
        catch (TextException | TextImportException e) {
            LOG.error().$(e).$();
            throw SqlException.$(0, e.getMessage());
        }
    }

    private CompiledQuery executeWithRetries(ExecutableMethod method, ExecutionModel executionModel, int retries, SqlExecutionContext executionContext) throws SqlException {
        int attemptsLeft = retries;
        while (true) {
            try {
                return method.execute(executionModel, executionContext);
            }
            catch (ReaderOutOfDateException e) {
                this.clear();
                this.lexer.restart();
                executionModel = this.compileExecutionModel(executionContext);
                if (--attemptsLeft > 0) continue;
                throw SqlException.position(0).put("underlying cursor is extremely volatile");
            }
            break;
        }
    }

    RecordCursorFactory generate(QueryModel queryModel, SqlExecutionContext executionContext) throws SqlException {
        return this.codeGenerator.generate(queryModel, executionContext);
    }

    UpdateOperation generateUpdate(QueryModel updateQueryModel, SqlExecutionContext executionContext) throws SqlException {
        QueryModel selectQueryModel = updateQueryModel.getNestedModel();
        RecordCursorFactory recordCursorFactory = this.prepareForUpdate(updateQueryModel.getUpdateTableName(), selectQueryModel, updateQueryModel, executionContext);
        return new UpdateOperation(updateQueryModel.getUpdateTableName(), selectQueryModel.getTableId(), selectQueryModel.getTableVersion(), this.lexer.getPosition(), recordCursorFactory);
    }

    private int getNextValidTokenPosition() {
        while (this.lexer.hasNext()) {
            CharSequence token = SqlUtil.fetchNext(this.lexer);
            if (token == null) {
                return -1;
            }
            if (SqlKeywords.isSemicolon(token)) continue;
            this.lexer.unparseLast();
            return this.lexer.lastTokenPosition();
        }
        return -1;
    }

    private int goToQueryEnd() {
        CharSequence token;
        this.lexer.unparseLast();
        while (this.lexer.hasNext() && (token = SqlUtil.fetchNext(this.lexer)) != null && !SqlKeywords.isSemicolon(token)) {
        }
        return this.lexer.getPosition();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompiledQuery insert(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        InsertModel model = (InsertModel)executionModel;
        ExpressionNode name = model.getTableName();
        this.tableExistsOrFail(name.position, name.token, executionContext);
        ObjList<Function> valueFunctions = null;
        try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), name.token, -1, -1L);){
            long structureVersion = reader.getVersion();
            TableReaderMetadata metadata = reader.getMetadata();
            InsertOperationImpl insertOperation = new InsertOperationImpl(this.engine, reader.getTableName(), structureVersion);
            int metadataTimestampIndex = metadata.getTimestampIndex();
            ObjList<CharSequence> columnNameList = model.getColumnNameList();
            int columnSetSize = columnNameList.size();
            int n = model.getRowTupleCount();
            for (int tupleIndex = 0; tupleIndex < n; ++tupleIndex) {
                Function timestampFunction = null;
                this.listColumnFilter.clear();
                if (columnSetSize > 0) {
                    valueFunctions = new ObjList<Function>(columnSetSize);
                    for (int i = 0; i < columnSetSize; ++i) {
                        int metadataColumnIndex = metadata.getColumnIndexQuiet(columnNameList.getQuick(i));
                        if (metadataColumnIndex <= -1) throw SqlException.invalidColumn(model.getColumnPosition(i), columnNameList.getQuick(i));
                        ExpressionNode node = model.getRowTupleValues(tupleIndex).getQuick(i);
                        Function function = this.functionParser.parseFunction(node, GenericRecordMetadata.EMPTY, executionContext);
                        this.insertValidateFunctionAndAddToList(model, tupleIndex, valueFunctions, metadata, metadataTimestampIndex, i, metadataColumnIndex, function, node.position, executionContext.getBindVariableService());
                        if (metadataTimestampIndex != metadataColumnIndex) continue;
                        timestampFunction = function;
                    }
                } else {
                    ObjList<ExpressionNode> values;
                    int valueCount;
                    int columnCount = metadata.getColumnCount();
                    if (columnCount != (valueCount = (values = model.getRowTupleValues(tupleIndex)).size())) {
                        throw SqlException.$(model.getEndOfRowTupleValuesPosition(tupleIndex), "row value count does not match column count [expected=").put(columnCount).put(", actual=").put(values.size()).put(", tuple=").put(tupleIndex + 1).put(']');
                    }
                    valueFunctions = new ObjList(columnCount);
                    for (int i = 0; i < columnCount; ++i) {
                        ExpressionNode node = values.getQuick(i);
                        Function function = this.functionParser.parseFunction(node, EmptyRecordMetadata.INSTANCE, executionContext);
                        this.insertValidateFunctionAndAddToList(model, tupleIndex, valueFunctions, metadata, metadataTimestampIndex, i, i, function, node.position, executionContext.getBindVariableService());
                        if (metadataTimestampIndex != i) continue;
                        timestampFunction = function;
                    }
                }
                if (metadataTimestampIndex > -1) {
                    if (timestampFunction == null) throw SqlException.$(0, "insert statement must populate timestamp");
                    if (ColumnType.isNull(timestampFunction.getType())) {
                        throw SqlException.$(0, "insert statement must populate timestamp");
                    }
                }
                VirtualRecord record = new VirtualRecord(valueFunctions);
                RecordToRowCopier copier = RecordToRowCopierUtils.generateCopier(this.asm, record, metadata, this.listColumnFilter);
                insertOperation.addInsertRow(new InsertRowImpl(record, copier, timestampFunction, tupleIndex));
            }
            CompiledQuery compiledQuery = this.compiledQuery.ofInsert(insertOperation);
            return compiledQuery;
        }
        catch (SqlException e) {
            Misc.freeObjList(valueFunctions);
            throw e;
        }
    }

    private CompiledQuery insertAsSelect(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        long insertCount;
        InsertModel model = (InsertModel)executionModel;
        ExpressionNode name = model.getTableName();
        this.tableExistsOrFail(name.position, name.token, executionContext);
        try (TableWriter writer = this.engine.getWriter(executionContext.getCairoSecurityContext(), name.token, "insertAsSelect");
             RecordCursorFactory factory = this.generate(model.getQueryModel(), executionContext);){
            RecordToRowCopier copier;
            RecordMetadata cursorMetadata = factory.getMetadata();
            GenericRecordMetadata writerMetadata = writer.getMetadata().copyDense();
            int writerTimestampIndex = writerMetadata.getTimestampIndex();
            int cursorTimestampIndex = cursorMetadata.getTimestampIndex();
            int cursorColumnCount = cursorMetadata.getColumnCount();
            ObjList<CharSequence> columnNameList = model.getColumnNameList();
            int columnSetSize = columnNameList.size();
            int timestampIndexFound = -1;
            if (columnSetSize > 0) {
                this.listColumnFilter.clear();
                for (int i = 0; i < columnSetSize; ++i) {
                    int toType;
                    CharSequence columnName = columnNameList.get(i);
                    int index = writerMetadata.getColumnIndexQuiet(columnName);
                    if (index == -1) {
                        throw SqlException.invalidColumn(model.getColumnPosition(i), columnName);
                    }
                    int fromType = cursorMetadata.getColumnType(i);
                    if (!ColumnType.isAssignableFrom(fromType, toType = writerMetadata.getColumnType(index))) {
                        throw SqlException.inconvertibleTypes(model.getColumnPosition(i), fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                    }
                    this.listColumnFilter.add(index + 1);
                    if (index != writerTimestampIndex) continue;
                    timestampIndexFound = i;
                    if (fromType == 8 || fromType == 11) continue;
                    throw SqlException.$(name.position, "expected timestamp column but type is ").put(ColumnType.nameOf(fromType));
                }
                if (timestampIndexFound < 0 && writerTimestampIndex >= 0) {
                    throw SqlException.$(name.position, "select clause must provide timestamp column");
                }
                copier = RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.listColumnFilter);
            } else {
                if (writerTimestampIndex > -1 && cursorTimestampIndex == -1) {
                    if (cursorColumnCount <= writerTimestampIndex) {
                        throw SqlException.$(name.position, "select clause must provide timestamp column");
                    }
                    short columnType = ColumnType.tagOf(cursorMetadata.getColumnType(writerTimestampIndex));
                    if (columnType != 8 && columnType != 11 && columnType != 28) {
                        throw SqlException.$(name.position, "expected timestamp column but type is ").put(ColumnType.nameOf(columnType));
                    }
                }
                if (writerTimestampIndex > -1 && cursorTimestampIndex > -1 && writerTimestampIndex != cursorTimestampIndex) {
                    throw SqlException.$(name.position, "designated timestamp of existing table (").put(writerTimestampIndex).put(") does not match designated timestamp in select query (").put(cursorTimestampIndex).put(')');
                }
                timestampIndexFound = writerTimestampIndex;
                int n = writerMetadata.getColumnCount();
                if (n > cursorMetadata.getColumnCount()) {
                    throw SqlException.$(model.getSelectKeywordPosition(), "not enough columns selected");
                }
                for (int i = 0; i < n; ++i) {
                    int toType;
                    int fromType = cursorMetadata.getColumnType(i);
                    if (ColumnType.isAssignableFrom(fromType, toType = writerMetadata.getColumnType(i))) continue;
                    assert (i < model.getQueryModel().getBottomUpColumns().size());
                    throw SqlException.inconvertibleTypes(model.getQueryModel().getBottomUpColumns().getQuick((int)i).getAst().position, fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                }
                this.entityColumnFilter.of(writerMetadata.getColumnCount());
                copier = RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter);
            }
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                try {
                    insertCount = writerTimestampIndex == -1 ? this.copyUnordered(cursor, writer, copier) : (model.getBatchSize() != -1L ? this.copyOrderedBatched(writer, factory.getMetadata(), cursor, copier, writerTimestampIndex, model.getBatchSize(), model.getCommitLag()) : this.copyOrdered(writer, factory.getMetadata(), cursor, copier, timestampIndexFound));
                }
                catch (Throwable e) {
                    writer.rollback();
                    throw e;
                }
            }
        }
        return this.compiledQuery.ofInsertAsSelect(insertCount);
    }

    private void insertValidateFunctionAndAddToList(InsertModel model, int tupleIndex, ObjList<Function> valueFunctions, RecordMetadata metadata, int metadataTimestampIndex, int insertColumnIndex, int metadataColumnIndex, Function function, int functionPosition, BindVariableService bindVariableService) throws SqlException {
        int columnType = metadata.getColumnType(metadataColumnIndex);
        if (function.isUndefined()) {
            function.assignType(columnType, bindVariableService);
        }
        if (ColumnType.isAssignableFrom(function.getType(), columnType)) {
            if (metadataColumnIndex == metadataTimestampIndex) {
                return;
            }
            valueFunctions.add(function);
            this.listColumnFilter.add(metadataColumnIndex + 1);
            return;
        }
        throw SqlException.inconvertibleTypes(functionPosition, function.getType(), model.getRowTupleValues((int)tupleIndex).getQuick((int)insertColumnIndex).token, metadata.getColumnType(metadataColumnIndex), metadata.getColumnName(metadataColumnIndex));
    }

    private ExecutionModel lightlyValidateInsertModel(InsertModel model) throws SqlException {
        ExpressionNode tableName = model.getTableName();
        if (tableName.type != 4) {
            throw SqlException.$(tableName.position, "literal expected");
        }
        int columnNameListSize = model.getColumnNameList().size();
        int n = model.getRowTupleCount();
        for (int i = 0; i < n; ++i) {
            if (columnNameListSize <= 0 || columnNameListSize == model.getRowTupleValues(i).size()) continue;
            throw SqlException.$(model.getEndOfRowTupleValuesPosition(i), "row value count does not match column count [expected=").put(columnNameListSize).put(", actual=").put(model.getRowTupleValues(i).size()).put(", tuple=").put(i + 1).put(']');
        }
        return model;
    }

    private RecordCursorFactory prepareForUpdate(String tableName, QueryModel selectQueryModel, QueryModel updateQueryModel, SqlExecutionContext executionContext) throws SqlException {
        IntList tableColumnTypes = selectQueryModel.getUpdateTableColumnTypes();
        ObjList<CharSequence> tableColumnNames = selectQueryModel.getUpdateTableColumnNames();
        RecordCursorFactory updateToDataCursorFactory = this.codeGenerator.generate(selectQueryModel, executionContext);
        try {
            if (!updateToDataCursorFactory.supportsUpdateRowId(tableName)) {
                throw SqlException.$(updateQueryModel.getModelPosition(), "Unsupported SQL complexity for the UPDATE statement");
            }
            RecordMetadata updateDataFactoryMetadata = updateToDataCursorFactory.getMetadata();
            int n = updateDataFactoryMetadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String updateColumnName;
                int tableColumnIndex;
                int tableColumnType;
                int virtualColumnType = updateDataFactoryMetadata.getColumnType(i);
                if (virtualColumnType == (tableColumnType = tableColumnTypes.get(tableColumnIndex = tableColumnNames.indexOf(updateColumnName = updateDataFactoryMetadata.getColumnName(i)))) || ColumnType.isSymbol(tableColumnType) && virtualColumnType == 11) continue;
                ExpressionNode setRhs = updateQueryModel.getNestedModel().getColumns().getQuick(i).getAst();
                throw SqlException.inconvertibleTypes(setRhs.position, virtualColumnType, "", tableColumnType, updateColumnName);
            }
            return updateToDataCursorFactory;
        }
        catch (Throwable th) {
            updateToDataCursorFactory.close();
            throw th;
        }
    }

    private CompiledQuery reindexTable(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "TABLE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || Chars.equals(tok, ',')) {
            throw SqlException.$(this.lexer.getPosition(), "table name expected");
        }
        if (Chars.isQuoted(tok)) {
            tok = GenericLexer.unquote(tok);
        }
        this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
        CharSequence tableName = tok;
        this.rebuildIndex.of(this.path.of(this.configuration.getRoot()).concat(tableName), this.configuration);
        tok = SqlUtil.fetchNext(this.lexer);
        CharSequence columnName = null;
        if (tok != null && SqlKeywords.isColumnKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (Chars.isQuoted(tok)) {
                tok = GenericLexer.unquote(tok);
            }
            if (tok == null || TableUtils.isValidColumnName(tok, this.configuration.getMaxFileNameLength())) {
                columnName = GenericLexer.immutableOf(tok);
                tok = SqlUtil.fetchNext(this.lexer);
            }
        }
        CharSequence partition = null;
        if (tok != null && SqlKeywords.isPartitionKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (Chars.isQuoted(tok)) {
                tok = GenericLexer.unquote(tok);
            }
            partition = tok;
            tok = SqlUtil.fetchNext(this.lexer);
        }
        if (tok == null || !SqlKeywords.isLockKeyword(tok)) {
            throw SqlException.$(this.lexer.getPosition(), "LOCK EXCLUSIVE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isExclusiveKeyword(tok)) {
            throw SqlException.$(this.lexer.getPosition(), "LOCK EXCLUSIVE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !SqlKeywords.isSemicolon(tok)) {
            throw SqlException.$(this.lexer.getPosition(), "EOF expected");
        }
        this.rebuildIndex.reindex(partition, columnName);
        return this.compiledQuery.ofRepair();
    }

    private boolean removeTableDirectory(CreateTableModel model) {
        int errno = this.engine.removeDirectory(this.path, model.getName().token);
        if (errno == 0) {
            return true;
        }
        LOG.error().$("could not clean up after create table failure [path=").$(this.path).$(", errno=").$(errno).$(']').$();
        return false;
    }

    private CompiledQuery repairTables(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'table' expected");
        }
        do {
            if ((tok = SqlUtil.fetchNext(this.lexer)) == null || Chars.equals(tok, ',')) {
                throw SqlException.$(this.lexer.getPosition(), "table name expected");
            }
            if (Chars.isQuoted(tok)) {
                tok = GenericLexer.unquote(tok);
            }
            this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
        } while ((tok = SqlUtil.fetchNext(this.lexer)) != null && Chars.equals(tok, ','));
        return this.compiledQuery.ofRepair();
    }

    void setEnableJitNullChecks(boolean value) {
        this.codeGenerator.setEnableJitNullChecks(value);
    }

    void setFullFatJoins(boolean value) {
        this.codeGenerator.setFullFatJoins(value);
    }

    private void setupTextLoaderFromModel(CopyModel model) {
        this.textLoader.clear();
        this.textLoader.setState(1);
        this.textLoader.configureDestination(model.getTarget().token, false, false, model.getAtomicity() != -1 ? model.getAtomicity() : 1, model.getPartitionBy() < 0 ? 3 : model.getPartitionBy(), model.getTimestampColumnName(), model.getTimestampFormat());
    }

    private CompiledQuery snapshotDatabase(SqlExecutionContext executionContext) throws SqlException {
        executionContext.getCairoSecurityContext().checkWritePermission();
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'prepare' or 'complete'");
        if (Chars.equalsLowerCaseAscii(tok, "prepare")) {
            if (this.snapshotAgent == null) {
                throw SqlException.position(this.lexer.lastTokenPosition()).put("Snapshot agent is not configured. Try using different embedded API");
            }
            this.snapshotAgent.prepareSnapshot(executionContext);
            return this.compiledQuery.ofSnapshotPrepare();
        }
        if (Chars.equalsLowerCaseAscii(tok, "complete")) {
            if (this.snapshotAgent == null) {
                throw SqlException.position(this.lexer.lastTokenPosition()).put("Snapshot agent is not configured. Try using different embedded API");
            }
            this.snapshotAgent.completeSnapshot();
            return this.compiledQuery.ofSnapshotComplete();
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("'prepare' or 'complete' expected");
    }

    private CompiledQuery sqlShow(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (null != tok) {
            if (SqlKeywords.isTablesKeyword(tok)) {
                return this.compiledQuery.of(new TableListRecordCursorFactory(this.configuration.getFilesFacade(), this.configuration.getRoot()));
            }
            if (SqlKeywords.isColumnsKeyword(tok)) {
                return this.sqlShowColumns(executionContext);
            }
            if (SqlKeywords.isTransactionKeyword(tok)) {
                return this.sqlShowTransaction();
            }
            if (SqlKeywords.isTransactionIsolation(tok)) {
                return this.compiledQuery.of(new ShowTransactionIsolationLevelCursorFactory());
            }
            if (SqlKeywords.isMaxIdentifierLength(tok)) {
                return this.compiledQuery.of(new ShowMaxIdentifierLengthCursorFactory());
            }
            if (SqlKeywords.isStandardConformingStrings(tok)) {
                return this.compiledQuery.of(new ShowStandardConformingStringsCursorFactory());
            }
            if (SqlKeywords.isSearchPath(tok)) {
                return this.compiledQuery.of(new ShowSearchPathCursorFactory());
            }
            if (SqlKeywords.isDateStyleKeyword(tok)) {
                return this.compiledQuery.of(new ShowDateStyleCursorFactory());
            }
            if (SqlKeywords.isTimeKeyword(tok) && (tok = SqlUtil.fetchNext(this.lexer)) != null && SqlKeywords.isZoneKeyword(tok)) {
                return this.compiledQuery.of(new ShowTimeZoneFactory());
            }
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("expected 'tables', 'columns' or 'time zone'");
    }

    private CompiledQuery sqlShowColumns(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (null == tok || !SqlKeywords.isFromKeyword(tok)) {
            throw SqlException.position(this.lexer.getPosition()).put("expected 'from'");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (null == tok) {
            throw SqlException.position(this.lexer.getPosition()).put("expected a table name");
        }
        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), this.lexer.lastTokenPosition());
        int status = this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName, 0, tableName.length());
        if (status != 0) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "table does not exist [table=").put(tableName).put(']');
        }
        return this.compiledQuery.of(new ShowColumnsRecordCursorFactory(tableName));
    }

    private CompiledQuery sqlShowTransaction() throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && SqlKeywords.isIsolationKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && SqlKeywords.isLevelKeyword(tok)) {
                return this.compiledQuery.of(new ShowTransactionIsolationLevelCursorFactory());
            }
            throw SqlException.position(tok != null ? this.lexer.lastTokenPosition() : this.lexer.getPosition()).put("expected 'level'");
        }
        throw SqlException.position(tok != null ? this.lexer.lastTokenPosition() : this.lexer.getPosition()).put("expected 'isolation'");
    }

    private void tableExistsOrFail(int position, CharSequence tableName, SqlExecutionContext executionContext) throws SqlException {
        if (this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName) == 1) {
            throw SqlException.$(position, "table does not exist [table=").put(tableName).put(']');
        }
    }

    ExecutionModel testCompileModel(CharSequence query, SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        return this.compileExecutionModel(executionContext);
    }

    ExpressionNode testParseExpression(CharSequence expression, QueryModel model) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        return this.parser.expr(this.lexer, model);
    }

    void testParseExpression(CharSequence expression, ExpressionParserListener listener) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        this.parser.expr(this.lexer, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledQuery truncateTables(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(this.lexer.getPosition(), "'table' expected");
        }
        if (!SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'table' expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && SqlKeywords.isOnlyKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
        }
        this.tableWriters.clear();
        try {
            try {
                while (true) {
                    if (tok == null || Chars.equals(tok, ',')) {
                        throw SqlException.$(this.lexer.getPosition(), "table name expected");
                    }
                    if (Chars.isQuoted(tok)) {
                        tok = GenericLexer.unquote(tok);
                    }
                    this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
                    try {
                        this.tableWriters.add(this.engine.getWriter(executionContext.getCairoSecurityContext(), tok, "truncateTables"));
                    }
                    catch (CairoException e) {
                        LOG.info().$("table busy [table=").$(tok).$(", e=").$(e).$(']').$();
                        throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tok).put("' could not be truncated: ").put(e);
                    }
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok != null && !Chars.equals(tok, ';')) {
                        if (!Chars.equalsNc(tok, ',')) continue;
                        tok = SqlUtil.fetchNext(this.lexer);
                        continue;
                    }
                    break;
                }
            }
            catch (SqlException e) {
                int n = this.tableWriters.size();
                for (int i = 0; i < n; ++i) {
                    this.tableWriters.getQuick(i).close();
                }
                throw e;
            }
            int n = this.tableWriters.size();
            for (int i = 0; i < n; ++i) {
                try (TableWriter writer = this.tableWriters.getQuick(i);){
                    try {
                        if (this.engine.lockReaders(writer.getTableName())) {
                            try {
                                writer.truncate();
                                continue;
                            }
                            finally {
                                this.engine.unlockReaders(writer.getTableName());
                            }
                        }
                        throw SqlException.$(0, "there is an active query against '").put(writer.getTableName()).put("'. Try again.");
                    }
                    catch (CairoError | CairoException e) {
                        LOG.error().$("could not truncate [table=").$(writer.getTableName()).$(", e=").$((Sinkable)((Object)e)).$(']').$();
                        throw e;
                    }
                }
            }
        }
        finally {
            this.tableWriters.clear();
        }
        return this.compiledQuery.ofTruncate();
    }

    private CompiledQuery vacuum(SqlExecutionContext executionContext) throws SqlException {
        executionContext.getCairoSecurityContext().checkWritePermission();
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'table'");
        boolean partitionsKeyword = SqlKeywords.isPartitionsKeyword(tok);
        if (partitionsKeyword || SqlKeywords.isTableKeyword(tok)) {
            CharSequence tableName = SqlCompiler.expectToken(this.lexer, "table name");
            tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tableName), this.lexer.lastTokenPosition());
            int tableNamePos = this.lexer.lastTokenPosition();
            CharSequence eol = SqlUtil.fetchNext(this.lexer);
            if (eol == null || Chars.equals(eol, ';')) {
                executionContext.getCairoSecurityContext().checkWritePermission();
                this.tableExistsOrFail(this.lexer.lastTokenPosition(), tableName, executionContext);
                try (TableReader rdr = this.engine.getReader(executionContext.getCairoSecurityContext(), tableName);){
                    int partitionBy = rdr.getMetadata().getPartitionBy();
                    if (PartitionBy.isPartitioned(partitionBy)) {
                        if (!TableUtils.schedulePurgeO3Partitions(this.messageBus, rdr.getTableName(), partitionBy)) {
                            throw SqlException.$(tableNamePos, "cannot schedule vacuum action, queue is full, please retry or increase Purge Discovery Queue Capacity");
                        }
                    } else if (partitionsKeyword) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tableName).put("' is not partitioned");
                    }
                    this.vacuumColumnVersions.run(executionContext, rdr);
                    CompiledQuery compiledQuery = this.compiledQuery.ofVacuum();
                    return compiledQuery;
                }
            }
            throw SqlException.$(this.lexer.lastTokenPosition(), "end of line or ';' expected");
        }
        throw SqlException.$(this.lexer.lastTokenPosition(), "'partitions' expected");
    }

    private InsertModel validateAndOptimiseInsertAsSelect(InsertModel model, SqlExecutionContext executionContext) throws SqlException {
        QueryModel queryModel = this.optimiser.optimise(model.getQueryModel(), executionContext);
        int columnNameListSize = model.getColumnNameList().size();
        if (columnNameListSize > 0 && queryModel.getBottomUpColumns().size() != columnNameListSize) {
            throw SqlException.$(model.getTableName().position, "column count mismatch");
        }
        model.setQueryModel(queryModel);
        return model;
    }

    private void validateTableModelAndCreateTypeCast(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) throws SqlException {
        CharSequenceObjHashMap<ColumnCastModel> castModels = model.getColumnCastModels();
        ObjList<CharSequence> castColumnNames = castModels.keys();
        int n = castColumnNames.size();
        for (int i = 0; i < n; ++i) {
            int to;
            CharSequence columnName = castColumnNames.getQuick(i);
            int index = metadata.getColumnIndexQuiet(columnName);
            if (index == -1) {
                throw SqlException.invalidColumn(castModels.get(columnName).getColumnNamePos(), columnName);
            }
            ColumnCastModel ccm = castModels.get(columnName);
            int from = metadata.getColumnType(index);
            if (!SqlCompiler.isCompatibleCase(from, to = ccm.getColumnType())) {
                throw SqlException.unsupportedCast(ccm.getColumnTypePos(), columnName, from, to);
            }
            typeCast.put(index, to);
        }
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp != null && metadata.getColumnType(timestamp.token) != 8) {
            throw SqlException.position(timestamp.position).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(metadata.getColumnType(timestamp.token))).put(']');
        }
        if (PartitionBy.isPartitioned(model.getPartitionBy()) && model.getTimestampIndex() == -1 && metadata.getTimestampIndex() == -1) {
            throw SqlException.position(0).put("timestamp is not defined");
        }
    }

    static {
        castGroups.extendAndSet(1, 2);
        castGroups.extendAndSet(2, 1);
        castGroups.extendAndSet(3, 1);
        castGroups.extendAndSet(4, 1);
        castGroups.extendAndSet(5, 1);
        castGroups.extendAndSet(6, 1);
        castGroups.extendAndSet(9, 1);
        castGroups.extendAndSet(10, 1);
        castGroups.extendAndSet(7, 1);
        castGroups.extendAndSet(8, 1);
        castGroups.extendAndSet(11, 3);
        castGroups.extendAndSet(12, 3);
        castGroups.extendAndSet(18, 4);
        sqlControlSymbols.add("(");
        sqlControlSymbols.add(";");
        sqlControlSymbols.add(")");
        sqlControlSymbols.add(",");
        sqlControlSymbols.add("/*");
        sqlControlSymbols.add("*/");
        sqlControlSymbols.add("--");
        sqlControlSymbols.add("[");
        sqlControlSymbols.add("]");
    }

    private class DatabaseBackupAgent
    implements Closeable {
        protected final Path srcPath = new Path();
        private final CharSequenceObjHashMap<RecordToRowCopier> tableBackupRowCopiedCache = new CharSequenceObjHashMap();
        private final ObjHashSet<CharSequence> tableNames = new ObjHashSet();
        private final Path dstPath = new Path();
        private final StringSink fileNameSink = new StringSink();
        private transient String cachedTmpBackupRoot;
        private transient int changeDirPrefixLen;
        private transient int currDirPrefixLen;
        private final FindVisitor confFilesBackupOnFind = (file, type) -> {
            if (type == 8) {
                this.srcPath.of(SqlCompiler.this.configuration.getConfRoot()).concat(file).$();
                this.dstPath.trimTo(this.currDirPrefixLen).concat(file).$();
                LOG.info().$("backup copying config file [from=").$(this.srcPath).$(",to=").$(this.dstPath).I$();
                if (SqlCompiler.this.ff.copy(this.srcPath, this.dstPath) < 0) {
                    throw CairoException.critical(SqlCompiler.this.ff.errno()).put("cannot backup conf file [to=").put(this.dstPath).put(']');
                }
            }
        };
        private transient SqlExecutionContext currentExecutionContext;
        private final FindVisitor sqlDatabaseBackupOnFind = (pUtf8NameZ, type) -> {
            if (Files.isDir(pUtf8NameZ, type, this.fileNameSink)) {
                try {
                    this.backupTable(this.fileNameSink, this.currentExecutionContext);
                }
                catch (CairoException e) {
                    LOG.error().$("could not backup [path=").$(this.fileNameSink).$(", e=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).$(']').$();
                }
                catch (SqlException e) {
                    LOG.error().$("could not backup [path=").$(this.fileNameSink).$(", e=").$(e.getFlyweightMessage()).$(']').$();
                }
            }
        };

        private DatabaseBackupAgent() {
        }

        public void clear() {
            this.srcPath.trimTo(0);
            this.dstPath.trimTo(0);
            this.cachedTmpBackupRoot = null;
            this.changeDirPrefixLen = 0;
            this.currDirPrefixLen = 0;
            this.tableBackupRowCopiedCache.clear();
            this.tableNames.clear();
        }

        @Override
        public void close() {
            assert (null == this.currentExecutionContext);
            assert (this.tableNames.isEmpty());
            this.tableBackupRowCopiedCache.clear();
            Misc.free(this.srcPath);
            Misc.free(this.dstPath);
        }

        private void backupTabIndexFile() {
            this.srcPath.of(SqlCompiler.this.configuration.getRoot()).concat("_tab_index.d").$();
            this.dstPath.trimTo(this.currDirPrefixLen).concat("_tab_index.d").$();
            LOG.info().$("backup copying file [from=").$(this.srcPath).$(",to=").$(this.dstPath).I$();
            if (SqlCompiler.this.ff.copy(this.srcPath, this.dstPath) < 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put("cannot backup tab index file [to=").put(this.dstPath).put(']');
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void backupTable(@NotNull CharSequence tableName, @NotNull SqlExecutionContext executionContext) throws SqlException {
            LOG.info().$("Starting backup of ").$(tableName).$();
            if (null == this.cachedTmpBackupRoot) {
                if (null == SqlCompiler.this.configuration.getBackupRoot()) {
                    throw CairoException.nonCritical().put("Backup is disabled, no backup root directory is configured in the server configuration ['cairo.sql.backup.root' property]");
                }
                this.srcPath.of(SqlCompiler.this.configuration.getBackupRoot()).concat(SqlCompiler.this.configuration.getBackupTempDirName()).slash$();
                this.cachedTmpBackupRoot = Chars.toString(this.srcPath);
            }
            int renameRootLen = this.dstPath.length();
            try {
                CairoSecurityContext securityContext = executionContext.getCairoSecurityContext();
                try (TableReader reader = SqlCompiler.this.engine.getReader(securityContext, tableName);){
                    this.cloneMetaData(tableName, this.cachedTmpBackupRoot, SqlCompiler.this.configuration.getBackupMkDirMode(), reader);
                    try (TableWriter backupWriter = SqlCompiler.this.engine.getBackupWriter(securityContext, tableName, this.cachedTmpBackupRoot);){
                        TableWriterMetadata writerMetadata = backupWriter.getMetadata();
                        this.srcPath.of(tableName).slash().put(reader.getVersion()).$();
                        RecordToRowCopier recordToRowCopier = this.tableBackupRowCopiedCache.get(this.srcPath);
                        if (null == recordToRowCopier) {
                            SqlCompiler.this.entityColumnFilter.of(writerMetadata.getColumnCount());
                            recordToRowCopier = RecordToRowCopierUtils.generateCopier(SqlCompiler.this.asm, reader.getMetadata(), writerMetadata, SqlCompiler.this.entityColumnFilter);
                            this.tableBackupRowCopiedCache.put(this.srcPath.toString(), recordToRowCopier);
                        }
                        TableReaderRecordCursor cursor = reader.getCursor();
                        SqlCompiler.this.copyTableData(cursor, reader.getMetadata(), backupWriter, writerMetadata, recordToRowCopier);
                        backupWriter.commit();
                    }
                }
                this.srcPath.of(SqlCompiler.this.configuration.getBackupRoot()).concat(SqlCompiler.this.configuration.getBackupTempDirName()).concat(tableName).$();
                try {
                    this.dstPath.trimTo(renameRootLen).concat(tableName).$();
                    TableUtils.renameOrFail(SqlCompiler.this.ff, this.srcPath, this.dstPath);
                    LOG.info().$("backup complete [table=").$(tableName).$(", to=").$(this.dstPath).$(']').$();
                }
                finally {
                    this.dstPath.trimTo(renameRootLen).$();
                }
            }
            catch (CairoException | SqlException e) {
                LOG.info().$("could not backup [table=").$(tableName).$(", ex=").$(((FlyweightMessageContainer)((Object)e)).getFlyweightMessage()).$(", errno=").$(e instanceof CairoException ? ((CairoException)e).getErrno() : 0).$(']').$();
                this.srcPath.of(this.cachedTmpBackupRoot).concat(tableName).slash$();
                int errno = SqlCompiler.this.ff.rmdir(this.srcPath);
                if (errno != 0) {
                    LOG.error().$("could not delete directory [path=").$(this.srcPath).$(", errno=").$(errno).$(']').$();
                }
                throw e;
            }
        }

        private void cdConfRenamePath() {
            this.mkdir("conf", "could not create backup [conf dir=");
        }

        private void cdDbRenamePath() {
            this.mkdir(SqlCompiler.this.configuration.getDbDirectory(), "could not create backup [db dir=");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cloneMetaData(CharSequence tableName, CharSequence backupRoot, int mkDirMode, TableReader reader) {
            this.srcPath.of(backupRoot).concat(tableName).slash$();
            if (SqlCompiler.this.ff.exists(this.srcPath)) {
                throw CairoException.nonCritical().put("Backup dir for table \"").put(tableName).put("\" already exists [dir=").put(this.srcPath).put(']');
            }
            if (SqlCompiler.this.ff.mkdirs(this.srcPath, mkDirMode) != 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put("Could not create [dir=").put(this.srcPath).put(']');
            }
            int rootLen = this.srcPath.length();
            TableReaderMetadata sourceMetaData = reader.getMetadata();
            try {
                SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.srcPath.trimTo(rootLen).concat("_meta").$(), 0);
                sourceMetaData.dumpTo(SqlCompiler.this.mem);
                this.srcPath.trimTo(rootLen).$();
                int symbolMapCount = 0;
                int sz = sourceMetaData.getColumnCount();
                for (int i = 0; i < sz; ++i) {
                    if (!ColumnType.isSymbol(sourceMetaData.getColumnType(i))) continue;
                    SymbolMapReader mapReader = reader.getSymbolMapReader(i);
                    MapWriter.createSymbolMapFiles(SqlCompiler.this.ff, SqlCompiler.this.mem, this.srcPath, sourceMetaData.getColumnName(i), -1L, mapReader.getSymbolCapacity(), mapReader.isCached());
                    ++symbolMapCount;
                }
                SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.srcPath.trimTo(rootLen).concat("_txn").$(), 0);
                TableUtils.createTxn(SqlCompiler.this.mem, symbolMapCount, 0L, 0L, 0L, sourceMetaData.getStructureVersion(), 0L, 0L);
                SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.srcPath.trimTo(rootLen).concat("_cv").$(), 0);
                TableUtils.createColumnVersionFile(SqlCompiler.this.mem);
                this.srcPath.trimTo(rootLen).concat("_txn_scoreboard").$();
            }
            finally {
                SqlCompiler.this.mem.close();
            }
        }

        private void mkdir(CharSequence dir, String errorMessage) {
            this.dstPath.trimTo(this.changeDirPrefixLen).concat(dir).slash$();
            this.currDirPrefixLen = this.dstPath.length();
            if (SqlCompiler.this.ff.mkdirs(this.dstPath, SqlCompiler.this.configuration.getBackupMkDirMode()) != 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put(errorMessage).put(this.dstPath).put(']');
            }
        }

        private void setupBackupRenamePath() {
            DateFormat format = SqlCompiler.this.configuration.getBackupDirTimestampFormat();
            long epochMicros = SqlCompiler.this.configuration.getMicrosecondClock().getTicks();
            int n = 0;
            this.dstPath.of(SqlCompiler.this.configuration.getBackupRoot()).slash();
            int plen = this.dstPath.length();
            do {
                this.dstPath.trimTo(plen);
                format.format(epochMicros, SqlCompiler.this.configuration.getDefaultDateLocale(), null, this.dstPath);
                if (n > 0) {
                    this.dstPath.put('.').put(n);
                }
                this.dstPath.slash$();
                ++n;
            } while (SqlCompiler.this.ff.exists(this.dstPath));
            if (SqlCompiler.this.ff.mkdirs(this.dstPath, SqlCompiler.this.configuration.getBackupMkDirMode()) != 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put("could not create backup [dir=").put(this.dstPath).put(']');
            }
            this.changeDirPrefixLen = this.dstPath.length();
        }

        private CompiledQuery sqlBackup(SqlExecutionContext executionContext) throws SqlException {
            executionContext.getCairoSecurityContext().checkWritePermission();
            if (null == SqlCompiler.this.configuration.getBackupRoot()) {
                throw CairoException.nonCritical().put("Backup is disabled, no backup root directory is configured in the server configuration ['cairo.sql.backup.root' property]");
            }
            CharSequence tok = SqlUtil.fetchNext(SqlCompiler.this.lexer);
            if (null != tok) {
                if (SqlKeywords.isTableKeyword(tok)) {
                    return this.sqlTableBackup(executionContext);
                }
                if (SqlKeywords.isDatabaseKeyword(tok)) {
                    return this.sqlDatabaseBackup(executionContext);
                }
            }
            throw SqlException.position(SqlCompiler.this.lexer.lastTokenPosition()).put("expected 'table' or 'database'");
        }

        private CompiledQuery sqlDatabaseBackup(SqlExecutionContext executionContext) {
            this.currentExecutionContext = executionContext;
            try {
                this.setupBackupRenamePath();
                this.cdDbRenamePath();
                SqlCompiler.this.ff.iterateDir(this.srcPath.of(SqlCompiler.this.configuration.getRoot()).$(), this.sqlDatabaseBackupOnFind);
                this.backupTabIndexFile();
                this.cdConfRenamePath();
                SqlCompiler.this.ff.iterateDir(this.srcPath.of(SqlCompiler.this.configuration.getConfRoot()).$(), this.confFilesBackupOnFind);
                CompiledQuery compiledQuery = SqlCompiler.this.compiledQuery.ofBackupTable();
                return compiledQuery;
            }
            finally {
                this.currentExecutionContext = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompiledQuery sqlTableBackup(SqlExecutionContext executionContext) throws SqlException {
            this.setupBackupRenamePath();
            this.cdDbRenamePath();
            try {
                block7: {
                    CharSequence tok;
                    this.tableNames.clear();
                    do {
                        if (null == (tok = SqlUtil.fetchNext(SqlCompiler.this.lexer))) {
                            throw SqlException.position(SqlCompiler.this.lexer.getPosition()).put("expected a table name");
                        }
                        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), SqlCompiler.this.lexer.lastTokenPosition());
                        int status = SqlCompiler.this.engine.getStatus(executionContext.getCairoSecurityContext(), this.srcPath, tableName, 0, tableName.length());
                        if (status != 0) {
                            throw SqlException.$(SqlCompiler.this.lexer.lastTokenPosition(), "table does not exist [table=").put(tableName).put(']');
                        }
                        this.tableNames.add(tableName);
                        tok = SqlUtil.fetchNext(SqlCompiler.this.lexer);
                        if (null == tok || Chars.equals(tok, ';')) break block7;
                    } while (Chars.equals(tok, ','));
                    throw SqlException.position(SqlCompiler.this.lexer.lastTokenPosition()).put("expected ','");
                }
                for (int n = 0; n < this.tableNames.size(); ++n) {
                    this.backupTable(this.tableNames.get(n), executionContext);
                }
                CompiledQuery compiledQuery = SqlCompiler.this.compiledQuery.ofBackupTable();
                return compiledQuery;
            }
            finally {
                this.tableNames.clear();
            }
        }
    }

    private static class TimestampValueRecord
    implements Record {
        private long value;

        private TimestampValueRecord() {
        }

        @Override
        public long getTimestamp(int col) {
            return this.value;
        }

        public void setTimestamp(long value) {
            this.value = value;
        }
    }

    private static class TableStructureAdapter
    implements TableStructure {
        private CreateTableModel model;
        private RecordMetadata metadata;
        private IntIntHashMap typeCast;
        private int timestampIndex;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public long getColumnHash(int columnIndex) {
            return this.metadata.getColumnHash(columnIndex);
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            int castIndex = this.typeCast.keyIndex(columnIndex);
            if (castIndex < 0) {
                return this.typeCast.valueAt(castIndex);
            }
            return this.metadata.getColumnType(columnIndex);
        }

        @Override
        public long getCommitLag() {
            return this.model.getCommitLag();
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return this.model.getIndexBlockCapacity(columnIndex);
        }

        @Override
        public int getMaxUncommittedRows() {
            return this.model.getMaxUncommittedRows();
        }

        @Override
        public int getPartitionBy() {
            return this.model.getPartitionBy();
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCacheFlag();
            }
            return this.model.getSymbolCacheFlag(columnIndex);
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCapacity();
            }
            return this.model.getSymbolCapacity(columnIndex);
        }

        @Override
        public CharSequence getTableName() {
            return this.model.getTableName();
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampIndex;
        }

        @Override
        public boolean isWallEnabled() {
            return this.model.isWallEnabled();
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return this.model.isIndexed(columnIndex);
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return this.model.isSequential(columnIndex);
        }

        TableStructureAdapter of(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) {
            this.timestampIndex = model.getTimestampIndex() != -1 ? model.getTimestampIndex() : metadata.getTimestampIndex();
            this.model = model;
            this.metadata = metadata;
            this.typeCast = typeCast;
            return this;
        }
    }

    public static final class PartitionAction {
        public static final int DROP = 1;
        public static final int ATTACH = 2;
        public static final int DETACH = 3;
    }

    @FunctionalInterface
    private static interface ExecutableMethod {
        public CompiledQuery execute(ExecutionModel var1, SqlExecutionContext var2) throws SqlException;
    }

    @FunctionalInterface
    protected static interface KeywordBasedExecutor {
        public CompiledQuery execute(SqlExecutionContext var1) throws SqlException;
    }
}

