/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.Plannable;
import io.questdb.std.Sinkable;
import io.questdb.std.str.StringSink;

public class PlanSink {
    private final StringSink sink = new StringSink();
    private int depth = 0;
    private String childIndent = "    ";
    private String attrIndent = "  ";

    public void reset() {
        this.sink.clear();
        this.depth = 0;
        this.attrIndent = "  ";
        this.childIndent = "    ";
    }

    public PlanSink type(CharSequence type) {
        this.sink.put(type);
        return this;
    }

    public PlanSink meta(CharSequence name) {
        this.sink.put(" ");
        this.sink.put(name).put('=');
        return this;
    }

    public PlanSink attr(CharSequence name) {
        this.newLine();
        this.sink.put(this.attrIndent);
        this.sink.put(name).put('=');
        return this;
    }

    public PlanSink val(char c) {
        this.sink.put(c);
        return this;
    }

    public PlanSink val(int i) {
        this.sink.put(i);
        return this;
    }

    public PlanSink val(long l) {
        this.sink.put(l);
        return this;
    }

    public PlanSink val(float f) {
        this.sink.put(f);
        return this;
    }

    public PlanSink val(double d) {
        this.sink.put(d);
        return this;
    }

    public PlanSink val(boolean b) {
        this.sink.put(b);
        return this;
    }

    public PlanSink val(CharSequence cs) {
        this.sink.put(cs);
        return this;
    }

    public PlanSink val(Sinkable s) {
        if (s != null) {
            this.sink.put(s);
        }
        return this;
    }

    public PlanSink child(Plannable p) {
        ++this.depth;
        this.newLine();
        p.toPlan(this);
        --this.depth;
        return this;
    }

    private void newLine() {
        this.sink.put("\n");
        for (int i = 0; i < this.depth; ++i) {
            this.sink.put(this.childIndent);
        }
    }

    public CharSequence getText() {
        return this.sink;
    }
}

