/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.std.ObjList;

public class InsertRowImpl {
    private final VirtualRecord virtualRecord;
    private final RecordToRowCopier copier;
    private final Function timestampFunction;
    private final RowFactory rowFactory;
    private final int tupleIndex;

    public InsertRowImpl(VirtualRecord virtualRecord, RecordToRowCopier copier, Function timestampFunction, int tupleIndex) {
        this.virtualRecord = virtualRecord;
        this.copier = copier;
        this.timestampFunction = timestampFunction;
        this.tupleIndex = tupleIndex;
        this.rowFactory = timestampFunction != null ? (!ColumnType.isString(timestampFunction.getType()) ? this::getRowWithTimestamp : this::getRowWithStringTimestamp) : this::getRowWithoutTimestamp;
    }

    private TableWriter.Row getRowWithTimestamp(TableWriter tableWriter) {
        return tableWriter.newRow(this.timestampFunction.getTimestamp(null));
    }

    private TableWriter.Row getRowWithStringTimestamp(TableWriter tableWriter) throws SqlException {
        return tableWriter.newRow(SqlUtil.parseFloorPartialTimestamp(this.timestampFunction.getStr(null), this.tupleIndex, 8));
    }

    private TableWriter.Row getRowWithoutTimestamp(TableWriter tableWriter) {
        return tableWriter.newRow();
    }

    public void initContext(SqlExecutionContext executionContext) throws SqlException {
        ObjList<? extends Function> functions = this.virtualRecord.getFunctions();
        Function.init(functions, null, executionContext);
        if (this.timestampFunction != null) {
            this.timestampFunction.init(null, executionContext);
        }
    }

    public void append(TableWriter writer) throws SqlException {
        TableWriter.Row row = this.rowFactory.getRow(writer);
        this.copier.copy(this.virtualRecord, row);
        row.append();
    }

    @FunctionalInterface
    private static interface RowFactory {
        public TableWriter.Row getRow(TableWriter var1) throws SqlException;
    }
}

