/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.griffin.ExpressionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;

public final class GeoHashUtil {
    private GeoHashUtil() {
    }

    public static int parseGeoHashBits(int position, int start, CharSequence sizeStr) throws SqlException {
        int size;
        assert (start >= 0);
        if (sizeStr.length() - start < 2) {
            throw SqlException.position(position).put("invalid GEOHASH size, must be number followed by 'C' or 'B' character");
        }
        try {
            size = Numbers.parseInt(sizeStr, start, sizeStr.length() - 1);
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("invalid GEOHASH size, must be number followed by 'C' or 'B' character");
        }
        switch (sizeStr.charAt(sizeStr.length() - 1)) {
            case 'C': 
            case 'c': {
                size *= 5;
                break;
            }
            case 'B': 
            case 'b': {
                break;
            }
            default: {
                throw SqlException.position(position).put("invalid GEOHASH size units, must be 'c', 'C' for chars, or 'b', 'B' for bits");
            }
        }
        if (size < 1 || size > ColumnType.GEO_HASH_MAX_BITS_LENGTH) {
            throw SqlException.position(position).put("invalid GEOHASH type precision range, must be [1, 60] bits, provided=").put(size);
        }
        return size;
    }

    public static ConstantFunction parseGeoHashConstant(int position, CharSequence tok, int len) throws SqlException {
        try {
            if (tok.charAt(1) != '#') {
                int sdd = ExpressionParser.extractGeoHashSuffix(position, tok);
                short sddLen = Numbers.decodeLowShort(sdd);
                short bits = Numbers.decodeHighShort(sdd);
                return Constants.getGeoHashConstant(GeoHashes.fromStringTruncatingNl(tok, 1, len - sddLen, bits), bits);
            }
            int bits = len - 2;
            if (bits <= ColumnType.GEO_HASH_MAX_BITS_LENGTH) {
                return Constants.getGeoHashConstant(GeoHashes.fromBitStringNl(tok, 2), bits);
            }
        }
        catch (NumericException numericException) {
            // empty catch block
        }
        return null;
    }
}

