/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.TableListRecordCursorFactory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class DatabaseSnapshotAgent
implements Closeable {
    private static final Log LOG = LogFactory.getLog(DatabaseSnapshotAgent.class);
    private final CairoEngine engine;
    private final CairoConfiguration configuration;
    private final FilesFacade ff;
    private final ReentrantLock lock = new ReentrantLock();
    private final Path path = new Path();
    private final ObjList<TableReader> snapshotReaders = new ObjList();

    public DatabaseSnapshotAgent(CairoEngine engine) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.ff = this.configuration.getFilesFacade();
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            Misc.free(this.path);
            this.unsafeReleaseReaders();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.unsafeReleaseReaders();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unsafeReleaseReaders() {
        Misc.freeObjList(this.snapshotReaders);
        this.snapshotReaders.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void recoverSnapshot(CairoEngine engine) {
        CairoConfiguration configuration = engine.getConfiguration();
        if (!configuration.isSnapshotRecoveryEnabled()) {
            return;
        }
        FilesFacade ff = configuration.getFilesFacade();
        CharSequence root = configuration.getRoot();
        CharSequence snapshotRoot = configuration.getSnapshotRoot();
        try (Path path = new Path();
             Path copyPath = new Path();){
            path.of(snapshotRoot).concat(configuration.getDbDirectory());
            int snapshotRootLen = path.length();
            copyPath.of(root);
            int rootLen = copyPath.length();
            if (!ff.exists(path.slash$())) {
                return;
            }
            path.trimTo(snapshotRootLen).concat("_snapshot").$();
            if (!ff.exists(path)) {
                return;
            }
            try (MemoryCMARW mem = Vm.getCMARWInstance();){
                mem.smallFile(ff, path, 0);
                CharSequence currentInstanceId = configuration.getSnapshotInstanceId();
                CharSequence snapshotInstanceId = mem.getStr(0L);
                if (!Chars.nonEmpty(currentInstanceId)) return;
                if (!Chars.nonEmpty(snapshotInstanceId)) return;
                if (Chars.equals(currentInstanceId, snapshotInstanceId)) {
                    return;
                }
                LOG.info().$("starting snapshot recovery [currentId=`").$(currentInstanceId).$("`, previousId=`").$(snapshotInstanceId).$("`]").$();
            }
            AtomicInteger recoveredMetaFiles = new AtomicInteger();
            AtomicInteger recoveredTxnFiles = new AtomicInteger();
            AtomicInteger recoveredCVFiles = new AtomicInteger();
            path.trimTo(snapshotRootLen).$();
            int snapshotDbLen = path.length();
            ff.iterateDir(path, (pUtf8NameZ, type) -> {
                if (Files.isDir(pUtf8NameZ, type)) {
                    path.trimTo(snapshotDbLen).concat(pUtf8NameZ);
                    copyPath.trimTo(rootLen).concat(pUtf8NameZ);
                    int plen = path.length();
                    int cplen = copyPath.length();
                    path.concat("_meta").$();
                    copyPath.concat("_meta").$();
                    if (ff.exists(path) && ff.exists(copyPath)) {
                        if (ff.copy(path, copyPath) < 0) {
                            LOG.error().$("could not copy _meta file [src=").$(path).$(", dst=").$(copyPath).$(", errno=").$(ff.errno()).$(']').$();
                        } else {
                            recoveredMetaFiles.incrementAndGet();
                            LOG.info().$("recovered _meta file [src=").$(path).$(", dst=").$(copyPath).$(']').$();
                        }
                    }
                    path.trimTo(plen).concat("_txn").$();
                    copyPath.trimTo(cplen).concat("_txn").$();
                    if (ff.exists(path) && ff.exists(copyPath)) {
                        if (ff.copy(path, copyPath) < 0) {
                            LOG.error().$("could not copy _txn file [src=").$(path).$(", dst=").$(copyPath).$(", errno=").$(ff.errno()).$(']').$();
                        } else {
                            recoveredTxnFiles.incrementAndGet();
                            LOG.info().$("recovered _txn file [src=").$(path).$(", dst=").$(copyPath).$(']').$();
                        }
                    }
                    path.trimTo(plen).concat("_cv").$();
                    copyPath.trimTo(cplen).concat("_cv").$();
                    if (ff.exists(path) && ff.exists(copyPath)) {
                        if (ff.copy(path, copyPath) < 0) {
                            LOG.error().$("could not copy _cv file [src=").$(path).$(", dst=").$(copyPath).$(", errno=").$(ff.errno()).$(']').$();
                        } else {
                            recoveredCVFiles.incrementAndGet();
                            LOG.info().$("recovered _cv file [src=").$(path).$(", dst=").$(copyPath).$(']').$();
                        }
                    }
                }
            });
            LOG.info().$("snapshot recovery finished [metaFilesCount=").$(recoveredMetaFiles.get()).$(", txnFilesCount=").$(recoveredTxnFiles.get()).$(", cvFilesCount=").$(recoveredCVFiles.get()).$(']').$();
            path.trimTo(snapshotRootLen).$();
            if (ff.rmdir(path) == 0) return;
            throw CairoException.critical(ff.errno()).put("could not remove snapshot dir [dir=").put(path).put(", errno=").put(ff.errno()).put(']');
        }
    }

    public void completeSnapshot() throws SqlException {
        if (!this.lock.tryLock()) {
            throw SqlException.position(0).put("Another snapshot command in progress");
        }
        try {
            if (this.snapshotReaders.size() == 0) {
                LOG.info().$("Snapshot has no tables, SNAPSHOT COMPLETE is ignored.").$();
                return;
            }
            this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory()).$();
            this.ff.rmdir(this.path);
            this.unsafeReleaseReaders();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareSnapshot(SqlExecutionContext executionContext) throws SqlException {
        if (Os.type == 3) {
            throw SqlException.position(0).put("Snapshots are not supported on Windows");
        }
        if (!this.lock.tryLock()) {
            throw SqlException.position(0).put("Another snapshot command in progress");
        }
        try {
            if (this.snapshotReaders.size() > 0) {
                throw SqlException.position(0).put("Waiting for SNAPSHOT COMPLETE to be called");
            }
            this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory());
            int snapshotLen = this.path.length();
            if (this.ff.exists(this.path.slash$())) {
                this.path.trimTo(snapshotLen).$();
                if (this.ff.rmdir(this.path) != 0) {
                    throw CairoException.critical(this.ff.errno()).put("Could not remove snapshot dir [dir=").put(this.path).put(']');
                }
            }
            this.path.trimTo(snapshotLen).slash$();
            if (this.ff.mkdirs(this.path, this.configuration.getMkDirMode()) != 0) {
                throw CairoException.critical(this.ff.errno()).put("Could not create [dir=").put(this.path).put(']');
            }
            try (TableListRecordCursorFactory factory = new TableListRecordCursorFactory(this.configuration.getFilesFacade(), this.configuration.getRoot());){
                int tableNameIndex = factory.getMetadata().getColumnIndex("table");
                try (RecordCursor cursor = factory.getCursor(executionContext);){
                    Record record = cursor.getRecord();
                    try (MemoryCMARW mem = Vm.getCMARWInstance();){
                        while (cursor.hasNext()) {
                            CharSequence tableName = record.getStr(tableNameIndex);
                            if (TableUtils.isValidTableName(tableName, tableName.length()) && this.ff.exists(this.path.of(this.configuration.getRoot()).concat(tableName).concat("_meta").$())) {
                                this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory());
                                LOG.info().$("preparing for snapshot [table=").$(tableName).I$();
                                TableReader reader = this.engine.getReaderForStatement(executionContext, tableName, "snapshot");
                                this.snapshotReaders.add(reader);
                                this.path.trimTo(snapshotLen).concat(tableName).slash$();
                                if (this.ff.mkdirs(this.path, this.configuration.getMkDirMode()) != 0) {
                                    throw CairoException.critical(this.ff.errno()).put("Could not create [dir=").put(this.path).put(']');
                                }
                                int rootLen = this.path.length();
                                this.path.trimTo(rootLen).concat("_meta").$();
                                mem.smallFile(this.ff, this.path, 0);
                                reader.getMetadata().dumpTo(mem);
                                mem.close(false);
                                this.path.trimTo(rootLen).concat("_txn").$();
                                mem.smallFile(this.ff, this.path, 0);
                                reader.getTxFile().dumpTo(mem);
                                mem.close(false);
                                this.path.trimTo(rootLen).concat("_cv").$();
                                mem.smallFile(this.ff, this.path, 0);
                                reader.getColumnVersionReader().dumpTo(mem);
                                mem.close(false);
                                continue;
                            }
                            LOG.error().$("skipping, invalid table name or missing metadata [table=").$(tableName).I$();
                        }
                        this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory()).concat("_snapshot").$();
                        mem.smallFile(this.ff, this.path, 0);
                        mem.putStr(this.configuration.getSnapshotInstanceId());
                        mem.close();
                        if (this.ff.sync() != 0) {
                            throw CairoException.critical(this.ff.errno()).put("Could not sync");
                        }
                        LOG.info().$("snapshot copying finished").$();
                    }
                    catch (Throwable e) {
                        this.unsafeReleaseReaders();
                        LOG.error().$("snapshot error [e=").$(e).I$();
                        throw e;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

