/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.TextUtil;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.DirectCharSink;

public class SymbolAdapter
extends AbstractTypeAdapter {
    private final DirectCharSink utf8Sink;
    private final boolean indexed;

    public SymbolAdapter(DirectCharSink utf8Sink, boolean indexed) {
        this.utf8Sink = utf8Sink;
        this.indexed = indexed;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        this.write(row, column, value, this.utf8Sink);
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value, DirectCharSink utf8Sink) throws Exception {
        utf8Sink.clear();
        TextUtil.utf8DecodeEscConsecutiveQuotes(value.getLo(), value.getHi(), utf8Sink);
        row.putSym(column, utf8Sink);
    }
}

