/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.json.JsonParser;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.DateLocaleFactory;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputFormatConfiguration {
    private static final Log LOG = LogFactory.getLog(InputFormatConfiguration.class);
    private static final int STATE_EXPECT_TOP = 0;
    private static final int STATE_EXPECT_FIRST_LEVEL_NAME = 1;
    private static final int STATE_EXPECT_DATE_FORMAT_ARRAY = 2;
    private static final int STATE_EXPECT_TIMESTAMP_FORMAT_ARRAY = 3;
    private static final int STATE_EXPECT_DATE_FORMAT_VALUE = 4;
    private static final int STATE_EXPECT_DATE_LOCALE_VALUE = 5;
    private static final int STATE_EXPECT_DATE_UTF8_VALUE = 10;
    private static final int STATE_EXPECT_TIMESTAMP_FORMAT_VALUE = 6;
    private static final int STATE_EXPECT_TIMESTAMP_LOCALE_VALUE = 7;
    private static final int STATE_EXPECT_DATE_FORMAT_ENTRY = 8;
    private static final int STATE_EXPECT_TIMESTAMP_FORMAT_ENTRY = 9;
    private static final int STATE_EXPECT_TIMESTAMP_UTF8_VALUE = 11;
    private final ObjList<DateFormat> dateFormats = new ObjList();
    private final ObjList<DateLocale> dateLocales = new ObjList();
    private final IntList dateUtf8Flags = new IntList();
    private final ObjList<DateFormat> timestampFormats = new ObjList();
    private final ObjList<DateLocale> timestampLocales = new ObjList();
    private final IntList timestampUtf8Flags = new IntList();
    private final DateFormatFactory dateFormatFactory;
    private final DateLocaleFactory dateLocaleFactory;
    private final TimestampFormatFactory timestampFormatFactory;
    private int jsonState = 0;
    private DateFormat jsonDateFormat;
    private DateLocale jsonDateLocale;
    private boolean jsonDateUtf8;
    private DateFormat jsonTimestampFormat;
    private DateLocale jsonTimestampLocale;
    private boolean jsonTimestampUtf8;
    private final DateLocale dateLocale;

    public InputFormatConfiguration(DateFormatFactory dateFormatFactory, DateLocaleFactory dateLocaleFactory, TimestampFormatFactory timestampFormatFactory, DateLocale dateLocale) {
        this.dateFormatFactory = dateFormatFactory;
        this.dateLocaleFactory = dateLocaleFactory;
        this.timestampFormatFactory = timestampFormatFactory;
        this.dateLocale = dateLocale;
    }

    public void clear() {
        this.dateFormats.clear();
        this.dateLocales.clear();
        this.dateUtf8Flags.clear();
        this.timestampFormats.clear();
        this.timestampLocales.clear();
        this.timestampUtf8Flags.clear();
        this.jsonState = 0;
        this.jsonDateFormat = null;
        this.jsonDateLocale = null;
        this.jsonDateUtf8 = false;
        this.jsonTimestampFormat = null;
        this.jsonTimestampLocale = null;
        this.jsonTimestampUtf8 = false;
    }

    public DateFormatFactory getDateFormatFactory() {
        return this.dateFormatFactory;
    }

    public ObjList<DateFormat> getDateFormats() {
        return this.dateFormats;
    }

    public DateLocaleFactory getDateLocaleFactory() {
        return this.dateLocaleFactory;
    }

    public ObjList<DateLocale> getDateLocales() {
        return this.dateLocales;
    }

    public IntList getDateUtf8Flags() {
        return this.dateUtf8Flags;
    }

    public TimestampFormatFactory getTimestampFormatFactory() {
        return this.timestampFormatFactory;
    }

    public ObjList<DateFormat> getTimestampFormats() {
        return this.timestampFormats;
    }

    public ObjList<DateLocale> getTimestampLocales() {
        return this.timestampLocales;
    }

    public IntList getTimestampUtf8Flags() {
        return this.timestampUtf8Flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseConfiguration(JsonLexer jsonLexer, String confRoot, String configFileName) throws JsonException {
        this.clear();
        jsonLexer.clear();
        JsonParser parser = this::onJsonEvent;
        try (InputStream stream = this.openStream(confRoot, configFileName);){
            byte[] heapBuffer = new byte[4096];
            long memBuffer = Unsafe.malloc(heapBuffer.length, 1);
            try {
                int len;
                while ((len = stream.read(heapBuffer)) > 0) {
                    for (int i = 0; i < len; ++i) {
                        Unsafe.getUnsafe().putByte(memBuffer + (long)i, heapBuffer[i]);
                    }
                    jsonLexer.parse(memBuffer, memBuffer + (long)len, parser);
                }
                jsonLexer.clear();
            }
            finally {
                Unsafe.free(memBuffer, heapBuffer.length, 1);
            }
        }
        catch (IOException e) {
            throw JsonException.$(0, "could not read input format config [confRoot=").put(confRoot).put(", configFileName=").put(configFileName).put(']');
        }
    }

    private InputStream openStream(String confRoot, String configFileName) throws IOException, JsonException {
        File configFile;
        InputStream stream = this.getClass().getResourceAsStream(configFileName);
        if (stream != null) {
            LOG.info().$("loading input format config [resource=").$(configFileName).$(']').$();
            return stream;
        }
        if (confRoot != null && (configFile = new File(confRoot, configFileName)).exists()) {
            LOG.info().$("loading input format config [file=").$(configFile.getAbsolutePath()).$(']').$();
            return new FileInputStream(configFile);
        }
        throw JsonException.$(0, "could not find input format config [confRoot=").put(confRoot).put(", configFileName=").put(configFileName).put(']');
    }

    private void onJsonEvent(int code, CharSequence tag, int position) throws JsonException {
        block0 : switch (code) {
            case 1: {
                switch (this.jsonState) {
                    case 0: {
                        this.jsonState = 1;
                        break block0;
                    }
                    case 4: 
                    case 6: {
                        throw JsonException.$(position, "format value expected (obj)");
                    }
                    case 5: 
                    case 7: {
                        throw JsonException.$(position, "locale value expected (obj)");
                    }
                    case 8: {
                        this.jsonDateFormat = null;
                        this.jsonDateLocale = null;
                        break block0;
                    }
                    case 9: {
                        this.jsonTimestampFormat = null;
                        this.jsonTimestampLocale = null;
                        break block0;
                    }
                }
                throw JsonException.$(position, "array expected (obj)");
            }
            case 2: {
                switch (this.jsonState) {
                    case 8: {
                        if (this.jsonDateFormat == null) {
                            throw JsonException.$(position, "date format is missing");
                        }
                        this.dateFormats.add(this.jsonDateFormat);
                        this.dateLocales.add(this.jsonDateLocale == null ? this.dateLocale : this.jsonDateLocale);
                        this.dateUtf8Flags.add(this.jsonDateUtf8 ? 1 : 0);
                        break block0;
                    }
                    case 9: {
                        if (this.jsonTimestampFormat == null) {
                            throw JsonException.$(position, "timestamp format is missing");
                        }
                        this.timestampFormats.add(this.jsonTimestampFormat);
                        this.timestampLocales.add(this.jsonTimestampLocale == null ? this.dateLocale : this.jsonTimestampLocale);
                        this.timestampUtf8Flags.add(this.jsonTimestampUtf8 ? 1 : 0);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                this.jsonState = 1;
                break;
            }
            case 5: {
                switch (this.jsonState) {
                    case 1: {
                        if (Chars.equals(tag, "date")) {
                            this.jsonState = 2;
                            break block0;
                        }
                        if (Chars.equals(tag, "timestamp")) {
                            this.jsonState = 3;
                            break block0;
                        }
                        throw JsonException.$(position, "'date' and/or 'timestamp' expected");
                    }
                    case 8: {
                        this.processEntry(tag, position, 4, 5, 10);
                        break block0;
                    }
                }
                this.processEntry(tag, position, 6, 7, 11);
                break;
            }
            case 6: {
                switch (this.jsonState) {
                    case 4: {
                        assert (this.jsonDateFormat == null);
                        if (Chars.equals((CharSequence)"null", tag)) {
                            throw JsonException.$(position, "null format");
                        }
                        this.jsonDateFormat = this.dateFormatFactory.get(tag);
                        this.jsonState = 8;
                        break block0;
                    }
                    case 5: {
                        assert (this.jsonDateLocale == null);
                        this.jsonDateLocale = this.dateLocaleFactory.getLocale(tag);
                        if (this.jsonDateLocale == null) {
                            throw JsonException.$(position, "invalid [locale=").put(tag).put(']');
                        }
                        this.jsonState = 8;
                        break block0;
                    }
                    case 6: {
                        assert (this.jsonTimestampFormat == null);
                        if (Chars.equals((CharSequence)"null", tag)) {
                            throw JsonException.$(position, "null format");
                        }
                        this.jsonTimestampFormat = this.timestampFormatFactory.get(tag);
                        this.jsonState = 9;
                        break block0;
                    }
                    case 7: {
                        assert (this.jsonTimestampLocale == null);
                        this.jsonTimestampLocale = this.dateLocaleFactory.getLocale(tag);
                        if (this.jsonTimestampLocale == null) {
                            throw JsonException.$(position, "invalid [locale=").put(tag).put(']');
                        }
                        this.jsonState = 9;
                        break block0;
                    }
                    case 11: {
                        this.jsonTimestampUtf8 = Chars.equalsLowerCaseAscii(tag, "true");
                        this.jsonState = 9;
                        break block0;
                    }
                    case 10: {
                        this.jsonDateUtf8 = Chars.equalsLowerCaseAscii(tag, "true");
                        this.jsonState = 8;
                        break block0;
                    }
                }
                throw JsonException.$(position, "array expected (value)");
            }
            case 3: {
                switch (this.jsonState) {
                    case 2: {
                        this.jsonState = 8;
                        break block0;
                    }
                    case 3: {
                        this.jsonState = 9;
                        break block0;
                    }
                    case 4: 
                    case 6: {
                        throw JsonException.$(position, "format value expected (array)");
                    }
                }
                throw JsonException.$(position, "locale value expected (array)");
            }
        }
    }

    private void processEntry(CharSequence tag, int position, int stateExpectFormatValue, int stateExpectLocaleValue, int stateExpectUtf8Value) throws JsonException {
        if (Chars.equals(tag, "format")) {
            this.jsonState = stateExpectFormatValue;
        } else if (Chars.equals(tag, "locale")) {
            this.jsonState = stateExpectLocaleValue;
        } else if (Chars.equals(tag, "utf8")) {
            this.jsonState = stateExpectUtf8Value;
        } else {
            throw JsonException.$(position, "unknown [tag=").put(tag).put(']');
        }
    }
}

