/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.text.CairoTextWriter;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLexer;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TextLoaderBase
implements Closeable,
Mutable {
    private final CairoTextWriter textWriter;
    private final TextLexer textLexer;

    public TextLoaderBase(CairoEngine engine) {
        this.textLexer = new TextLexer(engine.getConfiguration().getTextConfiguration());
        this.textWriter = new CairoTextWriter(engine);
        this.textLexer.setSkipLinesWithExtraValues(true);
    }

    @Override
    public void clear() {
        this.textWriter.clear();
        this.textLexer.clear();
    }

    @Override
    public void close() {
        Misc.free(this.textWriter);
        Misc.free(this.textLexer);
    }

    public void closeWriter() {
        this.textWriter.closeWriter();
    }

    public void configureDestination(CharSequence tableName, boolean overwrite, boolean durable, int atomicity, int partitionBy, CharSequence timestampColumn) {
        this.textWriter.of(tableName, overwrite, durable, atomicity, partitionBy, timestampColumn);
        this.textLexer.setTableName(tableName);
    }

    public LongList getColumnErrorCounts() {
        return this.textWriter.getColumnErrorCounts();
    }

    public long getErrorLineCount() {
        return this.textLexer.getErrorCount();
    }

    public RecordMetadata getMetadata() {
        return this.textWriter.getMetadata();
    }

    public long getParsedLineCount() {
        return this.textLexer.getLineCount();
    }

    public int getPartitionBy() {
        return this.textWriter.getPartitionBy();
    }

    public CharSequence getTableName() {
        return this.textWriter.getTableName();
    }

    public CharSequence getTimestampCol() {
        return this.textWriter.getTimestampCol();
    }

    public int getWarnings() {
        return this.textWriter.getWarnings();
    }

    public long getWrittenLineCount() {
        return this.textWriter.getWrittenLineCount();
    }

    public void parse(long lo, long hi, int lineCountLimit, TextLexer.Listener textLexerListener) {
        this.textLexer.parse(lo, hi, lineCountLimit, textLexerListener);
    }

    public void parse(long lo, long hi, int lineCountLimit) {
        this.textLexer.parse(lo, hi, lineCountLimit, this.textWriter.getTextListener());
    }

    public void prepareTable(CairoSecurityContext ctx, ObjList<CharSequence> names, ObjList<TypeAdapter> types, Path path, TypeManager typeManager, TimestampAdapter timestampAdapter) throws TextException {
        this.textWriter.prepareTable(ctx, names, types, path, typeManager, timestampAdapter);
    }

    public final void restart(boolean header) {
        this.textLexer.restart(header);
    }

    public void setCommitLag(long commitLag) {
        this.textWriter.setCommitLag(commitLag);
    }

    public void setDelimiter(byte delimiter) {
        this.textLexer.of(delimiter);
    }

    public void setMaxUncommittedRows(int maxUncommittedRows) {
        this.textWriter.setMaxUncommittedRows(maxUncommittedRows);
    }

    public void setSkipRowsWithExtraValues(boolean skipRowsWithExtraValues) {
        this.textLexer.setSkipLinesWithExtraValues(skipRowsWithExtraValues);
    }

    public void wrapUp() throws TextException {
        this.textLexer.parseLast();
        this.textWriter.commit();
    }

    @FunctionalInterface
    protected static interface ParserMethod {
        public void parse(long var1, long var3, CairoSecurityContext var5) throws TextException;
    }
}

