/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.PartitionBy;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextDelimiterScanner;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLoaderBase;
import io.questdb.cutlass.text.TextMetadataDetector;
import io.questdb.cutlass.text.TextMetadataParser;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;

public class TextLoader
extends TextLoaderBase {
    private static final Log LOG = LogFactory.getLog(TextLoader.class);
    public static final int LOAD_JSON_METADATA = 0;
    public static final int ANALYZE_STRUCTURE = 1;
    public static final int LOAD_DATA = 2;
    private final TextConfiguration textConfiguration;
    private final TextMetadataDetector textMetadataDetector;
    private final TextMetadataParser textMetadataParser;
    private final JsonLexer jsonLexer;
    private final Path path = new Path();
    private final int textAnalysisMaxLines;
    private final TextDelimiterScanner textDelimiterScanner;
    private final DirectCharSink utf8Sink;
    private final TypeManager typeManager;
    private TimestampAdapter timestampAdapter;
    private final ObjList<TextLoaderBase.ParserMethod> parseMethods = new ObjList();
    private int state;
    private boolean forceHeaders = false;
    private byte columnDelimiter = (byte)-1;
    private CharSequence timestampColumn;

    public TextLoader(CairoEngine engine) {
        super(engine);
        this.textConfiguration = engine.getConfiguration().getTextConfiguration();
        this.utf8Sink = new DirectCharSink(this.textConfiguration.getUtf8SinkSize());
        this.typeManager = new TypeManager(this.textConfiguration, this.utf8Sink);
        this.jsonLexer = new JsonLexer(this.textConfiguration.getJsonCacheSize(), this.textConfiguration.getJsonCacheLimit());
        this.textMetadataDetector = new TextMetadataDetector(this.typeManager, this.textConfiguration);
        this.textMetadataParser = new TextMetadataParser(this.textConfiguration, this.typeManager);
        this.textAnalysisMaxLines = this.textConfiguration.getTextAnalysisMaxLines();
        this.textDelimiterScanner = new TextDelimiterScanner(this.textConfiguration);
        this.parseMethods.extendAndSet(0, this::parseJsonMetadata);
        this.parseMethods.extendAndSet(1, this::parseStructure);
        this.parseMethods.extendAndSet(2, this::parseData);
    }

    @Override
    public void clear() {
        super.clear();
        this.textMetadataParser.clear();
        this.jsonLexer.clear();
        this.forceHeaders = false;
        this.columnDelimiter = (byte)-1;
        this.typeManager.clear();
        this.timestampAdapter = null;
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.textMetadataDetector);
        Misc.free(this.textMetadataParser);
        Misc.free(this.jsonLexer);
        Misc.free(this.path);
        Misc.free(this.textDelimiterScanner);
        Misc.free(this.utf8Sink);
    }

    public void configureColumnDelimiter(byte columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        assert (this.columnDelimiter > 0);
    }

    public void configureDestination(CharSequence tableName, boolean overwrite, boolean durable, int atomicity, int partitionBy, CharSequence timestampColumn, CharSequence timestampFormat) {
        super.configureDestination(tableName, overwrite, durable, atomicity, partitionBy, timestampColumn);
        this.textDelimiterScanner.setTableName(tableName);
        this.textMetadataParser.setTableName(tableName);
        this.timestampColumn = timestampColumn;
        if (timestampFormat != null) {
            DateFormat dateFormat = this.typeManager.getInputFormatConfiguration().getTimestampFormatFactory().get(timestampFormat);
            this.timestampAdapter = (TimestampAdapter)this.typeManager.nextTimestampAdapter(false, dateFormat, this.textConfiguration.getDefaultDateLocale());
        }
        LOG.info().$("configured [table=`").$(tableName).$("`, overwrite=").$(overwrite).$(", durable=").$(durable).$(", atomicity=").$(atomicity).$(", partitionBy=").$(PartitionBy.toString(partitionBy)).$(", timestamp=").$(timestampColumn).$(", timestampFormat=").$(timestampFormat).$(']').$();
    }

    public byte getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public boolean isForceHeaders() {
        return this.forceHeaders;
    }

    public void setForceHeaders(boolean forceHeaders) {
        this.forceHeaders = forceHeaders;
    }

    public void parse(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        this.parseMethods.getQuick(this.state).parse(lo, hi, cairoSecurityContext);
    }

    public void setState(int state) {
        LOG.debug().$("state change [old=").$(this.state).$(", new=").$(state).$(']').$();
        this.state = state;
        this.jsonLexer.clear();
    }

    @Override
    public void wrapUp() throws TextException {
        switch (this.state) {
            case 0: {
                try {
                    this.jsonLexer.parseLast();
                    break;
                }
                catch (JsonException e) {
                    throw TextException.$(e.getFlyweightMessage());
                }
            }
            case 1: 
            case 2: {
                super.wrapUp();
                break;
            }
        }
    }

    private void parseJsonMetadata(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        try {
            this.jsonLexer.parse(lo, hi, this.textMetadataParser);
        }
        catch (JsonException e) {
            throw TextException.$(e.getFlyweightMessage());
        }
    }

    private void parseData(long lo, long hi, CairoSecurityContext cairoSecurityContext) {
        this.parse(lo, hi, Integer.MAX_VALUE);
    }

    private void parseStructure(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        if (this.columnDelimiter > 0) {
            this.setDelimiter(this.columnDelimiter);
        } else {
            this.setDelimiter(this.textDelimiterScanner.scan(lo, hi));
        }
        if (this.timestampColumn != null && this.timestampAdapter != null) {
            this.textMetadataParser.getColumnNames().add(this.timestampColumn);
            this.textMetadataParser.getColumnTypes().add(this.timestampAdapter);
        }
        this.textMetadataDetector.of(this.getTableName(), this.textMetadataParser.getColumnNames(), this.textMetadataParser.getColumnTypes(), this.forceHeaders);
        this.parse(lo, hi, this.textAnalysisMaxLines, this.textMetadataDetector);
        this.textMetadataDetector.evaluateResults(this.getParsedLineCount(), this.getErrorLineCount());
        this.restart(this.textMetadataDetector.isHeader());
        this.prepareTable(cairoSecurityContext, this.textMetadataDetector.getColumnNames(), this.textMetadataDetector.getColumnTypes(), this.path, this.typeManager, this.timestampAdapter);
        this.parse(lo, hi, Integer.MAX_VALUE);
        this.state = 2;
    }
}

