/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.MessageBus;
import io.questdb.cutlass.text.CsvFileIndexer;
import io.questdb.cutlass.text.TextImportTask;
import io.questdb.cutlass.text.TextLexer;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.WorkerPool;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TextImportJob
extends AbstractQueueConsumerJob<TextImportTask>
implements Closeable {
    private static final int INDEX_MERGE_LIST_CAPACITY = 64;
    private TextLexer textLexer;
    private CsvFileIndexer indexer;
    private DirectCharSink utf8Sink;
    private DirectLongList mergeIndexes;
    private Path tmpPath1;
    private Path tmpPath2;
    private final long fileBufAddr;
    private long fileBufSize;

    public TextImportJob(MessageBus messageBus) {
        super(messageBus.getTextImportQueue(), messageBus.getTextImportSubSeq());
        this.textLexer = new TextLexer(messageBus.getConfiguration().getTextConfiguration());
        this.fileBufSize = messageBus.getConfiguration().getSqlCopyBufferSize();
        this.fileBufAddr = Unsafe.malloc(this.fileBufSize, 34);
        this.indexer = new CsvFileIndexer(messageBus.getConfiguration());
        this.utf8Sink = new DirectCharSink(messageBus.getConfiguration().getTextConfiguration().getUtf8SinkSize());
        this.mergeIndexes = new DirectLongList(64L, 34);
        this.tmpPath1 = new Path();
        this.tmpPath2 = new Path();
    }

    public static void assignToPool(MessageBus messageBus, WorkerPool pool) {
        int n = pool.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            TextImportJob job = new TextImportJob(messageBus);
            pool.assign(i, job);
            pool.freeOnHalt(job);
        }
    }

    @Override
    public void close() {
        this.textLexer = Misc.free(this.textLexer);
        this.indexer = Misc.free(this.indexer);
        if (this.fileBufSize > 0L) {
            Unsafe.free(this.fileBufAddr, this.fileBufSize, 34);
            this.fileBufSize = 0L;
        }
        this.mergeIndexes = Misc.free(this.mergeIndexes);
        this.utf8Sink = Misc.free(this.utf8Sink);
        this.tmpPath1 = Misc.free(this.tmpPath1);
        this.tmpPath2 = Misc.free(this.tmpPath2);
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        TextImportTask task = (TextImportTask)this.queue.get(cursor);
        boolean result = task.run(this.textLexer, this.indexer, this.utf8Sink, this.mergeIndexes, this.fileBufAddr, this.fileBufSize, this.tmpPath1, this.tmpPath2);
        this.subSeq.done(cursor);
        return result;
    }

    Path getTmpPath1() {
        return this.tmpPath1;
    }

    Path getTmpPath2() {
        return this.tmpPath2;
    }
}

