/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.Metrics;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGJobContext;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.FanOut;
import io.questdb.mp.Job;
import io.questdb.mp.SCSequence;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.MutableIOContextFactory;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class PGWireServer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PGWireServer.class);
    private final IODispatcher<PGConnectionContext> dispatcher;
    private final PGConnectionContextFactory contextFactory;
    private final WorkerPool workerPool;
    private final Metrics metrics;

    public PGWireServer(PGWireConfiguration configuration, CairoEngine engine, WorkerPool workerPool, boolean workerPoolLocal, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, PGConnectionContextFactory contextFactory) {
        this.contextFactory = contextFactory;
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), contextFactory);
        this.metrics = engine.getMetrics();
        workerPool.assign(this.dispatcher);
        int n = workerPool.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            final PGJobContext jobContext = new PGJobContext(configuration, engine, functionFactoryCache, snapshotAgent);
            final SCSequence queryCacheEventSubSeq = new SCSequence();
            FanOut queryCacheEventFanOut = engine.getMessageBus().getQueryCacheEventFanOut();
            queryCacheEventFanOut.and(queryCacheEventSubSeq);
            workerPool.assign(i, new Job(){
                private final IORequestProcessor<PGConnectionContext> processor = (operation, context) -> {
                    try {
                        jobContext.handleClientOperation((PGConnectionContext)context, operation);
                        context.getDispatcher().registerChannel(context, 1);
                    }
                    catch (PeerIsSlowToWriteException e) {
                        context.getDispatcher().registerChannel(context, 1);
                    }
                    catch (PeerIsSlowToReadException e) {
                        context.getDispatcher().registerChannel(context, 4);
                    }
                    catch (PeerDisconnectedException e) {
                        context.getDispatcher().disconnect(context, operation == 1 ? 15 : 11);
                    }
                    catch (BadProtocolException e) {
                        context.getDispatcher().disconnect(context, 7);
                    }
                    catch (Throwable e) {
                        LOG.critical().$("internal error [ex=").$(e).$(']').$();
                        PGWireServer.this.metrics.healthCheck().incrementUnhandledErrors();
                        context.getDispatcher().disconnect(context, 17);
                    }
                };

                @Override
                public boolean run(int workerId) {
                    long seq = queryCacheEventSubSeq.next();
                    if (seq > -1L) {
                        LOG.info().$("flushing PG Wire query cache [worker=").$(workerId).$(']').$();
                        jobContext.flushQueryCache();
                        queryCacheEventSubSeq.done(seq);
                    }
                    return PGWireServer.this.dispatcher.processIOQueue(this.processor);
                }
            });
            workerPool.assign(i, () -> {
                Misc.free(jobContext);
                contextFactory.close();
                engine.getMessageBus().getQueryCacheEventFanOut().remove(queryCacheEventSubSeq);
                queryCacheEventSubSeq.clear();
            });
        }
        this.workerPool = workerPoolLocal ? workerPool : null;
    }

    @Nullable
    public static PGWireServer create(PGWireConfiguration configuration, WorkerPool sharedWorkerPool, Log log, CairoEngine cairoEngine, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, Metrics metrics, PGConnectionContextFactory contextFactory) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, log, cairoEngine, (C conf, CairoEngine engine, WorkerPool workerPool, boolean local, int sharedWorkerCount, FunctionFactoryCache functionFactoryCache1, DatabaseSnapshotAgent snapshotAgent1, Metrics metrics1) -> new PGWireServer((PGWireConfiguration)conf, engine, workerPool, local, functionFactoryCache1, snapshotAgent1, contextFactory), functionFactoryCache, snapshotAgent, metrics);
    }

    @Nullable
    public static PGWireServer create(PGWireConfiguration configuration, WorkerPool sharedWorkerPool, Log log, CairoEngine cairoEngine, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, log, cairoEngine, (C conf, CairoEngine engine, WorkerPool workerPool, boolean local, int sharedWorkerCount, FunctionFactoryCache cache, DatabaseSnapshotAgent agent, Metrics m) -> new PGWireServer((PGWireConfiguration)conf, engine, workerPool, local, cache, agent, new PGConnectionContextFactory(engine, (PGWireConfiguration)conf, () -> new SqlExecutionContextImpl(engine, workerPool.getWorkerCount(), sharedWorkerCount))), functionFactoryCache, snapshotAgent, metrics);
    }

    @Override
    public void close() {
        if (this.workerPool != null) {
            this.workerPool.halt();
        }
        Misc.free(this.contextFactory);
        Misc.free(this.dispatcher);
    }

    public int getPort() {
        return this.dispatcher.getPort();
    }

    public static class PGConnectionContextFactory
    extends MutableIOContextFactory<PGConnectionContext> {
        public PGConnectionContextFactory(CairoEngine engine, PGWireConfiguration configuration, ObjectFactory<SqlExecutionContextImpl> executionContextObjectFactory) {
            super(() -> new PGConnectionContext(engine, configuration, (SqlExecutionContextImpl)executionContextObjectFactory.newInstance()), configuration.getConnectionPoolInitialCapacity());
        }
    }
}

