/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;

public class LineUdpParserSupport {
    private static final Log LOG = LogFactory.getLog(LineUdpParserSupport.class);

    public static void putValue(TableWriter.Row row, int columnType, int columnTypeMeta, int columnIndex, CharSequence value) throws BadCastException {
        if (value.length() > 0) {
            try {
                switch (ColumnType.tagOf(columnType)) {
                    case 6: {
                        row.putLong(columnIndex, Numbers.parseLong(value, 0, value.length() - 1));
                        break;
                    }
                    case 1: {
                        row.putBool(columnIndex, LineUdpParserSupport.isTrue(value));
                        break;
                    }
                    case 11: {
                        row.putStr(columnIndex, value, 1, value.length() - 2);
                        break;
                    }
                    case 12: {
                        row.putSym(columnIndex, value);
                        break;
                    }
                    case 10: {
                        row.putDouble(columnIndex, Numbers.parseDouble(value));
                        break;
                    }
                    case 9: {
                        row.putFloat(columnIndex, Numbers.parseFloat(value));
                        break;
                    }
                    case 5: {
                        row.putInt(columnIndex, Numbers.parseInt(value, 0, value.length() - 1));
                        break;
                    }
                    case 3: {
                        row.putShort(columnIndex, Numbers.parseShort(value, 0, value.length() - 1));
                        break;
                    }
                    case 2: {
                        long v = Numbers.parseLong(value, 0, value.length() - 1);
                        if (v < -128L || v > 127L) {
                            throw CairoException.nonCritical().put("line protocol integer is out of byte bounds [columnIndex=").put(columnIndex).put(", v=").put(v).put(']');
                        }
                        row.putByte(columnIndex, (byte)v);
                        break;
                    }
                    case 7: {
                        row.putDate(columnIndex, Numbers.parseLong(value, 0, value.length() - 1));
                        break;
                    }
                    case 13: {
                        int limit = value.length() - 1;
                        if (value.charAt(limit) != 'i') {
                            ++limit;
                        }
                        row.putLong256(columnIndex, value, 2, limit);
                        break;
                    }
                    case 8: {
                        row.putTimestamp(columnIndex, Numbers.parseLong(value, 0, value.length() - 1));
                        break;
                    }
                    case 4: {
                        row.putChar(columnIndex, value.length() == 2 ? (char)'\u0000' : value.charAt(1));
                        break;
                    }
                    case 14: {
                        row.putByte(columnIndex, (byte)GeoHashes.fromStringTruncatingNl(value, 1, value.length() - 1, columnTypeMeta));
                        break;
                    }
                    case 15: {
                        row.putShort(columnIndex, (short)GeoHashes.fromStringTruncatingNl(value, 1, value.length() - 1, columnTypeMeta));
                        break;
                    }
                    case 16: {
                        row.putInt(columnIndex, (int)GeoHashes.fromStringTruncatingNl(value, 1, value.length() - 1, columnTypeMeta));
                        break;
                    }
                    case 17: {
                        row.putLong(columnIndex, GeoHashes.fromStringTruncatingNl(value, 1, value.length() - 1, columnTypeMeta));
                        break;
                    }
                }
            }
            catch (ImplicitCastException | NumericException e) {
                LOG.info().$("cast error [value=").$(value).$(", toType=").$(ColumnType.nameOf(columnType)).$(']').$();
            }
        } else {
            LineUdpParserSupport.putNullValue(row, columnIndex, columnType);
        }
    }

    public static int getValueType(CharSequence value) {
        return LineUdpParserSupport.getValueType(value, (short)10, (short)6);
    }

    public static int getValueType(CharSequence value, short defaultFloatColumnType, short defaultIntegerColumnType) {
        int valueLen = value.length();
        if (valueLen > 0) {
            char first = value.charAt(0);
            char last = value.charAt(valueLen - 1);
            switch (last) {
                case 'i': {
                    if (valueLen > 3 && value.charAt(0) == '0' && value.charAt(1) == 'x') {
                        return 13;
                    }
                    return valueLen == 1 ? 12 : (int)defaultIntegerColumnType;
                }
                case 't': {
                    if (valueLen > 1 && (first >= '0' && first <= '9' || first == '-')) {
                        return 8;
                    }
                }
                case 'E': 
                case 'F': 
                case 'T': 
                case 'e': 
                case 'f': {
                    if (valueLen == 1) {
                        return last != 'e' ? 1 : 12;
                    }
                    return SqlKeywords.isTrueKeyword(value) || SqlKeywords.isFalseKeyword(value) ? 1 : 12;
                }
                case '\"': {
                    if (valueLen < 2 || value.charAt(0) != '\"') {
                        LOG.error().$("incorrectly quoted string: ").$(value).$();
                        return 0;
                    }
                    return 11;
                }
            }
            if (last >= '0' && last <= '9' && (first >= '0' && first <= '9' || first == '-' || first == '.')) {
                return defaultFloatColumnType;
            }
            if (SqlKeywords.isNanKeyword(value)) {
                return defaultFloatColumnType;
            }
            if (value.charAt(0) == '\"') {
                return 0;
            }
            return 12;
        }
        return 28;
    }

    private static boolean isTrue(CharSequence value) {
        return (value.charAt(0) | 0x20) == 116;
    }

    private static void putNullValue(TableWriter.Row row, int columnIndex, int columnType) {
        switch (ColumnType.tagOf(columnType)) {
            case 1: {
                row.putBool(columnIndex, false);
                break;
            }
            case 11: {
                row.putStr(columnIndex, null);
                break;
            }
            case 12: {
                row.putSym(columnIndex, null);
                break;
            }
            case 10: {
                row.putDouble(columnIndex, Double.NaN);
                break;
            }
            case 9: {
                row.putFloat(columnIndex, Float.NaN);
                break;
            }
            case 6: {
                row.putLong(columnIndex, Long.MIN_VALUE);
                break;
            }
            case 5: {
                row.putInt(columnIndex, Integer.MIN_VALUE);
                break;
            }
            case 3: {
                row.putShort(columnIndex, (short)0);
                break;
            }
            case 2: {
                row.putByte(columnIndex, (byte)0);
                break;
            }
            case 4: {
                row.putChar(columnIndex, '\u0000');
                break;
            }
            case 7: {
                row.putDate(columnIndex, Long.MIN_VALUE);
                break;
            }
            case 8: {
                row.putTimestamp(columnIndex, Long.MIN_VALUE);
                break;
            }
            case 13: {
                row.putLong256(columnIndex, "");
                break;
            }
            case 14: {
                row.putByte(columnIndex, (byte)-1);
                break;
            }
            case 15: {
                row.putShort(columnIndex, (short)-1);
                break;
            }
            case 16: {
                row.putInt(columnIndex, -1);
                break;
            }
            case 17: {
                row.putLong(columnIndex, -1L);
                break;
            }
        }
    }

    public static class BadCastException
    extends Exception {
        public static final BadCastException INSTANCE = new BadCastException();
    }
}

