/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.SymbolLookup;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.std.Chars;
import io.questdb.std.ObjIntHashMap;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.io.Closeable;

class SymbolCache
implements Closeable,
SymbolLookup {
    private final ObjIntHashMap<CharSequence> symbolValueToKeyMap = new ObjIntHashMap(256, 0.5, -2);
    private TxReader txReader;
    private final SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl();
    private final MicrosecondClock clock;
    private final long waitUsBeforeReload;
    private long lastSymbolReaderReloadTimestamp;
    private int symbolIndexInTxFile;

    SymbolCache(LineTcpReceiverConfiguration configuration) {
        this.clock = configuration.getMicrosecondClock();
        this.waitUsBeforeReload = configuration.getSymbolCacheWaitUsBeforeReload();
    }

    @Override
    public void close() {
        this.txReader = null;
        this.symbolMapReader.close();
        this.symbolValueToKeyMap.reset();
    }

    @Override
    public int keyOf(CharSequence value) {
        int symbolKey;
        int symbolValueCount;
        int index = this.symbolValueToKeyMap.keyIndex(value);
        if (index < 0) {
            return this.symbolValueToKeyMap.valueAt(index);
        }
        long ticks = this.clock.getTicks();
        if (ticks - this.lastSymbolReaderReloadTimestamp > this.waitUsBeforeReload && (symbolValueCount = this.safeReadUncommittedSymbolCount(this.symbolIndexInTxFile, true)) > this.symbolMapReader.getSymbolCount()) {
            this.symbolMapReader.updateSymbolCount(symbolValueCount);
            this.lastSymbolReaderReloadTimestamp = ticks;
        }
        if (-2 != (symbolKey = this.symbolMapReader.keyOf(value))) {
            this.symbolValueToKeyMap.putAt(index, Chars.toString(value), symbolKey);
        }
        return symbolKey;
    }

    int getCacheValueCount() {
        return this.symbolValueToKeyMap.size();
    }

    int getCacheCapacity() {
        return this.symbolValueToKeyMap.capacity();
    }

    void of(CairoConfiguration configuration, Path path, CharSequence columnName, int symbolIndexInTxFile, TxReader txReader, long columnNameTxn) {
        this.symbolIndexInTxFile = symbolIndexInTxFile;
        int plen = path.length();
        this.txReader = txReader;
        int symCount = this.safeReadUncommittedSymbolCount(symbolIndexInTxFile, false);
        path.trimTo(plen);
        this.symbolMapReader.of(configuration, path, columnName, columnNameTxn, symCount);
        this.symbolValueToKeyMap.clear();
    }

    private int safeReadUncommittedSymbolCount(int symbolIndexInTxFile, boolean initialStateOk) {
        boolean offsetReloadOk = initialStateOk;
        while (true) {
            if (offsetReloadOk) {
                int count = this.txReader.unsafeReadSymbolTransientCount(symbolIndexInTxFile);
                Unsafe.getUnsafe().loadFence();
                if (this.txReader.unsafeReadVersion() == this.txReader.getVersion()) {
                    return count;
                }
            }
            offsetReloadOk = this.txReader.unsafeLoadBaseOffset();
        }
    }
}

