/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkFacade;

public final class PlainTcpLineChannel
implements LineChannel {
    private static final Log LOG = LogFactory.getLog(PlainTcpLineChannel.class);
    private final NetworkFacade nf;
    private final long fd;
    private final long sockaddr;

    public PlainTcpLineChannel(NetworkFacade nf, int address, int port, int sndBufferSize) {
        this.nf = nf;
        this.fd = nf.socketTcp(true);
        if (this.fd < 0L) {
            throw new LineSenderException("could not allocate a file descriptor").errno(nf.errno());
        }
        this.sockaddr = nf.sockaddr(address, port);
        if (nf.connect(this.fd, this.sockaddr) != 0) {
            int errno = nf.errno();
            nf.close(this.fd, LOG);
            nf.freeSockAddr(this.sockaddr);
            throw new LineSenderException("could not connect to host ").put("[ip=").appendIPv4(address).put("]").errno(errno);
        }
        this.configureBuffers(nf, sndBufferSize);
    }

    public PlainTcpLineChannel(NetworkFacade nf, CharSequence host, int port, int sndBufferSize) {
        this.nf = nf;
        this.sockaddr = -1L;
        this.fd = nf.socketTcp(true);
        if (this.fd < 0L) {
            throw new LineSenderException("could not allocate a file descriptor").errno(nf.errno());
        }
        long addrInfo = nf.getAddrInfo(host, port);
        if (addrInfo == -1L) {
            nf.close(this.fd, LOG);
            throw new LineSenderException("could not resolve host ").put("[host=").put(host).put("]");
        }
        if (nf.connectAddrInfo(this.fd, addrInfo) != 0) {
            int errno = nf.errno();
            nf.close(this.fd, LOG);
            nf.freeAddrInfo(addrInfo);
            throw new LineSenderException("could not connect to host ").put("[host=").put(host).put("]").errno(errno);
        }
        nf.freeAddrInfo(addrInfo);
        this.configureBuffers(nf, sndBufferSize);
    }

    private void configureBuffers(NetworkFacade nf, int sndBufferSize) {
        int orgSndBufSz = nf.getSndBuf(this.fd);
        nf.setSndBuf(this.fd, sndBufferSize);
        int newSndBufSz = nf.getSndBuf(this.fd);
        LOG.info().$("Send buffer size change from ").$(orgSndBufSz).$(" to ").$(newSndBufSz).$();
    }

    @Override
    public void close() {
        this.nf.close(this.fd, LOG);
        if (this.sockaddr != -1L) {
            this.nf.freeSockAddr(this.sockaddr);
        }
    }

    @Override
    public void send(long ptr, int len) {
        if (this.nf.send(this.fd, ptr, len) != len) {
            throw new LineSenderException("send error").errno(this.nf.errno());
        }
    }

    @Override
    public int receive(long ptr, int len) {
        return this.nf.recv(this.fd, ptr, len);
    }

    @Override
    public int errno() {
        return this.nf.errno();
    }
}

