/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.line.tcp.AuthDb;
import io.questdb.cutlass.line.tcp.LineTcpAuthConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.MutableIOContextFactory;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class LineTcpReceiver
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpReceiver.class);
    private final IODispatcher<LineTcpConnectionContext> dispatcher;
    private final MutableIOContextFactory<LineTcpConnectionContext> contextFactory;
    private LineTcpMeasurementScheduler scheduler = null;
    private final ObjList<WorkerPool> dedicatedPools;
    private final Metrics metrics;

    public LineTcpReceiver(LineTcpReceiverConfiguration configuration, CairoEngine engine, WorkerPool ioWorkerPool, WorkerPool writerWorkerPool, ObjList<WorkerPool> dedicatedPools) {
        ObjectFactory<LineTcpConnectionContext> factory;
        this.metrics = engine.getMetrics();
        if (null == configuration.getAuthDbPath()) {
            LOG.info().$("using default context").$();
            factory = () -> new LineTcpConnectionContext(configuration, this.scheduler, this.metrics);
        } else {
            LOG.info().$("using authenticating context").$();
            AuthDb authDb = new AuthDb(configuration);
            factory = () -> new LineTcpAuthConnectionContext(configuration, authDb, this.scheduler, this.metrics);
        }
        this.contextFactory = new MutableIOContextFactory<LineTcpConnectionContext>(factory, configuration.getConnectionPoolInitialCapacity());
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), this.contextFactory);
        this.dedicatedPools = dedicatedPools;
        ioWorkerPool.assign(this.dispatcher);
        this.scheduler = new LineTcpMeasurementScheduler(configuration, engine, ioWorkerPool, this.dispatcher, writerWorkerPool);
        int n = ioWorkerPool.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            ioWorkerPool.assign(i, this.contextFactory);
        }
    }

    @Nullable
    public static LineTcpReceiver create(LineTcpReceiverConfiguration lineConfiguration, WorkerPool sharedWorkerPool, Log log, CairoEngine cairoEngine, Metrics metrics) {
        if (!lineConfiguration.isEnabled()) {
            return null;
        }
        ObjList<WorkerPool> dedicatedPools = new ObjList<WorkerPool>(2);
        WorkerPool ioWorkerPool = WorkerPoolAwareConfiguration.configureWorkerPool(lineConfiguration.getIOWorkerPoolConfiguration(), sharedWorkerPool, metrics);
        WorkerPool writerWorkerPool = WorkerPoolAwareConfiguration.configureWorkerPool(lineConfiguration.getWriterWorkerPoolConfiguration(), sharedWorkerPool, metrics);
        if (ioWorkerPool != sharedWorkerPool) {
            ioWorkerPool.assignCleaner(Path.CLEANER);
            dedicatedPools.add(ioWorkerPool);
        }
        if (writerWorkerPool != sharedWorkerPool) {
            writerWorkerPool.assignCleaner(Path.CLEANER);
            dedicatedPools.add(writerWorkerPool);
        }
        LineTcpReceiver lineTcpReceiver = new LineTcpReceiver(lineConfiguration, cairoEngine, ioWorkerPool, writerWorkerPool, dedicatedPools);
        if (ioWorkerPool != sharedWorkerPool) {
            ioWorkerPool.start(log);
        }
        if (writerWorkerPool != sharedWorkerPool) {
            writerWorkerPool.start(log);
        }
        return lineTcpReceiver;
    }

    @Override
    public void close() {
        int sz = this.dedicatedPools.size();
        for (int n = 0; n < sz; ++n) {
            this.dedicatedPools.get(n).halt();
        }
        Misc.free(this.scheduler);
        Misc.free(this.contextFactory);
        Misc.free(this.dispatcher);
    }

    void setSchedulerListener(SchedulerListener listener) {
        this.scheduler.setListener(listener);
    }

    @FunctionalInterface
    public static interface SchedulerListener {
        public void onEvent(CharSequence var1, int var2);
    }
}

