/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cairo.CairoException;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.AbstractMutableIOContext;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectByteCharSequence;

class LineTcpConnectionContext
extends AbstractMutableIOContext<LineTcpConnectionContext> {
    private static final Log LOG = LogFactory.getLog(LineTcpConnectionContext.class);
    private static final long QUEUE_FULL_LOG_HYSTERESIS_IN_MS = 10000L;
    protected final NetworkFacade nf;
    private final LineTcpMeasurementScheduler scheduler;
    private final Metrics metrics;
    private final MillisecondClock milliClock;
    private final DirectByteCharSequence byteCharSequence = new DirectByteCharSequence();
    private final LineTcpParser parser;
    private final boolean disconnectOnError;
    protected long recvBufStart;
    protected long recvBufEnd;
    protected long recvBufPos;
    protected boolean peerDisconnected;
    protected long recvBufStartOfMeasurement;
    private long lastQueueFullLogMillis = 0L;
    private boolean goodMeasurement;

    LineTcpConnectionContext(LineTcpReceiverConfiguration configuration, LineTcpMeasurementScheduler scheduler, Metrics metrics) {
        this.nf = configuration.getNetworkFacade();
        this.disconnectOnError = configuration.getDisconnectOnError();
        this.scheduler = scheduler;
        this.metrics = metrics;
        this.milliClock = configuration.getMillisecondClock();
        this.parser = new LineTcpParser(configuration.isStringAsTagSupported(), configuration.isSymbolAsFieldSupported());
        this.recvBufStart = Unsafe.malloc(configuration.getNetMsgBufferSize(), 1);
        this.recvBufEnd = this.recvBufStart + (long)configuration.getNetMsgBufferSize();
        this.clear();
    }

    @Override
    public void clear() {
        this.recvBufPos = this.recvBufStart;
        this.peerDisconnected = false;
        this.resetParser();
    }

    @Override
    public void close() {
        this.fd = -1L;
        this.recvBufEnd = this.recvBufPos = Unsafe.free(this.recvBufStart, this.recvBufEnd - this.recvBufStart, 1);
        this.recvBufStart = this.recvBufPos;
    }

    private boolean checkQueueFullLogHysteresis() {
        long millis = this.milliClock.getTicks();
        if (millis - this.lastQueueFullLogMillis >= 10000L) {
            this.lastQueueFullLogMillis = millis;
            return true;
        }
        return false;
    }

    protected final boolean compactBuffer(long recvBufStartOfMeasurement) {
        assert (recvBufStartOfMeasurement <= this.recvBufPos);
        if (recvBufStartOfMeasurement > this.recvBufStart) {
            long len = this.recvBufPos - recvBufStartOfMeasurement;
            if (len > 0L) {
                Vect.memmove(this.recvBufStart, recvBufStartOfMeasurement, len);
                long shl = recvBufStartOfMeasurement - this.recvBufStart;
                this.parser.shl(shl);
                this.recvBufStartOfMeasurement -= shl;
            } else {
                assert (len == 0L);
                this.resetParser();
            }
            this.recvBufPos = this.recvBufStart + len;
            return true;
        }
        return false;
    }

    private void doHandleDisconnectEvent() {
        if (this.parser.getBufferAddress() == this.recvBufEnd) {
            LOG.error().$('[').$(this.fd).$("] buffer overflow [line.tcp.msg.buffer.size=").$(this.recvBufEnd - this.recvBufStart).$(']').$();
            return;
        }
        if (this.peerDisconnected) {
            if (this.recvBufPos != this.recvBufStart) {
                LOG.info().$('[').$(this.fd).$("] peer disconnected with partial measurement, ").$(this.recvBufPos - this.recvBufStart).$(" unprocessed bytes").$();
            } else {
                LOG.info().$('[').$(this.fd).$("] peer disconnected").$();
            }
        }
    }

    IOContextResult handleIO(NetworkIOJob netIoJob) {
        this.read();
        return this.parseMeasurements(netIoJob);
    }

    protected final IOContextResult parseMeasurements(NetworkIOJob netIoJob) {
        while (true) {
            try {
                while (true) {
                    LineTcpParser.ParseResult rc = this.goodMeasurement ? this.parser.parseMeasurement(this.recvBufPos) : this.parser.skipMeasurement(this.recvBufPos);
                    switch (rc) {
                        case MEASUREMENT_COMPLETE: {
                            if (this.goodMeasurement) {
                                if (this.scheduler.scheduleEvent(netIoJob, this.parser)) {
                                    if (this.checkQueueFullLogHysteresis()) {
                                        LOG.debug().$('[').$(this.fd).$("] queue full").$();
                                    }
                                    return IOContextResult.QUEUE_FULL;
                                }
                            } else {
                                this.logParseError();
                                this.goodMeasurement = true;
                            }
                            this.startNewMeasurement();
                            break;
                        }
                        case ERROR: {
                            if (this.disconnectOnError) {
                                this.logParseError();
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            this.goodMeasurement = false;
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (this.recvBufPos == this.recvBufEnd && !this.compactBuffer(this.recvBufStartOfMeasurement)) {
                                this.doHandleDisconnectEvent();
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            if (this.read()) break;
                            if (this.peerDisconnected) {
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            return IOContextResult.NEEDS_READ;
                        }
                    }
                }
            }
            catch (CairoException ex) {
                LOG.error().$('[').$(this.fd).$("] could not process line data [table=").$(this.parser.getMeasurementName()).$(", msg=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
                if (this.disconnectOnError) {
                    this.logParseError();
                    return IOContextResult.NEEDS_DISCONNECT;
                }
                this.goodMeasurement = false;
                continue;
            }
            catch (Throwable ex) {
                LOG.critical().$('[').$(this.fd).$("] could not process line data [table=").$(this.parser.getMeasurementName()).$(", ex=").$(ex).I$();
                this.metrics.healthCheck().incrementUnhandledErrors();
                return IOContextResult.NEEDS_DISCONNECT;
            }
            break;
        }
    }

    private void logParseError() {
        int position = (int)(this.parser.getBufferAddress() - this.recvBufStartOfMeasurement);
        assert (position >= 0);
        LOG.error().$('[').$(this.fd).$("] could not parse measurement, ").$((Object)this.parser.getErrorCode()).$(" at ").$(position).$(", line (may be mangled due to partial parsing): '").$(this.byteCharSequence.of(this.recvBufStartOfMeasurement, this.parser.getBufferAddress())).$("'").$();
    }

    private void startNewMeasurement() {
        this.parser.startNextMeasurement();
        this.recvBufStartOfMeasurement = this.parser.getBufferAddress();
        if (this.recvBufStartOfMeasurement == this.recvBufPos) {
            this.recvBufPos = this.recvBufStart;
            this.parser.of(this.recvBufStart);
            this.recvBufStartOfMeasurement = this.recvBufStart;
        }
    }

    protected boolean read() {
        int bufferRemaining;
        int orig = bufferRemaining = (int)(this.recvBufEnd - this.recvBufPos);
        if (bufferRemaining > 0 && !this.peerDisconnected) {
            int bytesRead = this.nf.recv(this.fd, this.recvBufPos, bufferRemaining);
            if (bytesRead > 0) {
                this.recvBufPos += (long)bytesRead;
                bufferRemaining -= bytesRead;
            } else {
                this.peerDisconnected = bytesRead < 0;
            }
            return bufferRemaining < orig;
        }
        return !this.peerDisconnected;
    }

    protected void resetParser() {
        this.parser.of(this.recvBufStart);
        this.goodMeasurement = true;
        this.recvBufStartOfMeasurement = this.recvBufStart;
    }

    static enum IOContextResult {
        NEEDS_READ,
        NEEDS_WRITE,
        QUEUE_FULL,
        NEEDS_DISCONNECT;

    }
}

