/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cairo.CairoException;
import io.questdb.cutlass.line.tcp.AuthDb;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectByteCharSequence;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;

class LineTcpAuthConnectionContext
extends LineTcpConnectionContext {
    private static final Log LOG = LogFactory.getLog(LineTcpAuthConnectionContext.class);
    private static final int CHALLENGE_LEN = 512;
    private static final int MIN_BUF_SIZE = 513;
    private static final ThreadLocal<SecureRandom> tlSrand = new ThreadLocal<SecureRandom>(SecureRandom::new);
    private final AuthDb authDb;
    private static final ThreadLocal<Signature> tlSigDER = new ThreadLocal<Signature>(() -> {
        try {
            return Signature.getInstance("SHA256withECDSA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
    });
    private static final ThreadLocal<Signature> tlSigP1363 = new ThreadLocal<Signature>(() -> {
        try {
            return Signature.getInstance("SHA256withECDSAinP1363Format");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
    });
    private final DirectByteCharSequence charSeq = new DirectByteCharSequence();
    private final byte[] challengeBytes = new byte[512];
    private PublicKey pubKey;
    private boolean authenticated;
    private AuthState authState;

    LineTcpAuthConnectionContext(LineTcpReceiverConfiguration configuration, AuthDb authDb, LineTcpMeasurementScheduler scheduler, Metrics metrics) {
        super(configuration, scheduler, metrics);
        if (configuration.getNetMsgBufferSize() < 513) {
            throw CairoException.critical(0).put("Minimum buffer length is ").put(513L);
        }
        this.authDb = authDb;
    }

    @Override
    LineTcpConnectionContext.IOContextResult handleIO(NetworkIOJob netIoJob) {
        if (this.authenticated) {
            return super.handleIO(netIoJob);
        }
        return this.handleAuth(netIoJob);
    }

    private LineTcpConnectionContext.IOContextResult handleAuth(NetworkIOJob netIoJob) {
        switch (this.authState) {
            case WAITING_FOR_KEY_ID: {
                this.readKeyId();
                break;
            }
            case SENDING_CHALLENGE: {
                this.sendChallenge();
                break;
            }
            case WAITING_FOR_RESPONSE: {
                this.waitForResponse();
                if (!this.authenticated || this.recvBufPos <= this.recvBufStart) break;
                return this.parseMeasurements(netIoJob);
            }
        }
        return this.authState.ioContextResult;
    }

    private void readKeyId() {
        int lineEnd = this.findLineEnd();
        if (lineEnd != -1) {
            int n;
            this.charSeq.of(this.recvBufStart, this.recvBufStart + (long)lineEnd);
            LOG.info().$('[').$(this.fd).$("] authentication read key id [keyId=").$(this.charSeq).$(']').$();
            this.pubKey = this.authDb.getPublicKey(this.charSeq);
            this.recvBufPos = this.recvBufStart;
            SecureRandom srand = tlSrand.get();
            for (n = 0; n < 512; ++n) {
                assert (this.recvBufStart + (long)n < this.recvBufEnd);
                int r = (int)(srand.nextDouble() * 95.0) + 32;
                Unsafe.getUnsafe().putByte(this.recvBufStart + (long)n, (byte)r);
                this.challengeBytes[n] = (byte)r;
            }
            Unsafe.getUnsafe().putByte(this.recvBufStart + (long)n, (byte)10);
            this.authState = AuthState.SENDING_CHALLENGE;
        }
    }

    private void sendChallenge() {
        int nWritten;
        int n = 513 - (int)(this.recvBufPos - this.recvBufStart);
        assert (n > 0);
        while ((nWritten = this.nf.send(this.fd, this.recvBufPos, n)) > 0) {
            if (n == nWritten) {
                this.recvBufPos = this.recvBufStart;
                this.authState = AuthState.WAITING_FOR_RESPONSE;
                return;
            }
            this.recvBufPos += (long)nWritten;
        }
        if (nWritten == 0) {
            return;
        }
        LOG.info().$('[').$(this.fd).$("] authentication peer disconnected when challenge was being sent").$();
        this.authState = AuthState.FAILED;
    }

    private boolean checkAllZeros(byte[] signatureRaw) {
        int n = signatureRaw.length;
        for (int i = 0; i < n; ++i) {
            if (signatureRaw[i] == 0) continue;
            return false;
        }
        return true;
    }

    private void waitForResponse() {
        int lineEnd = this.findLineEnd();
        if (lineEnd != -1) {
            boolean verified;
            if (null == this.pubKey) {
                LOG.info().$('[').$(this.fd).$("] authentication failed, unknown key id").$();
                this.authState = AuthState.FAILED;
                return;
            }
            byte[] signature = new byte[lineEnd];
            for (int n = 0; n < lineEnd; ++n) {
                signature[n] = Unsafe.getUnsafe().getByte(this.recvBufStart + (long)n);
            }
            this.authState = AuthState.FAILED;
            byte[] signatureRaw = Base64.getDecoder().decode(signature);
            Signature sig = signatureRaw.length == 64 ? tlSigP1363.get() : tlSigDER.get();
            try {
                if (this.checkAllZeros(signatureRaw)) {
                    LOG.info().$('[').$(this.fd).$("] invalid signature, can be cyber attack!").$();
                    this.authState = AuthState.FAILED;
                    return;
                }
                sig.initVerify(this.pubKey);
                sig.update(this.challengeBytes);
                verified = sig.verify(signatureRaw);
            }
            catch (InvalidKeyException | SignatureException ex) {
                LOG.info().$('[').$(this.fd).$("] authentication exception ").$(ex).$();
                verified = false;
            }
            if (!verified) {
                LOG.info().$('[').$(this.fd).$("] authentication failed, signature was not verified").$();
                this.authState = AuthState.FAILED;
                return;
            }
            this.authenticated = true;
            this.authState = AuthState.COMPLETE;
            this.compactBuffer(this.recvBufStart + (long)lineEnd + 1L);
            this.resetParser();
            LOG.info().$('[').$(this.fd).$("] authentication success").$();
        }
    }

    private int findLineEnd() {
        this.read();
        int len = (int)(this.recvBufPos - this.recvBufStart);
        int lineEnd = -1;
        for (int n = 0; n < len; ++n) {
            byte b = Unsafe.getUnsafe().getByte(this.recvBufStart + (long)n);
            if (b != 10) continue;
            lineEnd = n;
            break;
        }
        if (lineEnd != -1) {
            return lineEnd;
        }
        if (this.recvBufPos == this.recvBufEnd) {
            LOG.info().$('[').$(this.fd).$("] authentication token is too long").$();
            this.authState = AuthState.FAILED;
            return -1;
        }
        if (this.peerDisconnected) {
            LOG.info().$('[').$(this.fd).$("] authentication disconnected by peer when reading token").$();
            this.authState = AuthState.FAILED;
            return -1;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.authenticated = false;
        this.authState = AuthState.WAITING_FOR_KEY_ID;
        this.pubKey = null;
        super.clear();
    }

    private static enum AuthState {
        WAITING_FOR_KEY_ID(LineTcpConnectionContext.IOContextResult.NEEDS_READ),
        SENDING_CHALLENGE(LineTcpConnectionContext.IOContextResult.NEEDS_WRITE),
        WAITING_FOR_RESPONSE(LineTcpConnectionContext.IOContextResult.NEEDS_READ),
        COMPLETE(LineTcpConnectionContext.IOContextResult.NEEDS_READ),
        FAILED(LineTcpConnectionContext.IOContextResult.NEEDS_DISCONNECT);

        private final LineTcpConnectionContext.IOContextResult ioContextResult;

        private AuthState(LineTcpConnectionContext.IOContextResult ioContextResult) {
            this.ioContextResult = ioContextResult;
        }
    }
}

