/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Rnd;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class TextQueryProcessorState
implements Mutable,
Closeable {
    final StringSink query = new StringSink();
    private final HttpConnectionContext httpConnectionContext;
    boolean countRows = false;
    boolean noMeta = false;
    RecordCursorFactory recordCursorFactory;
    RecordMetadata metadata;
    RecordCursor cursor;
    long count;
    long skip;
    long stop;
    Record record;
    Rnd rnd;
    int queryState = 1;
    int columnIndex;
    private boolean queryCacheable = false;
    String fileName;

    public TextQueryProcessorState(HttpConnectionContext httpConnectionContext) {
        this.httpConnectionContext = httpConnectionContext;
    }

    @Override
    public void clear() {
        this.metadata = null;
        this.cursor = Misc.free(this.cursor);
        this.record = null;
        if (null != this.recordCursorFactory) {
            if (this.queryCacheable) {
                QueryCache.getInstance().push(this.query, this.recordCursorFactory);
            } else {
                this.recordCursorFactory.close();
            }
            this.recordCursorFactory = null;
        }
        this.queryCacheable = false;
        this.query.clear();
        this.queryState = 1;
        this.columnIndex = 0;
        this.countRows = false;
    }

    @Override
    public void close() {
        this.cursor = Misc.free(this.cursor);
        this.recordCursorFactory = Misc.free(this.recordCursorFactory);
    }

    public long getFd() {
        return this.httpConnectionContext.getFd();
    }

    void setQueryCacheable(boolean queryCacheable) {
        this.queryCacheable = queryCacheable;
    }
}

