/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.RescheduleContext;
import io.questdb.cutlass.http.Retry;
import io.questdb.cutlass.http.RetryAttemptAttributes;
import io.questdb.cutlass.http.RetryHolder;
import io.questdb.cutlass.http.WaitProcessorConfiguration;
import io.questdb.cutlass.http.ex.RetryFailedOperationException;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SPSequence;
import io.questdb.mp.Sequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.io.Closeable;
import java.util.PriorityQueue;
import org.jetbrains.annotations.Nullable;

public class WaitProcessor
extends SynchronizedJob
implements RescheduleContext,
Closeable {
    private final RingQueue<RetryHolder> inQueue;
    private final Sequence inPubSequence;
    private final Sequence inSubSequence;
    private final PriorityQueue<Retry> nextRerun;
    private final RingQueue<RetryHolder> outQueue;
    private final Sequence outPubSequence;
    private final Sequence outSubSequence;
    private final MillisecondClock clock;
    private final long maxWaitCapMs;
    private final double exponentialWaitMultiplier;

    public WaitProcessor(WaitProcessorConfiguration configuration) {
        this.clock = configuration.getClock();
        this.maxWaitCapMs = configuration.getMaxWaitCapMs();
        this.exponentialWaitMultiplier = configuration.getExponentialWaitMultiplier();
        this.nextRerun = new PriorityQueue(configuration.getInitialWaitQueueSize(), WaitProcessor::compareRetriesInQueue);
        int retryQueueLength = configuration.getMaxProcessingQueueSize();
        this.inQueue = new RingQueue<RetryHolder>(RetryHolder::new, retryQueueLength);
        this.inPubSequence = new MPSequence(retryQueueLength);
        this.inSubSequence = new SCSequence();
        this.outQueue = new RingQueue<RetryHolder>(RetryHolder::new, retryQueueLength);
        this.outPubSequence = new SPSequence(retryQueueLength);
        this.outSubSequence = new MCSequence(retryQueueLength);
        this.inPubSequence.then(this.inSubSequence).then(this.inPubSequence);
        this.outPubSequence.then(this.outSubSequence).then(this.outPubSequence);
    }

    @Override
    public void close() {
        this.processInQueue();
        int n = this.nextRerun.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.nextRerun.poll());
        }
    }

    @Override
    public void reschedule(Retry retry) {
        this.reschedule(retry, 0, 0L);
    }

    public boolean runReruns(HttpRequestProcessorSelector selector) {
        Retry retry;
        boolean useful = false;
        while ((retry = this.getNextRerun()) != null) {
            useful = true;
            if (retry.tryRerun(selector, this)) continue;
            try {
                this.reschedule(retry, retry.getAttemptDetails().attempt + 1, retry.getAttemptDetails().waitStartTimestamp);
            }
            catch (RetryFailedOperationException e) {
                retry.fail(selector, e);
            }
        }
        return useful;
    }

    private long calculateNextTimestamp(RetryAttemptAttributes attemptAttributes) {
        if (attemptAttributes.attempt == 0) {
            return attemptAttributes.lastRunTimestamp + 2L;
        }
        long totalWait = attemptAttributes.lastRunTimestamp - attemptAttributes.waitStartTimestamp;
        return Math.min(this.maxWaitCapMs, Math.max(4L, (long)((double)totalWait * this.exponentialWaitMultiplier))) + attemptAttributes.lastRunTimestamp;
    }

    @Nullable
    private Retry getNextRerun() {
        long cursor = this.outSubSequence.next();
        if (cursor < 0L) {
            return null;
        }
        RetryHolder retryHolder = this.outQueue.get(cursor);
        Retry r = retryHolder.retry;
        retryHolder.retry = null;
        this.outSubSequence.done(cursor);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processInQueue() {
        boolean any = false;
        while (true) {
            Retry retry;
            long cursor;
            if ((cursor = this.inSubSequence.next()) < -1L) {
                Os.pause();
                continue;
            }
            if (cursor < 0L) {
                return any;
            }
            try {
                RetryHolder toRun = this.inQueue.get(cursor);
                retry = toRun.retry;
                toRun.retry = null;
            }
            finally {
                this.inSubSequence.done(cursor);
            }
            retry.getAttemptDetails().nextRunTimestamp = this.calculateNextTimestamp(retry.getAttemptDetails());
            this.nextRerun.add(retry);
            any = true;
        }
    }

    private void reschedule(Retry retry, int attempt, long waitStartMs) {
        long cursor;
        long now = this.clock.getTicks();
        retry.getAttemptDetails().attempt = attempt;
        retry.getAttemptDetails().lastRunTimestamp = now;
        long l = retry.getAttemptDetails().waitStartTimestamp = attempt == 0 ? now : waitStartMs;
        while ((cursor = this.inPubSequence.next()) < -1L) {
            Os.pause();
        }
        if (cursor < 0L) {
            throw RetryFailedOperationException.INSTANCE;
        }
        RetryHolder retryHolder = this.inQueue.get(cursor);
        retryHolder.retry = retry;
        this.inPubSequence.done(cursor);
    }

    @Override
    protected boolean runSerially() {
        return this.processInQueue() || this.sendToOutQueue();
    }

    private boolean sendToOutQueue() {
        boolean useful = false;
        long now = this.clock.getTicks();
        while (this.nextRerun.size() > 0) {
            Retry next = this.nextRerun.peek();
            if (next.getAttemptDetails().nextRunTimestamp <= now) {
                useful = true;
                Retry retry = this.nextRerun.poll();
                if (this.sendToOutQueue(retry)) continue;
                this.nextRerun.add(retry);
                return true;
            }
            return useful;
        }
        return useful;
    }

    private boolean sendToOutQueue(Retry retry) {
        long cursor;
        while ((cursor = this.outPubSequence.next()) < -1L) {
            Os.pause();
        }
        if (cursor < 0L) {
            return false;
        }
        RetryHolder retryHolderOut = this.outQueue.get(cursor);
        retryHolderOut.retry = retry;
        this.outPubSequence.done(cursor);
        return true;
    }

    private static int compareRetriesInQueue(Retry r1, Retry r2) {
        RetryAttemptAttributes a1 = r1.getAttemptDetails();
        RetryAttemptAttributes a2 = r2.getAttemptDetails();
        return Long.compare(a1.nextRunTimestamp, a2.nextRunTimestamp);
    }
}

