/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm.api;

import io.questdb.cairo.TableUtils;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;

public interface MemoryM
extends Closeable {
    public long addressOf(long var1);

    default public void allocate(long size) {
        TableUtils.allocateDiskSpace(this.getFilesFacade(), this.getFd(), size);
    }

    @Override
    public void close();

    public long getFd();

    public FilesFacade getFilesFacade();

    default public boolean isDeleted() {
        return !this.getFilesFacade().exists(this.getFd());
    }

    public boolean isMapped(long var1, long var3);

    default public boolean isOpen() {
        return this.getFd() != -1L;
    }

    default public long map(long offset, long size) {
        if (this.isMapped(offset, size)) {
            return this.addressOf(offset);
        }
        return 0L;
    }

    public void of(FilesFacade var1, LPSZ var2, long var3, long var5, int var7, long var8);

    default public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag) {
        this.of(ff, name, extendSegmentSize, size, memoryTag, 0L);
    }

    default public void smallFile(FilesFacade ff, LPSZ name, int memoryTag) {
        this.of(ff, name, ff.getPageSize(), ff.length(name), memoryTag, 0L);
    }

    default public void wholeFile(FilesFacade ff, LPSZ name, int memoryTag) {
        this.of(ff, name, ff.getMapPageSize(), ff.length(name), memoryTag, 0L);
    }
}

