/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm.api;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.vm.api.MemoryC;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.BinarySequence;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.CharSink;

public interface MemoryCR
extends MemoryC,
MemoryR {
    default public BinarySequence getBin(long offset, ByteSequenceView view) {
        long addr = this.addressOf(offset);
        long len = Unsafe.getUnsafe().getLong(addr);
        if (len > -1L) {
            return view.of(addr + 8L, len);
        }
        return null;
    }

    @Override
    default public long getBinLen(long offset) {
        return this.getLong(offset);
    }

    @Override
    default public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    @Override
    default public byte getByte(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 1L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getByte(this.addressOf(offset));
    }

    @Override
    default public double getDouble(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 8L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getDouble(this.addressOf(offset));
    }

    @Override
    default public float getFloat(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 4L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getFloat(this.addressOf(offset));
    }

    @Override
    default public int getInt(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 4L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getInt(this.addressOf(offset));
    }

    @Override
    default public long getLong(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 8L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getLong(this.addressOf(offset));
    }

    @Override
    default public long getPageSize() {
        return this.size();
    }

    @Override
    default public short getShort(long offset) {
        return Unsafe.getUnsafe().getShort(this.addressOf(offset));
    }

    @Override
    default public void getLong256(long offset, CharSink sink) {
        long addr = this.addressOf(offset + 32L);
        long a = Unsafe.getUnsafe().getLong(addr - 32L);
        long b = Unsafe.getUnsafe().getLong(addr - 24L);
        long c = Unsafe.getUnsafe().getLong(addr - 16L);
        long d = Unsafe.getUnsafe().getLong(addr - 8L);
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    default public char getChar(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 2L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getChar(this.addressOf(offset));
    }

    @Override
    default public int getStrLen(long offset) {
        return this.getInt(offset);
    }

    default public CharSequence getStr(long offset, CharSequenceView view) {
        long addr = this.addressOf(offset);
        int len = Unsafe.getUnsafe().getInt(addr);
        if (len != -1) {
            if ((long)(len + 4) + offset <= this.size()) {
                return view.of(addr + 4L, len);
            }
            throw CairoException.critical(0).put("String is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(", size=").put(this.size()).put(']');
        }
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class CharSequenceView
    extends AbstractCharSequence {
        private int len;
        private long address;

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(this.address + (long)index * 2L);
        }

        public CharSequenceView of(long address, int len) {
            this.address = address;
            this.len = len;
            return this;
        }
    }

    public static class ByteSequenceView
    implements BinarySequence {
        private long address;
        private long len = -1L;

        @Override
        public byte byteAt(long index) {
            return Unsafe.getUnsafe().getByte(this.address + index);
        }

        @Override
        public void copyTo(long address, long start, long length) {
            long bytesRemaining = Math.min(length, this.len - start);
            long addr = this.address + start;
            Vect.memcpy(address, addr, bytesRemaining);
        }

        @Override
        public long length() {
            return this.len;
        }

        public ByteSequenceView of(long address, long len) {
            this.address = address;
            this.len = len;
            return this;
        }
    }
}

