/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemoryPARWImpl;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class MemoryPMARImpl
extends MemoryPARWImpl
implements MemoryMAR {
    private static final Log LOG = LogFactory.getLog(MemoryPMARImpl.class);
    private FilesFacade ff;
    private long fd = -1L;
    private long pageAddress = 0L;
    private int mappedPage;

    public MemoryPMARImpl(FilesFacade ff, LPSZ name, long pageSize, int memoryTag, long opts) {
        this.of(ff, name, pageSize, memoryTag, opts);
    }

    public MemoryPMARImpl() {
    }

    @Override
    public final void close(boolean truncate) {
        this.close(truncate, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean truncate, byte truncateMode) {
        long sz = this.getAppendOffset();
        this.releaseCurrentPage();
        super.close();
        if (this.fd != -1L) {
            try {
                Vm.bestEffortClose(this.ff, LOG, this.fd, truncate, sz, truncateMode);
            }
            finally {
                this.fd = -1L;
            }
        }
    }

    @Override
    public void sync(boolean async) {
        if (this.pageAddress != 0L) {
            if (this.ff.msync(this.pageAddress, this.getExtendSegmentSize(), async) == 0) {
                return;
            }
            LOG.error().$("could not msync [fd=").$(this.fd).$(", errno=").$(this.ff.errno()).$(']').$();
        }
    }

    @Override
    public final void of(FilesFacade ff, LPSZ name, long extendSegmentSize, int memoryTag, long opts) {
        this.close();
        this.memoryTag = memoryTag;
        this.ff = ff;
        this.mappedPage = -1;
        this.setExtendSegmentSize(extendSegmentSize);
        this.fd = TableUtils.openFileRWOrFail(ff, name, opts);
        LOG.debug().$("open ").$(name).$(" [fd=").$(this.fd).$(", extendSegmentSize=").$(extendSegmentSize).$(']').$();
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void truncate() {
        if (this.fd == -1L) {
            return;
        }
        this.releaseCurrentPage();
        if (!this.ff.truncate(Math.abs(this.fd), this.getExtendSegmentSize())) {
            throw CairoException.critical(this.ff.errno()).put("Cannot truncate fd=").put(this.fd).put(" to ").put(this.getExtendSegmentSize()).put(" bytes");
        }
        this.pageAddress = this.mapPage(0);
        this.updateLimits(0, this.pageAddress);
        LOG.debug().$("truncated [fd=").$(this.fd).$(']').$();
    }

    @Override
    public long getPageAddress(int page) {
        if (page == this.mappedPage) {
            return this.pageAddress;
        }
        return 0L;
    }

    @Override
    protected long mapWritePage(int page, long offset) {
        this.releaseCurrentPage();
        this.pageAddress = this.mapPage(page);
        return this.pageAddress;
    }

    @Override
    protected void release(long address) {
        this.ff.munmap(address, this.getPageSize(), this.memoryTag);
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public FilesFacade getFilesFacade() {
        return this.ff;
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, long opts) {
        this.of(ff, name, extendSegmentSize, memoryTag, opts);
    }

    @Override
    public void wholeFile(FilesFacade ff, LPSZ name, int memoryTag) {
        this.of(ff, name, ff.getMapPageSize(), memoryTag, 0L);
    }

    public long mapPage(int page) {
        long address = TableUtils.mapRW(this.ff, this.fd, this.getExtendSegmentSize(), this.pageOffset(page), this.memoryTag);
        this.mappedPage = page;
        return address;
    }

    void releaseCurrentPage() {
        if (this.pageAddress != 0L) {
            this.release(this.pageAddress);
            this.pageAddress = 0L;
        }
    }
}

