/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.PageAddressCache;
import io.questdb.cairo.sql.PageAddressCacheRecord;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.async.PageFrameReduceJob;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.WeakClosableObjectPool;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PageFrameSequence<T extends StatefulAtom>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PageFrameSequence.class);
    private static final long LOCAL_TASK_CURSOR = Long.MAX_VALUE;
    private static final AtomicLong ID_SEQ = new AtomicLong();
    public final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final AtomicInteger reduceCounter = new AtomicInteger(0);
    private final LongList frameRowCounts = new LongList();
    private final PageFrameReducer reducer;
    private final PageAddressCache pageAddressCache;
    private final MessageBus messageBus;
    private final MillisecondClock clock;
    private long id;
    private int shard;
    private int dispatchStartFrameIndex;
    private int collectedFrameIndex = -1;
    private int frameCount;
    private Sequence collectSubSeq;
    private RingQueue<PageFrameReduceTask> reduceQueue;
    private SymbolTableSource symbolTableSource;
    private T atom;
    private PageAddressCacheRecord record;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private PageFrameReduceTask localTask;
    private final WeakClosableObjectPool<PageFrameReduceTask> localTaskPool;
    private long startTime;
    private long circuitBreakerFd;
    private SqlExecutionContext sqlExecutionContext;

    public PageFrameSequence(CairoConfiguration configuration, MessageBus messageBus, PageFrameReducer reducer, WeakClosableObjectPool<PageFrameReduceTask> localTaskPool) {
        this.pageAddressCache = new PageAddressCache(configuration);
        this.messageBus = messageBus;
        this.reducer = reducer;
        this.clock = configuration.getMillisecondClock();
        this.localTaskPool = localTaskPool;
    }

    public void await() {
        LOG.debug().$("awaiting completion [shard=").$(this.shard).$(", id=").$(this.id).$(", frameCount=").$(this.frameCount).I$();
        MCSequence pageFrameReduceSubSeq = this.messageBus.getPageFrameReduceSubSeq(this.shard);
        while (this.doneLatch.getCount() == 0) {
            boolean allFramesReduced = this.reduceCounter.get() == this.dispatchStartFrameIndex;
            boolean nothingProcessed = true;
            try {
                nothingProcessed = PageFrameReduceJob.consumeQueue(this.reduceQueue, pageFrameReduceSubSeq, this.record, this.circuitBreaker, this);
            }
            catch (Throwable e) {
                LOG.error().$("await error [id=").$(this.id).$(", ex=").$(e).I$();
            }
            if (!nothingProcessed) continue;
            long cursor = this.collectSubSeq.next();
            if (cursor > -1L) {
                PageFrameReduceTask tsk = this.reduceQueue.get(cursor);
                if (tsk.getFrameSequence() == this) {
                    tsk.collected(true);
                }
                this.collectSubSeq.done(cursor);
                continue;
            }
            if (cursor == -1L && allFramesReduced) {
                if (this.doneLatch.getCount() != 0) break;
                this.reset();
                break;
            }
            Os.pause();
        }
        while (this.reduceCounter.get() != this.dispatchStartFrameIndex) {
            Os.pause();
        }
    }

    public void clear() {
        this.frameCount = 0;
        this.dispatchStartFrameIndex = 0;
        this.collectedFrameIndex = -1;
        this.pageAddressCache.clear();
        this.symbolTableSource = Misc.free(this.symbolTableSource);
        if (this.collectSubSeq != null) {
            this.messageBus.getPageFrameCollectFanOut(this.shard).remove(this.collectSubSeq);
            LOG.debug().$("removed [seq=").$(this.collectSubSeq).I$();
            this.collectSubSeq.clear();
        }
        if (this.localTask != null) {
            this.localTask.resetCapacities();
            this.localTaskPool.push(this.localTask);
            this.localTask = null;
        }
    }

    @Override
    public void close() {
        this.clear();
        Misc.free(this.circuitBreaker);
        Misc.free(this.record);
    }

    public PageFrameSequence<T> of(RecordCursorFactory base, SqlExecutionContext executionContext, Sequence collectSubSeq, T atom, int order) throws SqlException {
        this.sqlExecutionContext = executionContext;
        this.startTime = this.clock.getTicks();
        this.circuitBreakerFd = executionContext.getCircuitBreaker().getFd();
        this.initRecord(executionContext.getCircuitBreaker());
        Rnd rnd = executionContext.getAsyncRandom();
        try {
            PageFrameCursor pageFrameCursor = base.getPageFrameCursor(executionContext, order);
            int frameCount = this.setupAddressCache(base, pageFrameCursor);
            this.prepareForDispatch(rnd, frameCount, pageFrameCursor, atom, collectSubSeq);
            atom.init(pageFrameCursor, executionContext);
            if (frameCount > 0) {
                this.messageBus.getPageFrameCollectFanOut(this.shard).and(collectSubSeq);
                LOG.debug().$("added [shard=").$(this.shard).$(", id=").$(this.id).$(", seqCurrent=").$(collectSubSeq.current()).$(", seq=").$(collectSubSeq).I$();
            }
        }
        catch (Throwable e) {
            this.symbolTableSource = Misc.free(this.symbolTableSource);
            throw e;
        }
        return this;
    }

    public T getAtom() {
        return this.atom;
    }

    public long getCircuitBreakerFd() {
        return this.circuitBreakerFd;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public long getFrameRowCount(int frameIndex) {
        return this.frameRowCounts.getQuick(frameIndex);
    }

    public long getId() {
        return this.id;
    }

    public PageAddressCache getPageAddressCache() {
        return this.pageAddressCache;
    }

    public AtomicInteger getReduceCounter() {
        return this.reduceCounter;
    }

    public PageFrameReducer getReducer() {
        return this.reducer;
    }

    public int getShard() {
        return this.shard;
    }

    public SqlExecutionContext getSqlExecutionContext() {
        return this.sqlExecutionContext;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public SymbolTableSource getSymbolTableSource() {
        return this.symbolTableSource;
    }

    public boolean isActive() {
        return this.valid.get();
    }

    public void cancel() {
        this.valid.compareAndSet(true, false);
    }

    public void reset() {
        this.frameRowCounts.clear();
        assert (this.doneLatch.getCount() == 0);
        this.doneLatch.countDown();
    }

    public long next() {
        assert (this.collectedFrameIndex < this.frameCount - 1);
        while (true) {
            long cursor;
            if ((cursor = this.collectSubSeq.next()) > -1L) {
                PageFrameReduceTask task = this.reduceQueue.get(cursor);
                PageFrameSequence<?> thatFrameSequence = task.getFrameSequence();
                if (thatFrameSequence == this) {
                    return cursor;
                }
                this.collectSubSeq.done(cursor);
                continue;
            }
            if (cursor == -1L) {
                if (this.dispatch()) continue;
                if (this.dispatchStartFrameIndex == this.collectedFrameIndex + 1) {
                    this.workLocally();
                    return Long.MAX_VALUE;
                }
                return -1L;
            }
            Os.pause();
        }
    }

    private boolean dispatch() {
        boolean idle = true;
        boolean dispatched = false;
        MCSequence reduceSubSeq = this.messageBus.getPageFrameReduceSubSeq(this.shard);
        MPSequence reducePubSeq = this.messageBus.getPageFrameReducePubSeq(this.shard);
        this.dispatchStartFrameIndex = this.frameCount;
        block0: for (int i = this.dispatchStartFrameIndex; i < this.frameCount; ++i) {
            long cursor;
            while (true) {
                if ((cursor = reducePubSeq.next()) > -1L) break;
                if (cursor == -1L) {
                    idle = false;
                    if (this.stealWork(this.reduceQueue, reduceSubSeq, this.record, this.circuitBreaker)) continue;
                    this.dispatchStartFrameIndex = i;
                    break block0;
                }
                Os.pause();
            }
            this.reduceQueue.get(cursor).of(this, i);
            LOG.debug().$("dispatched [shard=").$(this.shard).$(", id=").$(this.getId()).$(", frameIndex=").$(i).$(", frameCount=").$(this.frameCount).$(", cursor=").$(cursor).I$();
            reducePubSeq.done(cursor);
            dispatched = true;
        }
        while (this.reduceCounter.get() < this.frameCount) {
            idle = false;
            if (this.stealWork(this.reduceQueue, reduceSubSeq, this.record, this.circuitBreaker) && this.isActive()) continue;
        }
        if (idle) {
            this.stealWork(this.reduceQueue, reduceSubSeq, this.record, this.circuitBreaker);
        }
        return dispatched;
    }

    private boolean stealWork(RingQueue<PageFrameReduceTask> queue, MCSequence reduceSubSeq, PageAddressCacheRecord record, SqlExecutionCircuitBreaker circuitBreaker) {
        if (PageFrameReduceJob.consumeQueue(queue, reduceSubSeq, record, circuitBreaker, this)) {
            Os.pause();
            return false;
        }
        return true;
    }

    private void workLocally() {
        assert (this.dispatchStartFrameIndex < this.frameCount);
        if (this.localTask == null) {
            this.localTask = (PageFrameReduceTask)this.localTaskPool.pop();
        }
        this.localTask.of(this, this.dispatchStartFrameIndex++);
        try {
            if (this.isActive()) {
                PageFrameReduceJob.reduce(this.record, this.circuitBreaker, this.localTask, this, this);
            }
        }
        catch (Throwable e) {
            this.cancel();
            throw e;
        }
        finally {
            this.reduceCounter.incrementAndGet();
        }
    }

    public PageFrameReduceTask getTask(long cursor) {
        assert (cursor > -1L);
        if (cursor == Long.MAX_VALUE) {
            assert (this.localTask != null && this.localTask.getFrameSequence() != null);
            return this.localTask;
        }
        return this.reduceQueue.get(cursor);
    }

    public void collect(long cursor, boolean forceCollect) {
        assert (cursor > -1L);
        if (cursor == Long.MAX_VALUE) {
            this.collectedFrameIndex = this.localTask.getFrameIndex();
            this.localTask.collected();
            return;
        }
        PageFrameReduceTask task = this.reduceQueue.get(cursor);
        this.collectedFrameIndex = task.getFrameIndex();
        task.collected(forceCollect);
        this.collectSubSeq.done(cursor);
    }

    public void toTop() {
        if (this.frameCount > 0) {
            LOG.debug().$("toTop [shard=").$(this.shard).$(", id=").$(this.id).I$();
            this.await();
            this.doneLatch.reset();
            this.id = ID_SEQ.incrementAndGet();
            this.dispatchStartFrameIndex = 0;
            this.collectedFrameIndex = -1;
            this.reduceCounter.set(0);
            this.valid.set(true);
        }
    }

    private void initRecord(SqlExecutionCircuitBreaker executionContextCircuitBreaker) {
        if (this.record == null) {
            SqlExecutionCircuitBreakerConfiguration sqlExecutionCircuitBreakerConfiguration = executionContextCircuitBreaker.getConfiguration();
            this.record = new PageAddressCacheRecord();
            this.circuitBreaker = sqlExecutionCircuitBreakerConfiguration != null ? new NetworkSqlExecutionCircuitBreaker(sqlExecutionCircuitBreakerConfiguration, 29) : NetworkSqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER;
        }
        this.circuitBreaker.setFd(executionContextCircuitBreaker.getFd());
    }

    private void prepareForDispatch(Rnd rnd, int frameCount, SymbolTableSource symbolTableSource, T atom, Sequence collectSubSeq) {
        this.id = ID_SEQ.incrementAndGet();
        this.doneLatch.reset();
        this.valid.set(true);
        this.reduceCounter.set(0);
        this.shard = rnd.nextInt(this.messageBus.getPageFrameReduceShardCount());
        this.reduceQueue = this.messageBus.getPageFrameReduceQueue(this.shard);
        this.frameCount = frameCount;
        assert (this.symbolTableSource == null);
        this.symbolTableSource = symbolTableSource;
        this.atom = atom;
        this.collectSubSeq = collectSubSeq;
    }

    private int setupAddressCache(RecordCursorFactory base, PageFrameCursor pageFrameCursor) {
        PageFrame frame;
        this.pageAddressCache.of(base.getMetadata());
        int frameIndex = 0;
        while ((frame = pageFrameCursor.next()) != null) {
            this.pageAddressCache.add(frameIndex++, frame);
            this.frameRowCounts.add(frame.getPartitionHi() - frame.getPartitionLo());
        }
        return frameIndex;
    }
}

