/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.PageAddressCache;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import java.io.Closeable;

public class PageFrameReduceTask
implements Closeable {
    private final DirectLongList rows;
    private final DirectLongList columns;
    private final long pageFrameQueueCapacity;
    private int frameIndex = Integer.MAX_VALUE;
    private PageFrameSequence<?> frameSequence;

    public PageFrameReduceTask(CairoConfiguration configuration) {
        this.rows = new DirectLongList(configuration.getPageFrameReduceRowIdListCapacity(), 23);
        this.columns = new DirectLongList(configuration.getPageFrameReduceColumnListCapacity(), 23);
        this.pageFrameQueueCapacity = configuration.getPageFrameReduceQueueCapacity();
    }

    @Override
    public void close() {
        Misc.free(this.rows);
        Misc.free(this.columns);
    }

    void collected() {
        this.collected(false);
    }

    void collected(boolean forceCollect) {
        long frameCount = this.frameSequence.getFrameCount();
        if (forceCollect || (long)this.frameIndex >= frameCount - this.pageFrameQueueCapacity) {
            this.resetCapacities();
        }
        if ((long)(this.frameIndex + 1) == frameCount) {
            this.frameSequence.reset();
        }
        this.frameSequence = null;
    }

    public void resetCapacities() {
        this.rows.resetCapacity();
        this.columns.resetCapacity();
    }

    public DirectLongList getColumns() {
        return this.columns;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public long getFrameRowCount() {
        return this.frameSequence.getFrameRowCount(this.frameIndex);
    }

    public PageFrameSequence<?> getFrameSequence() {
        return this.frameSequence;
    }

    public <T extends StatefulAtom> PageFrameSequence<T> getFrameSequence(Class<T> unused) {
        return this.frameSequence;
    }

    public PageAddressCache getPageAddressCache() {
        return this.frameSequence.getPageAddressCache();
    }

    public DirectLongList getRows() {
        return this.rows;
    }

    public void of(PageFrameSequence<?> frameSequence, int frameIndex) {
        this.frameSequence = frameSequence;
        this.frameIndex = frameIndex;
        this.rows.clear();
    }
}

