/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.MessageBus;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.PageAddressCacheRecord;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.MCSequence;
import io.questdb.mp.RingQueue;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class PageFrameReduceJob
implements Job,
Closeable {
    private static final Log LOG = LogFactory.getLog(PageFrameReduceJob.class);
    private PageAddressCacheRecord record;
    private final int[] shards;
    private final int shardCount;
    private final MessageBus messageBus;
    private SqlExecutionCircuitBreaker circuitBreaker;

    public PageFrameReduceJob(MessageBus bus, Rnd rnd, @Nullable SqlExecutionCircuitBreakerConfiguration sqlExecutionCircuitBreakerConfiguration) {
        this.messageBus = bus;
        this.shardCount = this.messageBus.getPageFrameReduceShardCount();
        this.shards = new int[this.shardCount];
        for (int i = 0; i < this.shardCount; ++i) {
            this.shards[i] = i;
        }
        int currentIndex = this.shardCount;
        while (currentIndex != 0) {
            int randomIndex = (int)Math.floor(rnd.nextDouble() * (double)currentIndex);
            int tmp = this.shards[--currentIndex];
            this.shards[currentIndex] = this.shards[randomIndex];
            this.shards[randomIndex] = tmp;
        }
        this.record = new PageAddressCacheRecord();
        this.circuitBreaker = sqlExecutionCircuitBreakerConfiguration != null ? new NetworkSqlExecutionCircuitBreaker(sqlExecutionCircuitBreakerConfiguration, 28) : NetworkSqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER;
    }

    public static boolean consumeQueue(RingQueue<PageFrameReduceTask> queue, MCSequence subSeq, PageAddressCacheRecord record, SqlExecutionCircuitBreaker circuitBreaker, PageFrameSequence<?> stealingFrameSequence) {
        return PageFrameReduceJob.consumeQueue(-1, queue, subSeq, record, circuitBreaker, stealingFrameSequence);
    }

    private static boolean consumeQueue(int workerId, RingQueue<PageFrameReduceTask> queue, MCSequence subSeq, PageAddressCacheRecord record, SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        while (true) {
            long cursor;
            if ((cursor = subSeq.next()) > -1L) {
                PageFrameReduceTask task = queue.get(cursor);
                PageFrameSequence<?> frameSequence = task.getFrameSequence();
                try {
                    LOG.debug().$("reducing [shard=").$(frameSequence.getShard()).$(", id=").$(frameSequence.getId()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(frameSequence.getFrameCount()).$(", active=").$(frameSequence.isActive()).$(", cursor=").$(cursor).I$();
                    if (frameSequence.isActive()) {
                        PageFrameReduceJob.reduce(workerId, record, circuitBreaker, task, frameSequence, stealingFrameSequence);
                    }
                }
                catch (Throwable e) {
                    frameSequence.cancel();
                    throw e;
                }
                finally {
                    subSeq.done(cursor);
                    frameSequence.getReduceCounter().incrementAndGet();
                }
                return false;
            }
            if (cursor == -1L) break;
            Os.pause();
        }
        return true;
    }

    public static void reduce(PageAddressCacheRecord record, SqlExecutionCircuitBreaker circuitBreaker, PageFrameReduceTask task, PageFrameSequence<?> frameSequence, PageFrameSequence<?> stealingFrameSequence) {
        PageFrameReduceJob.reduce(-1, record, circuitBreaker, task, frameSequence, stealingFrameSequence);
    }

    private static void reduce(int workerId, PageAddressCacheRecord record, SqlExecutionCircuitBreaker circuitBreaker, PageFrameReduceTask task, PageFrameSequence<?> frameSequence, PageFrameSequence<?> stealingFrameSequence) {
        if (!circuitBreaker.checkIfTripped(frameSequence.getStartTime(), frameSequence.getCircuitBreakerFd())) {
            record.of(frameSequence.getSymbolTableSource(), frameSequence.getPageAddressCache());
            record.setFrameIndex(task.getFrameIndex());
            assert (frameSequence.doneLatch.getCount() == 0);
            frameSequence.getReducer().reduce(workerId, record, task, circuitBreaker, stealingFrameSequence);
        } else {
            frameSequence.cancel();
        }
    }

    @Override
    public void close() {
        this.circuitBreaker = Misc.free(this.circuitBreaker);
        this.record = Misc.free(this.record);
    }

    @Override
    public boolean run(int workerId) {
        boolean useful = false;
        for (int i = 0; i < this.shardCount; ++i) {
            int shard = this.shards[i];
            useful = !PageFrameReduceJob.consumeQueue(workerId, this.messageBus.getPageFrameReduceQueue(shard), this.messageBus.getPageFrameReduceSubSeq(shard), this.record, this.circuitBreaker, null) || useful;
        }
        return useful;
    }
}

