/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.PageAddressCache;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.NullMemoryMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256Impl;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Rows;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public class PageAddressCacheRecord
implements Record,
Closeable {
    private final MemoryCR.ByteSequenceView bsview = new MemoryCR.ByteSequenceView();
    private final MemoryCR.CharSequenceView csview = new MemoryCR.CharSequenceView();
    private final MemoryCR.CharSequenceView csview2 = new MemoryCR.CharSequenceView();
    private final Long256Impl long256A = new Long256Impl();
    private final Long256Impl long256B = new Long256Impl();
    private SymbolTableSource symbolTableSource;
    private final ObjList<SymbolTable> symbolTableCache = new ObjList();
    private PageAddressCache pageAddressCache;
    private int frameIndex;
    private long rowIndex;

    public PageAddressCacheRecord(PageAddressCacheRecord other) {
        this.symbolTableSource = other.symbolTableSource;
        this.pageAddressCache = other.pageAddressCache;
        this.frameIndex = other.frameIndex;
        this.rowIndex = other.rowIndex;
    }

    public PageAddressCacheRecord() {
    }

    @Override
    public void close() {
        Misc.freeObjList(this.symbolTableCache);
    }

    @Override
    public BinarySequence getBin(int columnIndex) {
        long dataPageAddress = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (dataPageAddress == 0L) {
            return NullMemoryMR.INSTANCE.getBin(0L);
        }
        long indexPageAddress = this.pageAddressCache.getIndexPageAddress(this.frameIndex, columnIndex);
        long offset = Unsafe.getUnsafe().getLong(indexPageAddress + this.rowIndex * 8L);
        long pageLimit = this.pageAddressCache.getPageSize(this.frameIndex, columnIndex);
        return this.getBin(dataPageAddress, offset, pageLimit, this.bsview);
    }

    @Override
    public long getBinLen(int columnIndex) {
        long dataPageAddress = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (dataPageAddress == 0L) {
            return NullMemoryMR.INSTANCE.getBinLen(0L);
        }
        long indexPageAddress = this.pageAddressCache.getIndexPageAddress(this.frameIndex, columnIndex);
        long offset = Unsafe.getUnsafe().getLong(indexPageAddress + this.rowIndex * 8L);
        return Unsafe.getUnsafe().getLong(dataPageAddress + offset);
    }

    @Override
    public boolean getBool(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getBool(0L);
        }
        return Unsafe.getUnsafe().getByte(address + this.rowIndex * 1L) == 1;
    }

    @Override
    public byte getByte(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getByte(0L);
        }
        return Unsafe.getUnsafe().getByte(address + this.rowIndex * 1L);
    }

    @Override
    public char getChar(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getChar(0L);
        }
        return Unsafe.getUnsafe().getChar(address + this.rowIndex * 2L);
    }

    @Override
    public double getDouble(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getDouble(0L);
        }
        return Unsafe.getUnsafe().getDouble(address + this.rowIndex * 8L);
    }

    @Override
    public float getFloat(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getFloat(0L);
        }
        return Unsafe.getUnsafe().getFloat(address + this.rowIndex * 4L);
    }

    @Override
    public int getInt(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getInt(0L);
        }
        return Unsafe.getUnsafe().getInt(address + this.rowIndex * 4L);
    }

    @Override
    public long getLong(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getLong(0L);
        }
        return Unsafe.getUnsafe().getLong(address + this.rowIndex * 8L);
    }

    @Override
    public long getLong128Hi(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return Long.MIN_VALUE;
        }
        return Unsafe.getUnsafe().getLong(address + this.rowIndex * 8L * 2L + 8L);
    }

    @Override
    public long getLong128Lo(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return Long.MIN_VALUE;
        }
        return Unsafe.getUnsafe().getLong(address + this.rowIndex * 8L * 2L);
    }

    @Override
    public void getLong256(int columnIndex, CharSink sink) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            NullMemoryMR.INSTANCE.getLong256(0L, sink);
            return;
        }
        this.getLong256(address + this.rowIndex * 32L, sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        this.getLong256(columnIndex, this.long256A);
        return this.long256A;
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        this.getLong256(columnIndex, this.long256B);
        return this.long256B;
    }

    @Override
    public long getRowId() {
        return Rows.toRowID(this.frameIndex, this.rowIndex);
    }

    @Override
    public long getUpdateRowId() {
        return this.pageAddressCache.toTableRowID(this.frameIndex, this.rowIndex);
    }

    @Override
    public short getShort(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getShort(0L);
        }
        return Unsafe.getUnsafe().getShort(address + this.rowIndex * 2L);
    }

    @Override
    public CharSequence getStr(int columnIndex) {
        long dataPageAddress = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (dataPageAddress == 0L) {
            return NullMemoryMR.INSTANCE.getStr(0L);
        }
        long indexPageAddress = this.pageAddressCache.getIndexPageAddress(this.frameIndex, columnIndex);
        long offset = Unsafe.getUnsafe().getLong(indexPageAddress + this.rowIndex * 8L);
        long size = this.pageAddressCache.getPageSize(this.frameIndex, columnIndex);
        return this.getStr(dataPageAddress, offset, size, this.csview);
    }

    @Override
    public CharSequence getStrB(int columnIndex) {
        long dataPageAddress = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (dataPageAddress == 0L) {
            return NullMemoryMR.INSTANCE.getStr2(0L);
        }
        long indexPageAddress = this.pageAddressCache.getIndexPageAddress(this.frameIndex, columnIndex);
        long offset = Unsafe.getUnsafe().getLong(indexPageAddress + this.rowIndex * 8L);
        long size = this.pageAddressCache.getPageSize(this.frameIndex, columnIndex);
        return this.getStr(dataPageAddress, offset, size, this.csview2);
    }

    @Override
    public int getStrLen(int columnIndex) {
        long dataPageAddress = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (dataPageAddress == 0L) {
            return NullMemoryMR.INSTANCE.getStrLen(0L);
        }
        long indexPageAddress = this.pageAddressCache.getIndexPageAddress(this.frameIndex, columnIndex);
        long offset = Unsafe.getUnsafe().getLong(indexPageAddress + this.rowIndex * 8L);
        return Unsafe.getUnsafe().getInt(dataPageAddress + offset);
    }

    @Override
    public CharSequence getSym(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        int key = NullMemoryMR.INSTANCE.getInt(0L);
        if (address != 0L) {
            key = Unsafe.getUnsafe().getInt(address + this.rowIndex * 4L);
        }
        return this.getSymbolTable(columnIndex).valueOf(key);
    }

    @Override
    public CharSequence getSymB(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        int key = Unsafe.getUnsafe().getInt(address + this.rowIndex * 4L);
        return this.getSymbolTable(columnIndex).valueBOf(key);
    }

    @Override
    public byte getGeoByte(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getByte(0L);
        }
        return Unsafe.getUnsafe().getByte(address + this.rowIndex * 1L);
    }

    @Override
    public short getGeoShort(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getShort(0L);
        }
        return Unsafe.getUnsafe().getShort(address + this.rowIndex * 2L);
    }

    @Override
    public int getGeoInt(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getInt(0L);
        }
        return Unsafe.getUnsafe().getInt(address + this.rowIndex * 4L);
    }

    @Override
    public long getGeoLong(int columnIndex) {
        long address = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (address == 0L) {
            return NullMemoryMR.INSTANCE.getLong(0L);
        }
        return Unsafe.getUnsafe().getLong(address + this.rowIndex * 8L);
    }

    public void of(SymbolTableSource symbolTableSource, PageAddressCache pageAddressCache) {
        this.symbolTableSource = symbolTableSource;
        this.pageAddressCache = pageAddressCache;
        this.frameIndex = 0;
        this.rowIndex = 0L;
        Misc.freeObjList(this.symbolTableCache);
        this.symbolTableCache.clear();
    }

    public void setFrameIndex(int frameIndex) {
        this.frameIndex = frameIndex;
    }

    public void setRowIndex(long rowIndex) {
        this.rowIndex = rowIndex;
    }

    private BinarySequence getBin(long base, long offset, long pageLimit, MemoryCR.ByteSequenceView view) {
        long address = base + offset;
        long len = Unsafe.getUnsafe().getLong(address);
        if (len != -1L) {
            if (len + 8L + offset <= pageLimit) {
                return view.of(address + 8L, len);
            }
            throw CairoException.critical(0).put("Bin is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(", pageLimit=").put(pageLimit).put(']');
        }
        return null;
    }

    void getLong256(long offset, CharSink sink) {
        long addr = offset + 32L;
        long a = Unsafe.getUnsafe().getLong(addr - 32L);
        long b = Unsafe.getUnsafe().getLong(addr - 24L);
        long c = Unsafe.getUnsafe().getLong(addr - 16L);
        long d = Unsafe.getUnsafe().getLong(addr - 8L);
        Numbers.appendLong256(a, b, c, d, sink);
    }

    void getLong256(int columnIndex, Long256Acceptor sink) {
        long columnAddress = this.pageAddressCache.getPageAddress(this.frameIndex, columnIndex);
        if (columnAddress == 0L) {
            NullMemoryMR.INSTANCE.getLong256(0L, sink);
            return;
        }
        long addr = columnAddress + this.rowIndex * 32L + 32L;
        sink.setAll(Unsafe.getUnsafe().getLong(addr - 32L), Unsafe.getUnsafe().getLong(addr - 24L), Unsafe.getUnsafe().getLong(addr - 16L), Unsafe.getUnsafe().getLong(addr - 8L));
    }

    private CharSequence getStr(long base, long offset, long size, MemoryCR.CharSequenceView view) {
        long address = base + offset;
        int len = Unsafe.getUnsafe().getInt(address);
        if (len != -1) {
            if ((long)(len + 4) + offset <= size) {
                return view.of(address + 4L, len);
            }
            throw CairoException.critical(0).put("String is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(", size=").put(size).put(']');
        }
        return null;
    }

    private SymbolTable getSymbolTable(int columnIndex) {
        SymbolTable symbolTable = this.symbolTableCache.getQuiet(columnIndex);
        if (symbolTable == null) {
            symbolTable = this.symbolTableSource.newSymbolTable(columnIndex);
            this.symbolTableCache.extendAndSet(columnIndex, symbolTable);
        }
        return symbolTable;
    }
}

