/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.io.Closeable;

public class NetworkSqlExecutionCircuitBreaker
implements SqlExecutionCircuitBreaker,
Closeable {
    private final NetworkFacade nf;
    private final int throttle;
    private final int bufferSize;
    private final MillisecondClock clock;
    private final long defaultMaxTime;
    private final SqlExecutionCircuitBreakerConfiguration configuration;
    private long timeout;
    private long buffer;
    private int testCount;
    private long fd = -1L;
    private long powerUpTime;
    private final int memoryTag;

    public NetworkSqlExecutionCircuitBreaker(SqlExecutionCircuitBreakerConfiguration configuration, int memoryTag) {
        this.configuration = configuration;
        this.nf = configuration.getNetworkFacade();
        this.throttle = configuration.getCircuitBreakerThrottle();
        this.bufferSize = configuration.getBufferSize();
        this.memoryTag = memoryTag;
        this.buffer = Unsafe.malloc(this.bufferSize, this.memoryTag);
        this.clock = configuration.getClock();
        long timeout = configuration.getTimeout();
        this.timeout = timeout > 0L ? timeout : Long.MAX_VALUE;
        this.defaultMaxTime = this.timeout;
    }

    @Override
    public void close() {
        Unsafe.free(this.buffer, this.bufferSize, this.memoryTag);
        this.buffer = 0L;
        this.fd = -1L;
    }

    @Override
    public SqlExecutionCircuitBreakerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    public void resetMaxTimeToDefault() {
        this.timeout = this.defaultMaxTime;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void statefulThrowExceptionIfTripped() {
        if (this.testCount < this.throttle) {
            ++this.testCount;
        } else {
            this.testCount = 0;
            this.testTimeout();
            if (this.testConnection(this.fd)) {
                throw CairoException.nonCritical().put("remote disconnected, query aborted [fd=").put(this.fd).put(']').setInterruption(true);
            }
        }
    }

    @Override
    public boolean checkIfTripped() {
        return this.checkIfTripped(this.powerUpTime, this.fd);
    }

    @Override
    public boolean checkIfTripped(long millis, long fd) {
        if (this.clock.getTicks() - this.timeout > millis) {
            return true;
        }
        return this.testConnection(fd);
    }

    @Override
    public void setFd(long fd) {
        this.fd = fd;
    }

    @Override
    public void resetTimer() {
        this.powerUpTime = this.clock.getTicks();
    }

    public NetworkSqlExecutionCircuitBreaker of(long fd) {
        assert (this.buffer != 0L);
        this.testCount = 0;
        this.fd = fd;
        return this;
    }

    private boolean testConnection(long fd) {
        byte b;
        int index;
        assert (fd != -1L);
        int nRead = this.nf.peek(fd, this.buffer, this.bufferSize);
        if (nRead == 0) {
            return false;
        }
        if (nRead < 0) {
            return true;
        }
        long ptr = this.buffer;
        for (index = 0; index < nRead && ((b = Unsafe.getUnsafe().getByte(ptr + (long)index)) == 13 || b == 10); ++index) {
        }
        if (index > 0) {
            this.nf.recv(fd, this.buffer, index);
        }
        return false;
    }

    private void testTimeout() {
        if (this.clock.getTicks() - this.timeout > this.powerUpTime) {
            throw CairoException.nonCritical().put("timeout, query aborted [fd=").put(this.fd).put(']').setInterruption(true);
        }
    }
}

