/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;
import io.questdb.std.Vect;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public class Mig620 {
    private static final long META_OFFSET_COUNT_MIG = 0L;
    private static final long META_OFFSET_COLUMN_TYPES_MIG = 128L;
    private static final long META_COLUMN_DATA_SIZE_MIG = 32L;
    private static final long CV_COL_TOP_DEFAULT_PARTITION_MIG = Long.MIN_VALUE;
    private static final Log LOG = LogFactory.getLog(EngineMigration.class);
    private static final String TXN_FILE_NAME_MIG = "_txn";
    private static final String COLUMN_VERSION_FILE_NAME_MIG = "_cv";
    private static final String META_FILE_NAME_MIG = "_meta";
    private static final long META_OFFSET_PARTITION_BY_MIG = 4L;
    private static final int TX_BASE_HEADER_SECTION_PADDING_MIG = 12;
    private static final long TX_OFFSET_MAP_WRITER_COUNT_MIG = 128L;
    private static final long TXN_OFFSET_MIG = 0L;
    private static final long TX_BASE_OFFSET_VERSION_MIG = 0L;
    private static final long TX_BASE_OFFSET_A_MIG = 8L;
    private static final long TX_BASE_OFFSET_SYMBOLS_SIZE_A_MIG = 12L;
    private static final long TX_BASE_OFFSET_PARTITIONS_SIZE_A_MIG = 16L;
    private static final long TX_BASE_OFFSET_B_MIG = 32L;
    private static final long TX_BASE_OFFSET_SYMBOLS_SIZE_B_MIG = 36L;
    private static final long TX_BASE_OFFSET_PARTITIONS_SIZE_B_MIG = 40L;
    private static final int TX_BASE_HEADER_SIZE_MIG = (int)Math.max(56L, 64L);
    private static final long TX_OFFSET_COLUMN_VERSION_MIG = 64L;
    private static final long TX_OFFSET_TRUNCATE_VERSION_MIG = 72L;
    private static final long PARTITION_NAME_TX_OFFSET_MIG = 2L;
    private static final int COLUMN_VERSION_FILE_HEADER_SIZE_MIG = 40;
    private static final int CV_OFFSET_VERSION_64 = 0;
    private static final int CV_OFFSET_OFFSET_A_64 = 8;
    private static final int CV_OFFSET_SIZE_A_64 = 16;
    private static final int CV_OFFSET_OFFSET_B_64 = 24;
    private static final int CV_OFFSET_SIZE_B_64 = 32;
    private static final int CV_HEADER_SIZE = 40;
    private static final long TX_DEFAULT_PARTITION_TIMESTAMP_MIG = 0L;

    static void migrate(MigrationContext migrationContext) {
        FilesFacade ff = migrationContext.getFf();
        Path path = migrationContext.getTablePath();
        int pathLen = path.length();
        path.concat(TXN_FILE_NAME_MIG).$();
        try (MemoryCMARW txMemory = Mig620.openFileSafe(ff, path, 136L);){
            int symbolCount = txMemory.getInt(128L);
            long partitionSizeOffset = 132L + (long)symbolCount * 8L;
            int partitionTableSize = txMemory.size() > partitionSizeOffset ? txMemory.getInt(partitionSizeOffset) : 0;
            long existingTotalSize = partitionSizeOffset + 4L + (long)partitionTableSize;
            long txn = txMemory.getLong(0L);
            Mig620.createColumnVersionFile(txMemory, partitionSizeOffset, partitionTableSize, migrationContext, path, pathLen);
            Mig620.migrateTxn(txMemory, symbolCount, partitionTableSize, existingTotalSize, txn);
        }
    }

    private static void createColumnVersionFile(MemoryMARW txMemory, long partitionSizeOffset, int partitionTableSize, MigrationContext migrationContext, Path path, int pathLen) {
        FilesFacade ff = migrationContext.getFf();
        try (MemoryCMARW cvMemory = Vm.getCMARWInstance(ff, path.trimTo(pathLen).concat(COLUMN_VERSION_FILE_NAME_MIG).$(), Files.PAGE_SIZE, 40L, 1, 0L);){
            cvMemory.extend(40L);
            cvMemory.jumpTo(40L);
            cvMemory.zero();
            try (MemoryCMARW metaMem = Mig620.openFileSafe(ff, path.trimTo(pathLen).concat(META_FILE_NAME_MIG).$(), 128L);){
                int partitionBy = metaMem.getInt(4L);
                ObjList<String> columnNames = Mig620.readColumNames(metaMem);
                int columnCount = columnNames.size();
                LongList columnTops = Mig620.readColumnTops(columnCount, partitionBy, partitionSizeOffset, partitionTableSize, txMemory, ff, path, pathLen, columnNames);
                path.trimTo(pathLen);
                long sizeBytes = Mig620.writeColumnVersion(path, columnTops, columnCount, columnNames, cvMemory);
                cvMemory.putLong(8L, 40L);
                cvMemory.putLong(16L, sizeBytes);
                cvMemory.jumpTo(40L + sizeBytes);
            }
        }
    }

    private static long writeColumnVersion(Path tablePath, LongList columnTops, int columnCount, ObjList<String> columnNames, MemoryMARW cvMemory) {
        int topStep = columnCount + 1;
        LongList columnVersions = new LongList();
        LongList maxPartitionIndexWithNoColumnList = new LongList();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            int maxPartitionIndexWithNoColumn = -1;
            for (int partitionIndex = 0; partitionIndex < columnTops.size(); partitionIndex += topStep) {
                long columnTop = columnTops.getQuick(partitionIndex + columnIndex + 1);
                if (columnTop >= 0L) continue;
                maxPartitionIndexWithNoColumn = partitionIndex;
            }
            if (maxPartitionIndexWithNoColumn != -1) {
                if (maxPartitionIndexWithNoColumn + topStep >= columnTops.size()) {
                    throw CairoException.critical(0).put("Table ").put(tablePath).put(" column '").put(columnNames.getQuick(columnIndex)).put("' is not present in the last partition.");
                }
                long columnAddedPartitionTs = columnTops.getQuick(maxPartitionIndexWithNoColumn + topStep);
                columnVersions.add(Long.MIN_VALUE, columnIndex, -1L, columnAddedPartitionTs);
            }
            maxPartitionIndexWithNoColumnList.add(maxPartitionIndexWithNoColumn);
        }
        for (int partitionIndex = 0; partitionIndex < columnTops.size(); partitionIndex += topStep) {
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                long maxPartitionIndexWithNoColumn = maxPartitionIndexWithNoColumnList.getQuick(columnIndex);
                long partitionTs = columnTops.getQuick(partitionIndex);
                long columnTop = columnTops.getQuick(partitionIndex + columnIndex + 1);
                if (columnTop <= 0L && (columnTop != 0L || (long)partitionIndex >= maxPartitionIndexWithNoColumn)) continue;
                columnVersions.add(partitionTs, columnIndex, -1L, columnTop);
            }
        }
        for (int i = 0; i < columnVersions.size(); ++i) {
            cvMemory.putLong(40L + (long)i * 8L, columnVersions.getQuick(i));
        }
        int sizeByes = columnVersions.size() * 8;
        cvMemory.jumpTo(sizeByes + 40);
        return sizeByes;
    }

    private static LongList readColumnTops(int columnCount, int partitionBy, long partitionSizeOffset, int partitionTableSize, MemoryMARW txMemory, FilesFacade ff, Path path, int pathLen, ObjList<String> columnNames) {
        if (!PartitionBy.isPartitioned(partitionBy)) {
            LongList result = new LongList();
            Mig620.readColumnTopsForPartition(result, columnNames, columnCount, partitionBy, 0L, -1L, ff, path, pathLen);
            return result;
        }
        return Mig620.readColumnTopsAllPartitions(columnCount, partitionBy, partitionSizeOffset, partitionTableSize, txMemory, ff, path, pathLen, columnNames);
    }

    private static LongList readColumnTopsAllPartitions(int columnCount, int partitionBy, long partitionSizeOffset, int partitionTableSize, MemoryMARW txMemory, FilesFacade ff, Path path, int pathLen, ObjList<String> columnNames) {
        LongList result = new LongList();
        int partitionCount = partitionTableSize / 8 / 4;
        long offset = partitionSizeOffset + 4L;
        long prevPartition = Long.MIN_VALUE;
        long txSize = txMemory.size() - 32L;
        for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
            if (offset > txSize) {
                throw CairoException.critical(0).put("corrupt _txn file ").put(path.trimTo(pathLen).$()).put(", file is too small to read offset ").put(offset);
            }
            long partitionTs = txMemory.getLong(offset);
            if (partitionTs <= prevPartition) {
                throw CairoException.critical(0).put("corrupt _txn file, partitions are not ordered at ").put(path.trimTo(pathLen).$());
            }
            long partitionNameTxn = txMemory.getLong(offset + 16L);
            Mig620.readColumnTopsForPartition(result, columnNames, columnCount, partitionBy, partitionTs, partitionNameTxn, ff, path, pathLen);
            offset += 32L;
            prevPartition = partitionTs;
        }
        return result;
    }

    private static void readColumnTopsForPartition(LongList tops, ObjList<String> columnNames, int columnCount, int partitionBy, long partitionTimestamp, long partitionNameTxn, FilesFacade ff, Path path, int pathLen) {
        tops.add(partitionTimestamp);
        path.trimTo(pathLen);
        Mig620.setPathForPartition(path, partitionBy, partitionTimestamp, partitionNameTxn);
        int partitionPathLen = path.length();
        if (ff.exists(path.put(Files.SEPARATOR).$())) {
            for (int i = 0; i < columnCount; ++i) {
                path.trimTo(partitionPathLen);
                String columnName = columnNames.get(i);
                Mig620.dFile(path, columnName);
                long columnTop = -1L;
                if (ff.exists(path)) {
                    columnTop = Mig620.readColumnTop(ff, path.trimTo(partitionPathLen), columnName, partitionPathLen);
                }
                tops.add(columnTop);
            }
        } else if (tops.size() > columnCount) {
            tops.add(tops, tops.size() - columnCount - 1, tops.size() - 1);
            int n = tops.size();
            for (int i = tops.size() - columnCount; i < n; ++i) {
                if (tops.getQuick(i) <= 0L) continue;
                tops.setQuick(i, 0L);
            }
        } else {
            for (int i = 0; i < columnCount; ++i) {
                tops.add(-1L);
            }
        }
    }

    private static void setPathForPartition(Path path, int partitionBy, long timestamp, long partitionNameTxn) {
        PartitionBy.setSinkForPartition(path.slash(), partitionBy, timestamp, false);
        if (partitionNameTxn > -1L) {
            path.put('.').put(partitionNameTxn);
        }
    }

    private static ObjList<String> readColumNames(MemoryMARW metaMem) {
        ObjList<String> columnNames = new ObjList<String>();
        int columnCount = metaMem.getInt(0L);
        long offset = Mig620.getColumnNameOffset(columnCount);
        for (int metaIndex = 0; metaIndex < columnCount; ++metaIndex) {
            String name = Chars.toString(metaMem.getStr(offset));
            columnNames.add(name);
            offset += (long)Vm.getStorageLength(name);
        }
        return columnNames;
    }

    private static long getColumnNameOffset(int columnCount) {
        return 128L + (long)columnCount * 32L;
    }

    private static void migrateTxn(MemoryMARW txMemory, int symbolCount, int partitionTableSize, long existingTotalSize, long txn) {
        txMemory.putInt(64L, 0);
        txMemory.putInt(72L, 0);
        long pageAddress = txMemory.getPageAddress(0);
        Vect.memmove(pageAddress + (long)TX_BASE_HEADER_SIZE_MIG, pageAddress, existingTotalSize);
        Vect.memset(pageAddress, TX_BASE_HEADER_SIZE_MIG, 0);
        txMemory.putLong(0L, txn);
        boolean currentIsA = txn % 2L == 0L;
        long offsetOffset = currentIsA ? 8L : 32L;
        long symbolSizeOffset = currentIsA ? 12L : 36L;
        long partitionsSizeOffset = currentIsA ? 16L : 40L;
        txMemory.putInt(offsetOffset, TX_BASE_HEADER_SIZE_MIG);
        txMemory.putInt(symbolSizeOffset, symbolCount * 8);
        txMemory.putInt(partitionsSizeOffset, partitionTableSize);
        txMemory.jumpTo((long)TX_BASE_HEADER_SIZE_MIG + existingTotalSize);
    }

    private static MemoryCMARW openFileSafe(FilesFacade ff, Path path, long readOffset) {
        long fileLen = ff.length(path);
        if (fileLen < 0L) {
            throw CairoException.critical(ff.errno()).put("cannot read file length: ").put(path);
        }
        if (fileLen < readOffset + 8L) {
            throw CairoException.critical(0).put("File length ").put(fileLen).put(" is too small at ").put(path);
        }
        return Vm.getCMARWInstance(ff, path, Files.PAGE_SIZE, fileLen, 1, 0L);
    }

    private static void dFile(Path path, CharSequence columnName) {
        path.concat(columnName).put('.').put('d').$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readColumnTop(FilesFacade ff, Path path, CharSequence name, int plen) {
        try {
            if (ff.exists(Mig620.topFile(path.chop$(), name))) {
                long fd = Mig620.openRO(ff, path);
                try {
                    long n = ff.readULong(fd, 0L);
                    if (n < 0L) {
                        long l = 0L;
                        return l;
                    }
                    long l = n;
                    return l;
                }
                finally {
                    ff.close(fd);
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            path.trimTo(plen);
        }
    }

    private static long openRO(FilesFacade ff, LPSZ path) {
        long fd = ff.openRO(path);
        if (fd > -1L) {
            LOG.debug().$("open [file=").$(path).$(", fd=").$(fd).$(']').$();
            return fd;
        }
        throw CairoException.critical(ff.errno()).put("could not open read-only [file=").put(path).put(']');
    }

    private static LPSZ topFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".top").$();
    }
}

