/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.mig.Mig505;
import io.questdb.cairo.mig.Mig506;
import io.questdb.cairo.mig.Mig600;
import io.questdb.cairo.mig.Mig605;
import io.questdb.cairo.mig.Mig607;
import io.questdb.cairo.mig.Mig608;
import io.questdb.cairo.mig.Mig609;
import io.questdb.cairo.mig.Mig614;
import io.questdb.cairo.mig.Mig620;
import io.questdb.cairo.mig.MigrationAction;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class EngineMigration {
    private static final Log LOG = LogFactory.getLog(EngineMigration.class);
    private static final IntObjHashMap<MigrationAction> MIGRATIONS = new IntObjHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateEngineTo(CairoEngine engine, int latestVersion, boolean force) {
        block44: {
            FilesFacade ff = engine.getConfiguration().getFilesFacade();
            CairoConfiguration configuration = engine.getConfiguration();
            int tempMemSize = 8;
            long mem = Unsafe.malloc(tempMemSize, 1);
            try (MemoryARW virtualMem = Vm.getARWInstance(ff.getPageSize(), Integer.MAX_VALUE, 1);
                 Path path = new Path();
                 MemoryMARW rwMemory = Vm.getMARWInstance();){
                int currentVersion;
                MigrationContext context = new MigrationContext(engine, mem, tempMemSize, virtualMem, rwMemory);
                path.of(configuration.getRoot());
                path.concat("_upgrade.d").$();
                boolean existed = !force && ff.exists(path);
                long upgradeFd = TableUtils.openFileRWOrFail(ff, path, configuration.getWriterFileOpenOpts());
                LOG.debug().$("open [fd=").$(upgradeFd).$(", path=").$(path).$(']').$();
                if (existed && (currentVersion = TableUtils.readIntOrFail(ff, upgradeFd, 0L, mem, path)) >= latestVersion) {
                    LOG.info().$("table structures are up to date").$();
                    ff.close(upgradeFd);
                    upgradeFd = -1L;
                }
                if (upgradeFd == -1L) break block44;
                try {
                    LOG.info().$("upgrading database [version=").$(latestVersion).I$();
                    if (EngineMigration.upgradeTables(context, latestVersion)) {
                        TableUtils.writeIntOrFail(ff, upgradeFd, 0L, latestVersion, mem, path);
                    }
                }
                finally {
                    Vm.bestEffortClose(ff, LOG, upgradeFd, true, 4L);
                }
            }
            finally {
                Unsafe.free(mem, tempMemSize, 1);
            }
        }
    }

    @Nullable
    private static MigrationAction getMigrationToVersion(int version) {
        return MIGRATIONS.get(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void backupFile(FilesFacade ff, Path src, Path toTemp, String backupName, int version) {
        int copyPathLen = toTemp.length();
        try {
            toTemp.concat(backupName).put(".v").put(version);
            int i = 1;
            while (ff.exists(toTemp.$())) {
                LOG.info().$("backup dest exists [to=").$(toTemp).I$();
                toTemp.trimTo(copyPathLen);
                toTemp.concat(backupName).put(".v").put(version).put(".").put(i);
                ++i;
            }
            LOG.info().$("backing up [file=").$(src).$(",to=").$(toTemp).I$();
            if (ff.copy(src.$(), toTemp.$()) < 0) {
                throw CairoException.critical(ff.errno()).put("Cannot backup transaction file [to=").put(toTemp).put(']');
            }
        }
        finally {
            toTemp.trimTo(copyPathLen);
        }
    }

    private static boolean upgradeTables(MigrationContext context, int latestVersion) {
        FilesFacade ff = context.getFf();
        CharSequence root = context.getConfiguration().getRoot();
        long mem = context.getTempMemory(8);
        AtomicBoolean updateSuccess = new AtomicBoolean(true);
        try (Path path = new Path();
             Path copyPath = new Path();){
            path.of(root);
            copyPath.of(root);
            int rootLen = path.length();
            ff.iterateDir(path.$(), (pUtf8NameZ, type) -> {
                block9: {
                    if (Files.isDir(pUtf8NameZ, type)) {
                        path.trimTo(rootLen);
                        path.concat(pUtf8NameZ);
                        copyPath.trimTo(rootLen);
                        copyPath.concat(pUtf8NameZ);
                        int plen = path.length();
                        path.concat("_meta");
                        if (ff.exists(path.$())) {
                            long fd = TableUtils.openFileRWOrFail(ff, path, context.getConfiguration().getWriterFileOpenOpts());
                            try {
                                int currentTableVersion = TableUtils.readIntOrFail(ff, fd, 12L, mem, path);
                                if (currentTableVersion >= latestVersion) break block9;
                                LOG.info().$("upgrading [path=").$(path).$(",fromVersion=").$(currentTableVersion).$(",toVersion=").$(latestVersion).I$();
                                copyPath.trimTo(plen);
                                EngineMigration.backupFile(ff, path, copyPath, "_meta", currentTableVersion);
                                path.trimTo(plen);
                                context.of(path, copyPath, fd);
                                for (int ver = currentTableVersion + 1; ver <= latestVersion; ++ver) {
                                    MigrationAction migration = EngineMigration.getMigrationToVersion(ver);
                                    if (migration != null) {
                                        try {
                                            LOG.info().$("upgrading table [path=").$(path).$(",toVersion=").$(ver).I$();
                                            migration.migrate(context);
                                            path.trimTo(plen);
                                        }
                                        catch (Throwable e) {
                                            LOG.error().$("failed to upgrade table path=").$(path.trimTo(plen)).$(", exception: ").$(e).$();
                                            throw e;
                                        }
                                    }
                                    TableUtils.writeIntOrFail(ff, fd, 12L, ver, mem, path.trimTo(plen));
                                }
                            }
                            finally {
                                ff.close(fd);
                                path.trimTo(plen);
                                copyPath.trimTo(plen);
                            }
                        }
                    }
                }
            });
            LOG.info().$("upgraded tables to ").$(latestVersion).$();
        }
        return updateSuccess.get();
    }

    static {
        MIGRATIONS.put(417, Mig505::migrate);
        MIGRATIONS.put(418, Mig506::migrate);
        MIGRATIONS.put(419, Mig600::migrate);
        MIGRATIONS.put(420, Mig605::migrate);
        MIGRATIONS.put(422, Mig607::migrate);
        MIGRATIONS.put(423, Mig608::migrate);
        MIGRATIONS.put(424, Mig609::migrate);
        MIGRATIONS.put(425, Mig614::migrate);
        MIGRATIONS.put(426, Mig620::migrate);
    }
}

