/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.FastMap;
import io.questdb.cairo.map.FastMapRecord;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.std.Unsafe;

public final class FastMapCursor
implements RecordCursor {
    private final FastMapRecord recordA;
    private final MapRecord recordB;
    private final FastMap map;
    private int remaining;
    private long address;
    private long topAddress;
    private int count;

    FastMapCursor(FastMapRecord record, FastMap map) {
        this.recordA = record;
        this.recordB = record.clone();
        this.map = map;
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void close() {
        this.map.restoreInitialCapacity();
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public boolean hasNext() {
        if (this.remaining > 0) {
            long address = this.address;
            this.address = address + (long)Unsafe.getUnsafe().getInt(address);
            --this.remaining;
            this.recordA.of(address);
            return true;
        }
        return false;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        assert (record instanceof FastMapRecord);
        ((FastMapRecord)record).of(atRowId);
    }

    @Override
    public void toTop() {
        this.address = this.topAddress;
        this.remaining = this.count;
    }

    FastMapCursor init(long address, int count) {
        this.address = this.topAddress = address;
        this.remaining = this.count = count;
        return this;
    }
}

