/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.CompactMapValue;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;

public class CompactMapRecord
implements MapRecord {
    private final MemoryARW entries;
    private final long[] columnOffsets;
    private final CompactMapValue value;
    private long offset;
    private RecordCursor symbolTableResolver;
    private IntList symbolTableIndex;

    public CompactMapRecord(MemoryARW entries, long[] columnOffsets, CompactMapValue value) {
        this.entries = entries;
        this.columnOffsets = columnOffsets;
        this.value = value;
        this.value.linkRecord(this);
    }

    public CompactMapRecord clone() {
        return new CompactMapRecord(this.entries, this.columnOffsets, new CompactMapValue(this.entries, this.columnOffsets));
    }

    @Override
    public BinarySequence getBin(int col) {
        long o = this.getLong(col);
        if (o == -1L) {
            return null;
        }
        return this.entries.getBin(this.offset + o);
    }

    @Override
    public long getBinLen(int col) {
        long o = this.getLong(col);
        if (o == -1L) {
            return -1L;
        }
        return this.entries.getBinLen(this.offset + o);
    }

    @Override
    public boolean getBool(int col) {
        return this.entries.getBool(this.getColumnOffset(col));
    }

    @Override
    public byte getByte(int col) {
        return this.entries.getByte(this.getColumnOffset(col));
    }

    @Override
    public double getDouble(int col) {
        return this.entries.getDouble(this.getColumnOffset(col));
    }

    @Override
    public float getFloat(int col) {
        return this.entries.getFloat(this.getColumnOffset(col));
    }

    @Override
    public int getInt(int col) {
        return this.entries.getInt(this.getColumnOffset(col));
    }

    @Override
    public long getLong(int col) {
        return this.entries.getLong(this.getColumnOffset(col));
    }

    @Override
    public long getRowId() {
        return this.offset;
    }

    @Override
    public short getShort(int col) {
        return this.entries.getShort(this.getColumnOffset(col));
    }

    @Override
    public CharSequence getStr(int col) {
        long o = this.getLong(col);
        if (o == -1L) {
            return null;
        }
        return this.entries.getStr(this.offset + o);
    }

    @Override
    public CharSequence getStrB(int col) {
        long o = this.getLong(col);
        if (o == -1L) {
            return null;
        }
        return this.entries.getStr2(this.offset + o);
    }

    @Override
    public int getStrLen(int col) {
        long o = this.getLong(col);
        if (o == -1L) {
            return -1;
        }
        return this.entries.getStrLen(this.offset + o);
    }

    @Override
    public CharSequence getSym(int col) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(col)).valueOf(this.getInt(col));
    }

    @Override
    public CharSequence getSymB(int col) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(col)).valueBOf(this.getInt(col));
    }

    @Override
    public byte getGeoByte(int col) {
        return this.getByte(col);
    }

    @Override
    public short getGeoShort(int col) {
        return this.getShort(col);
    }

    @Override
    public int getGeoInt(int col) {
        return this.getInt(col);
    }

    @Override
    public long getGeoLong(int col) {
        return this.getLong(col);
    }

    @Override
    public MapValue getValue() {
        this.value.of(this.offset, false);
        return this.value;
    }

    @Override
    public void setSymbolTableResolver(RecordCursor resolver, IntList symbolTableIndex) {
        this.symbolTableResolver = resolver;
        this.symbolTableIndex = symbolTableIndex;
    }

    private long getColumnOffset(int columnIndex) {
        return this.offset + this.columnOffsets[columnIndex];
    }

    long getNextRecordOffset() {
        return this.entries.getLong(this.offset + 1L) + this.offset;
    }

    void of(long offset) {
        this.offset = offset;
    }
}

