/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.TableWriter;
import io.questdb.std.NumericException;

public class WriterRowUtils {
    private WriterRowUtils() {
    }

    public static void putGeoStr(int index, CharSequence hash, int type, TableWriter.Row row) {
        long val;
        if (hash != null) {
            int typeBits;
            int charsRequired;
            int hashLen = hash.length();
            if (hashLen < (charsRequired = ((typeBits = ColumnType.getGeoHashBits(type)) - 1) / 5 + 1)) {
                throw ImplicitCastException.inconvertibleValue(0, hash, 11, type);
            }
            try {
                val = GeoHashes.widen(GeoHashes.fromString(hash, 0, charsRequired), charsRequired * 5, typeBits);
            }
            catch (NumericException e) {
                throw ImplicitCastException.inconvertibleValue(0, hash, 11, type);
            }
        } else {
            val = -1L;
        }
        WriterRowUtils.putGeoHash(index, val, type, row);
    }

    public static void putGeoHash(int index, long value, int columnType, TableWriter.Row row) {
        switch (ColumnType.tagOf(columnType)) {
            case 14: {
                row.putByte(index, (byte)value);
                break;
            }
            case 15: {
                row.putShort(index, (short)value);
                break;
            }
            case 16: {
                row.putInt(index, (int)value);
                break;
            }
            default: {
                row.putLong(index, value);
            }
        }
    }
}

