/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.WalWriterRollStrategy;

public class WalWriterRollStrategyImpl
implements WalWriterRollStrategy {
    private long maxRowCount = Long.MAX_VALUE;
    private long maxSegmentSize = Long.MAX_VALUE;
    private long rollInterval = Long.MAX_VALUE;

    @Override
    public void setMaxSegmentSize(long maxSegmentSize) {
        if (maxSegmentSize < 1L) {
            throw CairoException.critical(-100).put("Max segment size cannot be less than 1 byte, maxSegmentSize=").put(maxSegmentSize);
        }
        this.maxSegmentSize = maxSegmentSize;
    }

    @Override
    public void setMaxRowCount(long maxRowCount) {
        if (maxRowCount < 1L) {
            throw CairoException.critical(-100).put("Max number of rows cannot be less than 1, maxRowCount=").put(maxRowCount);
        }
        this.maxRowCount = maxRowCount;
    }

    @Override
    public void setRollInterval(long rollInterval) {
        if (rollInterval < 1L) {
            throw CairoException.critical(-100).put("Roll interval cannot be less than 1 millisecond, rollInterval=").put(rollInterval);
        }
        this.rollInterval = rollInterval;
    }

    @Override
    public boolean shouldRoll(long segmentSize, long rowCount, long segmentAge) {
        return segmentSize >= this.maxSegmentSize || rowCount >= this.maxRowCount || segmentAge >= this.rollInterval;
    }

    @Override
    public boolean isMaxSegmentSizeSet() {
        return this.maxSegmentSize != Long.MAX_VALUE;
    }

    @Override
    public boolean isMaxRowCountSet() {
        return this.maxRowCount != Long.MAX_VALUE;
    }

    @Override
    public boolean isRollIntervalSet() {
        return this.rollInterval != Long.MAX_VALUE;
    }
}

