/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableDescriptor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.std.FilesFacade;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

class WalWriterMetadata
extends BaseRecordMetadata
implements Closeable {
    private final FilesFacade ff;
    private final MemoryMAR metaMem = Vm.getMARInstance();

    WalWriterMetadata(FilesFacade ff) {
        this.ff = ff;
        this.columnMetadata = new ObjList();
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
    }

    void of(TableDescriptor descriptor) {
        this.reset();
        this.timestampIndex = descriptor.getTimestampIndex();
        for (int i = 0; i < descriptor.getColumnCount(); ++i) {
            String name = descriptor.getColumnName(i);
            int type = descriptor.getColumnType(i);
            this.addColumn(i, name, type);
        }
    }

    private void reset() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
    }

    @Override
    public void close() {
        Misc.free(this.metaMem);
    }

    void addColumn(int columnIndex, CharSequence columnName, int columnType) {
        String name = columnName.toString();
        this.columnNameIndexMap.put(name, this.columnNameIndexMap.size());
        this.columnMetadata.add(new TableColumnMetadata(name, -1L, columnType, false, 0, false, null, columnIndex));
        ++this.columnCount;
    }

    void removeColumn(int columnIndex) {
        TableColumnMetadata deletedMeta = (TableColumnMetadata)this.columnMetadata.getQuick(columnIndex);
        deletedMeta.markDeleted();
    }

    void openMetaFile(Path path, int pathLen, int liveColumnCount) {
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, "_meta", 37);
        this.metaMem.putInt(0);
        this.metaMem.putInt(liveColumnCount);
        this.metaMem.putInt(this.timestampIndex);
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.getColumnType(i);
            this.metaMem.putInt(type);
            this.metaMem.putStr(this.getColumnName(i));
        }
    }
}

