/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

class WalWriterEvents
implements Closeable {
    private final FilesFacade ff;
    private final MemoryMARW eventMem = Vm.getMARWInstance();
    private ObjList<CharSequenceIntHashMap> txnSymbolMaps;
    private IntList initialSymbolCounts;

    WalWriterEvents(FilesFacade ff) {
        this.ff = ff;
    }

    void of(ObjList<CharSequenceIntHashMap> txnSymbolMaps, IntList initialSymbolCounts) {
        this.txnSymbolMaps = txnSymbolMaps;
        this.initialSymbolCounts = initialSymbolCounts;
    }

    @Override
    public void close() {
        Misc.free(this.eventMem);
    }

    void openEventFile(Path path, int pathLen) {
        TableUtils.openSmallFile(this.ff, path, pathLen, this.eventMem, "_event", 37);
        this.init();
    }

    private void writeSymbolMapDiffs() {
        int columns = this.txnSymbolMaps.size();
        for (int i = 0; i < columns; ++i) {
            CharSequenceIntHashMap symbolMap = this.txnSymbolMaps.getQuick(i);
            int initialCount = this.initialSymbolCounts.get(i);
            if (initialCount <= 0 && ((long)initialCount <= -1L || symbolMap.size() <= 0)) continue;
            this.eventMem.putInt(i);
            this.eventMem.putInt(initialCount);
            int size = symbolMap.size();
            this.eventMem.putInt(size);
            for (int j = 0; j < size; ++j) {
                CharSequence symbol = symbolMap.keys().getQuick(j);
                int value = symbolMap.get(symbol);
                this.eventMem.putInt(value);
                this.eventMem.putStr(symbol);
            }
            this.eventMem.putInt(-1);
            this.initialSymbolCounts.setQuick(i, initialCount + size);
            symbolMap.clear();
        }
        this.eventMem.putInt(-1);
    }

    void data(long txn, long startRowID, long endRowID, long minTimestamp, long maxTimestamp, boolean outOfOrder) {
        long startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(txn);
        this.eventMem.putByte((byte)0);
        this.eventMem.putLong(startRowID);
        this.eventMem.putLong(endRowID);
        this.eventMem.putLong(minTimestamp);
        this.eventMem.putLong(maxTimestamp);
        this.eventMem.putBool(outOfOrder);
        this.writeSymbolMapDiffs();
        this.eventMem.putInt(startOffset, (int)(this.eventMem.getAppendOffset() - startOffset));
        this.eventMem.putInt(-1);
    }

    void addColumn(long txn, int columnIndex, CharSequence columnName, int columnType) {
        long startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(txn);
        this.eventMem.putByte((byte)1);
        this.eventMem.putInt(columnIndex);
        this.eventMem.putStr(columnName);
        this.eventMem.putInt(columnType);
        this.eventMem.putInt(startOffset, (int)(this.eventMem.getAppendOffset() - startOffset));
        this.eventMem.putInt(-1);
    }

    void removeColumn(long txn, int columnIndex) {
        long startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(txn);
        this.eventMem.putByte((byte)2);
        this.eventMem.putInt(columnIndex);
        this.eventMem.putInt(startOffset, (int)(this.eventMem.getAppendOffset() - startOffset));
        this.eventMem.putInt(-1);
    }

    private void init() {
        this.eventMem.putInt(0);
        this.eventMem.putInt(-1);
    }
}

