/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.FilesFacade;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class WalReaderMetadata
extends BaseRecordMetadata
implements Closeable {
    private final FilesFacade ff;
    private final MemoryMR metaMem;

    public WalReaderMetadata(FilesFacade ff) {
        this.ff = ff;
        this.metaMem = Vm.getMRInstance();
        this.columnMetadata = new ObjList(this.columnCount);
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
    }

    @Override
    public void close() {
        Misc.free(this.metaMem);
    }

    public WalReaderMetadata of(Path path, int pathLen, long segmentId, int expectedVersion) {
        try {
            TableUtils.openSmallFile(this.ff, path.slash().put(segmentId), pathLen, this.metaMem, "_meta", 36);
            this.columnNameIndexMap.clear();
            TableUtils.loadWalMetadata(this.metaMem, this.columnMetadata, this.columnNameIndexMap, expectedVersion);
            this.columnCount = this.metaMem.getInt(4L);
            this.timestampIndex = this.metaMem.getInt(8L);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        return this;
    }
}

