/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.SymbolMapDiff;
import io.questdb.cairo.SymbolMapDiffCursor;
import io.questdb.cairo.SymbolMapDiffImpl;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;

public class WalEventCursor {
    public static final long END_OF_EVENTS = -1L;
    private final DataInfo dataInfo = new DataInfo();
    private final AddColumnInfo addColumnInfo = new AddColumnInfo();
    private final RemoveColumnInfo removeColumnInfo = new RemoveColumnInfo();
    private final MemoryMR eventMem;
    private long memSize;
    private long offset = 4L;
    private long txn = -1L;
    private byte type = (byte)-1;
    private long nextOffset = 4L;

    public WalEventCursor(MemoryMR eventMem) {
        this.eventMem = eventMem;
    }

    public boolean tryHasNext() {
        return this.nextOffset < this.memSize && (long)this.eventMem.getInt(this.nextOffset) != -1L;
    }

    public boolean hasNext() {
        this.offset = this.nextOffset;
        int length = this.readInt();
        if (length < 1) {
            return false;
        }
        this.nextOffset = (long)length + this.nextOffset;
        this.txn = this.readLong();
        if (this.txn == -1L) {
            return false;
        }
        this.type = this.readByte();
        switch (this.type) {
            case 0: {
                this.dataInfo.read();
                break;
            }
            case 1: {
                this.addColumnInfo.read();
                break;
            }
            case 2: {
                this.removeColumnInfo.read();
                break;
            }
            default: {
                throw CairoException.critical(-100).put("Unsupported WAL event type: ").put(this.type);
            }
        }
        return true;
    }

    public void reset() {
        this.memSize = this.eventMem.size();
        this.nextOffset = 4L;
        this.txn = -1L;
        this.type = (byte)-1;
    }

    public DataInfo getDataInfo() {
        if (this.type != 0) {
            throw CairoException.critical(-101).put("WAL event type is not DATA, type=").put(this.type);
        }
        return this.dataInfo;
    }

    public AddColumnInfo getAddColumnInfo() {
        if (this.type != 1) {
            throw CairoException.critical(-101).put("WAL event type is not ADD_COLUMN, type=").put(this.type);
        }
        return this.addColumnInfo;
    }

    public RemoveColumnInfo getRemoveColumnInfo() {
        if (this.type != 2) {
            throw CairoException.critical(-101).put("WAL event type is not REMOVE_COLUMN, type=").put(this.type);
        }
        return this.removeColumnInfo;
    }

    public long getTxn() {
        return this.txn;
    }

    public byte getType() {
        return this.type;
    }

    private long readLong() {
        this.checkMemSize(8L);
        long value = this.eventMem.getLong(this.offset);
        this.offset += 8L;
        return value;
    }

    private int readInt() {
        this.checkMemSize(4L);
        int value = this.eventMem.getInt(this.offset);
        this.offset += 4L;
        return value;
    }

    private byte readByte() {
        this.checkMemSize(1L);
        byte value = this.eventMem.getByte(this.offset);
        ++this.offset;
        return value;
    }

    private boolean readBool() {
        this.checkMemSize(1L);
        boolean value = this.eventMem.getBool(this.offset);
        ++this.offset;
        return value;
    }

    private CharSequence readStr() {
        this.checkMemSize(4L);
        int strLength = this.eventMem.getInt(this.offset);
        long storageLength = Vm.getStorageLength(strLength);
        this.checkMemSize(storageLength);
        CharSequence value = this.eventMem.getStr(this.offset);
        this.offset += storageLength;
        return value;
    }

    SymbolMapDiff readNextSymbolMapDiff(SymbolMapDiffImpl symbolMapDiff) {
        int columnIndex = this.readInt();
        if (columnIndex == -1) {
            return null;
        }
        int cleanTableSymbolCount = this.readInt();
        int size = this.readInt();
        symbolMapDiff.of(columnIndex, cleanTableSymbolCount, size);
        return symbolMapDiff;
    }

    SymbolMapDiffImpl.Entry readNextSymbolMapDiffEntry(SymbolMapDiffImpl.Entry entry) {
        int key = this.readInt();
        if (key == -1) {
            entry.clear();
            return null;
        }
        CharSequence symbol = this.readStr();
        entry.of(key, symbol);
        return entry;
    }

    private void checkMemSize(long requiredBytes) {
        if (this.memSize < this.offset + requiredBytes) {
            throw CairoException.critical(0).put("WAL event file is too small, size=").put(this.memSize).put(", required=").put(this.offset + requiredBytes);
        }
    }

    public class RemoveColumnInfo {
        private int columnIndex;

        private void read() {
            this.columnIndex = WalEventCursor.this.readInt();
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }
    }

    public class AddColumnInfo {
        private int columnIndex;
        private CharSequence columnName;
        private int columnType;

        private void read() {
            this.columnIndex = WalEventCursor.this.readInt();
            this.columnName = WalEventCursor.this.readStr();
            this.columnType = WalEventCursor.this.readInt();
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public CharSequence getColumnName() {
            return this.columnName;
        }

        public int getColumnType() {
            return this.columnType;
        }
    }

    public class DataInfo
    implements SymbolMapDiffCursor {
        private final SymbolMapDiffImpl symbolMapDiff;
        private long startRowID;
        private long endRowID;
        private long minTimestamp;
        private long maxTimestamp;
        private boolean outOfOrder;

        public DataInfo() {
            this.symbolMapDiff = new SymbolMapDiffImpl(WalEventCursor.this);
        }

        private void read() {
            this.startRowID = WalEventCursor.this.readLong();
            this.endRowID = WalEventCursor.this.readLong();
            this.minTimestamp = WalEventCursor.this.readLong();
            this.maxTimestamp = WalEventCursor.this.readLong();
            this.outOfOrder = WalEventCursor.this.readBool();
        }

        public long getStartRowID() {
            return this.startRowID;
        }

        public long getEndRowID() {
            return this.endRowID;
        }

        public long getMinTimestamp() {
            return this.minTimestamp;
        }

        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }

        public boolean isOutOfOrder() {
            return this.outOfOrder;
        }

        @Override
        public SymbolMapDiff nextSymbolMapDiff() {
            return WalEventCursor.this.readNextSymbolMapDiff(this.symbolMapDiff);
        }
    }
}

