/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryW;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;

public class TxReader
implements Closeable,
Mutable {
    protected static final int PARTITION_TS_OFFSET = 0;
    protected static final int PARTITION_SIZE_OFFSET = 1;
    protected static final int PARTITION_NAME_TX_OFFSET = 2;
    protected static final int PARTITION_COLUMN_VERSION_OFFSET = 3;
    protected static final long DEFAULT_PARTITION_TIMESTAMP = 0L;
    protected final LongList attachedPartitions = new LongList();
    private final IntList symbolCountSnapshot = new IntList();
    private final FilesFacade ff;
    protected long minTimestamp;
    protected long maxTimestamp;
    protected long txn;
    protected int symbolColumnCount;
    protected long truncateVersion;
    protected long dataVersion;
    protected long structureVersion;
    protected long fixedRowCount;
    protected long transientRowCount;
    protected int partitionBy;
    protected long partitionTableVersion;
    protected int attachedPartitionsSize = 0;
    protected long columnVersion;
    private PartitionBy.PartitionFloorMethod partitionFloorMethod;
    private MemoryMR roTxMemBase;
    private int baseOffset;
    private long size;
    private long version;
    private int symbolsSize;
    private int partitionSegmentSize;

    public TxReader(FilesFacade ff) {
        this.ff = ff;
    }

    public boolean attachedPartitionsContains(long ts) {
        return this.findAttachedPartitionIndex(ts) > -1;
    }

    @Override
    public void clear() {
        this.clearData();
        if (this.roTxMemBase != null) {
            this.roTxMemBase.close();
        }
    }

    @Override
    public void close() {
        this.roTxMemBase = Misc.free(this.roTxMemBase);
        this.clear();
    }

    public void dumpTo(MemoryW mem) {
        mem.putLong(0L, this.version);
        boolean isA = (this.version & 1L) == 0L;
        int baseOffset = TableUtils.TX_BASE_HEADER_SIZE;
        mem.putInt(isA ? 8L : 32L, baseOffset);
        mem.putInt(isA ? 12L : 36L, this.symbolsSize);
        mem.putInt(isA ? 16L : 40L, this.partitionSegmentSize);
        mem.putLong((long)baseOffset + 0L, this.txn);
        mem.putLong((long)baseOffset + 8L, this.transientRowCount);
        mem.putLong((long)baseOffset + 16L, this.fixedRowCount);
        mem.putLong((long)baseOffset + 24L, this.minTimestamp);
        mem.putLong((long)baseOffset + 32L, this.maxTimestamp);
        mem.putLong((long)baseOffset + 48L, this.dataVersion);
        mem.putLong((long)baseOffset + 40L, this.structureVersion);
        mem.putLong((long)baseOffset + 56L, this.partitionTableVersion);
        mem.putLong((long)baseOffset + 64L, this.columnVersion);
        mem.putLong((long)baseOffset + 72L, this.truncateVersion);
        mem.putInt((long)baseOffset + 128L, this.symbolColumnCount);
        int symbolMapCount = this.symbolCountSnapshot.size();
        for (int i = 0; i < symbolMapCount; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            int symCount = this.symbolCountSnapshot.getQuick(i);
            mem.putInt((long)baseOffset + offset, symCount);
            mem.putInt((long)baseOffset + (offset += 4L), symCount);
        }
        int size = this.attachedPartitions.size();
        long partitionTableOffset = TableUtils.getPartitionTableSizeOffset(symbolMapCount);
        mem.putInt((long)baseOffset + partitionTableOffset, size * 8);
        for (int i = 0; i < size; ++i) {
            long offset = TableUtils.getPartitionTableIndexOffset(partitionTableOffset, i);
            mem.putLong((long)baseOffset + offset, this.attachedPartitions.getQuick(i));
        }
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public long getColumnVersion() {
        return this.columnVersion;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public long getFixedRowCount() {
        return this.fixedRowCount;
    }

    public long getLastPartitionTimestamp() {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            return this.getPartitionTimestampLo(this.maxTimestamp);
        }
        return 0L;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public long getPartitionColumnVersion(int i) {
        return this.getPartitionColumnVersionByIndex(i * 4);
    }

    public long getPartitionColumnVersionByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 3);
    }

    public int getPartitionCount() {
        return this.attachedPartitions.size() / 4;
    }

    public int getPartitionIndex(long ts) {
        int index = this.findAttachedPartitionIndexByLoTimestamp(this.getPartitionTimestampLo(ts));
        if (index > -1) {
            return index / 4;
        }
        return -1;
    }

    public long getPartitionNameTxn(int i) {
        return this.getPartitionNameTxnByIndex(i * 4);
    }

    public long getPartitionNameTxnByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 2);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long ts) {
        return this.getPartitionNameTxnByPartitionTimestamp(ts, -1L);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long ts, long defaultValue) {
        int index = this.findAttachedPartitionIndex(ts);
        if (index > -1) {
            return this.attachedPartitions.getQuick(index + 2);
        }
        return defaultValue;
    }

    public long getPartitionSize(int i) {
        return this.getPartitionSizeByIndex(i * 4);
    }

    public long getPartitionSizeByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 1);
    }

    public long getPartitionSizeByPartitionTimestamp(long ts) {
        int index = this.findAttachedPartitionIndex(ts);
        if (index > -1) {
            return this.attachedPartitions.getQuick(index + 1);
        }
        return -1L;
    }

    public long getPartitionTableVersion() {
        return this.partitionTableVersion;
    }

    public long getPartitionTimestamp(int i) {
        return this.attachedPartitions.getQuick(i * 4 + 0);
    }

    public long getRecordSize() {
        return this.size;
    }

    public long getRowCount() {
        return this.transientRowCount + this.fixedRowCount;
    }

    public long getStructureVersion() {
        return this.structureVersion;
    }

    public int getSymbolColumnCount() {
        return this.symbolColumnCount;
    }

    public int getSymbolValueCount(int i) {
        return this.symbolCountSnapshot.get(i);
    }

    public long getTransientRowCount() {
        return this.transientRowCount;
    }

    public long getTruncateVersion() {
        return this.truncateVersion;
    }

    public long getTxn() {
        return this.txn;
    }

    public long getVersion() {
        return this.version;
    }

    public void initRO(MemoryMR txnFile, int partitionBy) {
        this.roTxMemBase = txnFile;
        this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
        this.partitionBy = partitionBy;
    }

    public TxReader ofRO(LPSZ path, int partitionBy) {
        this.clear();
        try {
            this.openTxnFile(this.ff, path);
            this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
            this.partitionBy = partitionBy;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        return this;
    }

    public boolean unsafeLoadAll() {
        if (this.unsafeLoadBaseOffset()) {
            this.txn = this.version;
            if (this.txn != this.getLong(0L)) {
                return false;
            }
            this.transientRowCount = this.getLong(8L);
            this.fixedRowCount = this.getLong(16L);
            this.minTimestamp = this.getLong(24L);
            this.maxTimestamp = this.getLong(32L);
            this.dataVersion = this.getLong(48L);
            this.structureVersion = this.getLong(40L);
            long prevPartitionTableVersion = this.partitionTableVersion;
            this.partitionTableVersion = this.getLong(56L);
            long prevColumnVersion = this.columnVersion;
            this.columnVersion = this.unsafeReadColumnVersion();
            this.truncateVersion = this.getLong(72L);
            this.symbolColumnCount = this.symbolsSize / 8;
            this.unsafeLoadSymbolCounts(this.symbolColumnCount);
            this.unsafeLoadPartitions(prevPartitionTableVersion, prevColumnVersion, this.partitionSegmentSize);
            Unsafe.getUnsafe().loadFence();
            if (this.version == this.unsafeReadVersion()) {
                return true;
            }
        }
        this.clearData();
        return false;
    }

    public boolean unsafeLoadBaseOffset() {
        this.version = this.unsafeReadVersion();
        Unsafe.getUnsafe().loadFence();
        boolean isA = (this.version & 1L) == 0L;
        this.baseOffset = isA ? this.roTxMemBase.getInt(8L) : this.roTxMemBase.getInt(32L);
        this.symbolsSize = isA ? this.roTxMemBase.getInt(12L) : this.roTxMemBase.getInt(36L);
        this.partitionSegmentSize = isA ? this.roTxMemBase.getInt(16L) : this.roTxMemBase.getInt(40L);
        Unsafe.getUnsafe().loadFence();
        if (this.unsafeReadVersion() != this.version) {
            return false;
        }
        this.size = TxReader.calculateTxRecordSize(this.symbolsSize, this.partitionSegmentSize);
        if (this.size + (long)this.baseOffset > this.roTxMemBase.size()) {
            this.roTxMemBase.extend(this.size + (long)this.baseOffset);
        }
        return true;
    }

    public long unsafeReadColumnVersion() {
        return this.getLong(64L);
    }

    public int unsafeReadSymbolColumnCount() {
        return this.getInt(128L);
    }

    public int unsafeReadSymbolCount(int symbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterIndexOffset(symbolIndex));
    }

    public int unsafeReadSymbolTransientCount(int symbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterTransientIndexOffset(symbolIndex));
    }

    public long unsafeReadVersion() {
        return this.roTxMemBase.getLong(0L);
    }

    static int calculateTxRecordSize(int bytesSymbols, int bytesPartitions) {
        return 136 + bytesSymbols + 4 + bytesPartitions;
    }

    private void clearData() {
        this.baseOffset = 0;
        this.size = 0L;
        this.partitionTableVersion = -1L;
        this.attachedPartitionsSize = -1;
        this.attachedPartitions.clear();
        this.version = -1L;
        this.txn = -1L;
    }

    private int findAttachedPartitionIndex(long ts) {
        return this.findAttachedPartitionIndexByLoTimestamp(this.getPartitionTimestampLo(ts));
    }

    int findAttachedPartitionIndexByLoTimestamp(long ts) {
        return this.attachedPartitions.binarySearchBlock(TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, ts, -1);
    }

    private int getInt(long readOffset) {
        assert (readOffset + 4L <= this.size) : "offset " + readOffset + ", size " + this.size + ", txn=" + this.txn;
        return this.roTxMemBase.getInt((long)this.baseOffset + readOffset);
    }

    private long getLong(long readOffset) {
        assert (readOffset + 8L <= this.size) : "offset " + readOffset + ", size " + this.size + ", txn=" + this.txn;
        return this.roTxMemBase.getLong((long)this.baseOffset + readOffset);
    }

    protected long getPartitionTimestampLo(long timestamp) {
        return this.partitionFloorMethod != null ? (timestamp != Long.MIN_VALUE ? this.partitionFloorMethod.floor(timestamp) : Long.MIN_VALUE) : 0L;
    }

    protected void initPartitionAt(int index, long partitionTimestampLo, long partitionSize, long partitionNameTxn, long columnVersion) {
        this.attachedPartitions.setQuick(index + 0, partitionTimestampLo);
        this.attachedPartitions.setQuick(index + 1, partitionSize);
        this.attachedPartitions.setQuick(index + 2, partitionNameTxn);
        this.attachedPartitions.setQuick(index + 3, columnVersion);
    }

    private void openTxnFile(FilesFacade ff, LPSZ path) {
        if (ff.exists(path)) {
            if (this.roTxMemBase == null) {
                this.roTxMemBase = Vm.getMRInstance(ff, path, ff.length(path), 0);
            } else {
                this.roTxMemBase.of(ff, path, ff.getPageSize(), ff.length(path), 0);
            }
            return;
        }
        throw CairoException.critical(ff.errno()).put("Cannot append. File does not exist: ").put(path);
    }

    protected void switchRecord(int readBaseOffset, long readRecordSize) {
        this.baseOffset = readBaseOffset;
        this.size = readRecordSize;
    }

    protected long unsafeGetRawMemory() {
        return this.roTxMemBase.getPageAddress(0);
    }

    protected long unsafeGetRawMemorySize() {
        return this.size + (long)this.baseOffset;
    }

    private void unsafeLoadPartitions(long prevPartitionTableVersion, long prevColumnVersion, int partitionTableSize) {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            int txAttachedPartitionsSize = partitionTableSize / 8;
            if (txAttachedPartitionsSize > 0) {
                if (prevPartitionTableVersion != this.partitionTableVersion || prevColumnVersion != this.columnVersion) {
                    this.attachedPartitions.clear();
                    this.unsafeLoadPartitions0(txAttachedPartitionsSize, 0);
                } else if (this.attachedPartitionsSize < txAttachedPartitionsSize) {
                    this.unsafeLoadPartitions0(txAttachedPartitionsSize, Math.max(this.attachedPartitionsSize - 4, 0));
                }
                this.attachedPartitions.setQuick(txAttachedPartitionsSize - 4 + 1, this.transientRowCount);
            } else {
                this.attachedPartitionsSize = 0;
                this.attachedPartitions.clear();
            }
        } else {
            this.attachedPartitions.setPos(4);
            this.initPartitionAt(0, 0L, this.transientRowCount, -1L, this.columnVersion);
        }
    }

    private void unsafeLoadPartitions0(int txAttachedPartitionsSize, int max) {
        this.attachedPartitions.setPos(txAttachedPartitionsSize);
        for (int i = max; i < txAttachedPartitionsSize; ++i) {
            this.attachedPartitions.setQuick(i, this.getLong(TableUtils.getPartitionTableIndexOffset(this.symbolColumnCount, i)));
        }
        this.attachedPartitionsSize = txAttachedPartitionsSize;
    }

    private void unsafeLoadSymbolCounts(int symbolMapCount) {
        this.symbolCountSnapshot.clear();
        for (int i = 0; i < symbolMapCount; ++i) {
            this.symbolCountSnapshot.add(this.getInt(TableUtils.getSymbolWriterIndexOffset(i)));
        }
    }

    protected long unsafeReadFixedRowCount() {
        return this.getLong(16L);
    }

    protected int unsafeReadSymbolWriterIndexOffset(int denseSymbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterIndexOffset(denseSymbolIndex));
    }
}

