/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.ObjList;

public class TableWriterMetadata
extends BaseRecordMetadata {
    private int id;
    private int metaFileSize;
    private int symbolMapCount;
    private int version;
    private int maxUncommittedRows;
    private long commitLag;
    private long structureVersion;

    public TableWriterMetadata(MemoryMR metaMem) {
        this.reload(metaMem);
    }

    public void reload(MemoryMR metaMem) {
        this.columnCount = metaMem.getInt(0L);
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap(this.columnCount);
        this.version = metaMem.getInt(12L);
        this.id = metaMem.getInt(16L);
        this.maxUncommittedRows = metaMem.getInt(20L);
        this.commitLag = metaMem.getLong(24L);
        TableUtils.validateMeta(metaMem, this.columnNameIndexMap, 426);
        this.timestampIndex = metaMem.getInt(8L);
        this.columnMetadata = new ObjList(this.columnCount);
        this.structureVersion = metaMem.getLong(32L);
        long offset = TableUtils.getColumnNameOffset(this.columnCount);
        this.symbolMapCount = 0;
        this.columnNameIndexMap.clear();
        for (int i = 0; i < this.columnCount; ++i) {
            CharSequence name = metaMem.getStr(offset);
            assert (name != null);
            int type = TableUtils.getColumnType(metaMem, i);
            String nameStr = Chars.toString(name);
            this.columnMetadata.add(new TableColumnMetadata(nameStr, TableUtils.getColumnHash(metaMem, i), type, TableUtils.isColumnIndexed(metaMem, i), TableUtils.getIndexBlockCapacity(metaMem, i), true, null, i));
            this.columnNameIndexMap.put(nameStr, i);
            if (ColumnType.isSymbol(type)) {
                ++this.symbolMapCount;
            }
            offset += (long)Vm.getStorageLength(name);
        }
        this.metaFileSize = (int)offset;
    }

    public long getCommitLag() {
        return this.commitLag;
    }

    public int getDenseColumnCount() {
        int count = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (((TableColumnMetadata)this.columnMetadata.getQuick(i)).getType() <= 0) continue;
            ++count;
        }
        return count;
    }

    public void setCommitLag(long micros) {
        this.commitLag = micros;
    }

    public int getFileDataSize() {
        return this.metaFileSize;
    }

    public int getId() {
        return this.id;
    }

    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    public void setMaxUncommittedRows(int rows) {
        this.maxUncommittedRows = rows;
    }

    public long getStructureVersion() {
        return this.structureVersion;
    }

    public void setStructureVersion(long value) {
        this.structureVersion = value;
    }

    public int getSymbolMapCount() {
        return this.symbolMapCount;
    }

    public int getTableVersion() {
        return this.version;
    }

    public void setTableVersion() {
        this.version = 426;
    }

    public GenericRecordMetadata copyDense() {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        for (int i = 0; i < this.columnCount; ++i) {
            TableColumnMetadata column = (TableColumnMetadata)this.columnMetadata.getQuick(i);
            if (column.getType() < 0) continue;
            metadata.add(column);
            if (i != this.timestampIndex) continue;
            metadata.setTimestampIndex(metadata.getColumnCount() - 1);
        }
        return metadata;
    }

    void addColumn(CharSequence name, long hash, int type, boolean indexFlag, int indexValueBlockCapacity, int columnIndex) {
        String str = name.toString();
        this.columnNameIndexMap.put(str, this.columnMetadata.size());
        this.columnMetadata.add(new TableColumnMetadata(str, hash, type, indexFlag, indexValueBlockCapacity, true, null, columnIndex));
        ++this.columnCount;
        if (ColumnType.isSymbol(type)) {
            ++this.symbolMapCount;
        }
    }

    void removeColumn(int columnIndex) {
        TableColumnMetadata deletedMeta = (TableColumnMetadata)this.columnMetadata.getQuick(columnIndex);
        if (ColumnType.isSymbol(deletedMeta.getType())) {
            --this.symbolMapCount;
        }
        deletedMeta.markDeleted();
        this.columnNameIndexMap.remove(deletedMeta.getName());
    }

    void renameColumn(CharSequence name, CharSequence newName) {
        int columnIndex = this.columnNameIndexMap.removeEntry(name);
        this.columnNameIndexMap.put(newName, columnIndex);
        TableColumnMetadata oldColumnMetadata = (TableColumnMetadata)this.columnMetadata.get(columnIndex);
        oldColumnMetadata.setName(Chars.toString(newName));
    }

    void setTimestampIndex(int index) {
        this.timestampIndex = index;
    }
}

